/*
  koi8-r to alternative charsets recoding routines
*/

char a2k_tbl[] = { 0xE1, 0xE2, 0xF7, 0xE7, 0xE4, 0xE5, 0xF6, 0xFA, 0xE9, 0xEA,
0xEB, 0xEC, 0xED, 0xEE, 0xEF, 0xF0, 0xF2, 0xF3, 0xF4, 0xF5, 0xE6, 0xE8, 0xE3,
0xFE, 0xFB, 0xFD, 0xFF, 0xF9, 0xF8, 0xFC, 0xE0, 0xF1, 0xC1, 0xC2, 0xD7, 0xC7,
0xC4, 0xC5, 0xD6, 0xDA, 0xC9, 0xCA, 0xCB, 0xCC, 0xCD, 0xCE, 0xCF, 0xD0, 0x80,
0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0xBA, 0x8B, 0x8C, 0x8D,
0x8E, 0x8F, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A,
0xBF, 0x9C, 0x9D, 0x9E, 0x9F, 0xB9, 0xA1, 0xA2, 0xB0, 0xA4, 0xA5, 0xA6, 0xA7,
0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF, 0xD2, 0xD3, 0xD4, 0xD5, 0xC6,
0xC8, 0xC3, 0xDE, 0xDB, 0xDD, 0xDF, 0xD9, 0xD8, 0xDC, 0xC0, 0xD1, 0xB3, 0xA3,
0xB2, 0xB1, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8, 0xA0, 0x8A, 0xBB, 0xBC, 0xBD, 0xBE,
0x9B };

char	k2a_tbl[] = { 0xB0, 0xB1, 0xB2, 0xB3, 0xB4, 0xB5, 0xB6, 0xB7, 0xB8,
0xB9, 0xFA, 0xBB, 0xBC, 0xBD, 0xBE, 0xBF, 0xC0, 0xC1, 0xC2, 0xC3, 0xC4, 0xC5,
0xC6, 0xC7, 0xC8, 0xC9, 0xCA, 0xFF, 0xCC, 0xCD, 0xCE, 0xCF, 0xD0, 0xD1, 0xD2,
0xF1, 0xD4, 0xD5, 0xD6, 0xD7, 0xD8, 0xD9, 0xDA, 0xDB, 0xDC, 0xDD, 0xDE, 0xDF,
0xD3, 0xF3, 0xF2, 0xF0, 0xF4, 0xF5, 0xF6, 0xF7, 0xF8, 0xD0, 0xBA, 0xFB, 0xFC,
0xFD, 0xFE, 0xCB, 0xEE, 0xA0, 0xA1, 0xE6, 0xA4, 0xA5, 0xE4, 0xA3, 0xE5, 0xA8,
0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF, 0xEF, 0xE0, 0xE1, 0xE2, 0xE3, 0xA6,
0xA2, 0xEC, 0xEB, 0xA7, 0xE8, 0xED, 0xE9, 0xE7, 0xEA, 0x9E, 0x80, 0x81, 0x96,
0x84, 0x85, 0x94, 0x83, 0x95, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x48, 0x8E, 0x8F,
0x9F, 0x90, 0x91, 0x92, 0x93, 0x86, 0x82, 0x9C, 0x9B, 0x87, 0x98, 0x9D, 0x99,
0x97, 0x9A };

void a2k(unsigned char *data,long len)
{
  long i;
  for(i=0;i<len;i++) if(data[i]>0x7F) data[i]=a2k_tbl[data[i]-0x80];
}

void k2a(unsigned char *data,long len)
{
  long i;
  for(i=0;i<len;i++) if(data[i]>0x7F) data[i]=k2a_tbl[data[i]-0x80];
}
