
sub WriteAreas {
	local( $handle, $Area, $i, $st );
	@st = stat( $FConfig{'AREAS'} );
	if( ! rename( $FConfig{'AREAS'}, $FConfig{'AREAS'}.".bak" )) {
		&logger( 0, "Cannot rename Areas to Areas.bak.", "err" );
		return 0;
	}
	if( ! open( handle, ">".$FConfig{'AREAS'} )) {
		&logger( 0, "Cannot write to Areas file.", "err" );
		return 0;
	}
	for( $i = 0; $i <= $#AreaName; $i++ ) {
		$Area = $AreaName[$i];
		print handle "Area\t$Area\n";
		print handle "Desc\t$AreaDesc{$Area}\n" if( defined( $AreaDesc{$Area} ));
		print handle "Group\t$AreaGroup{$Area}\n" if( defined( $AreaGroup{$Area} ));
		print handle "Path\t$AreaPath{$Area}\n" if( defined( $AreaPath{$Area} ));
		print handle "Exec\t$AreaExec{$Area}\n" if( defined( $AreaExec{$Area} ));
		print handle "Exclude\t$AreaExclude{$Area}\n" if( defined( $AreaExclude{$Area} ));
		print handle "Save\t$AreaSave{$Area}\n" if( defined( $AreaSave{$Area} ));
		print handle "Links\t$AreaLinks{$Area}\n" if( defined( $AreaLinks{$Area} ));
		print handle "AKA\t$AreaAKA{$Area}\n" if( defined( $AreaAKA{$Area} ));
		print handle "Newfile\t$AreaNewfile{$Area}\n" if( defined( $AreaNewfile{$Area} ));
		print handle "Mode\t$AreaMode{$Area}\n" if( defined( $AreaMode{$Area} ));
		print handle "ReadOnly\t$AreaRO{$Area}\n" if( defined( $AreaRO{$Area} ));
		print handle "DupeCheck\t$AreaDupes{$Area}\n" if( defined( $AreaDupes{$Area} ));
		print handle "NoCheck\t$AreaNocheck{$Area}\n" if( defined( $AreaNocheck{$Area} ));
		print handle "-" x 70;
		print handle "\n";
	}
	close( handle );
	chmod $st[2], $FConfig{'AREAS'};
	chown $st[4], $st[5], $FConfig{'AREAS'};
	&logger( 7, "Write Areas Ok.", "info" );
	return 1;
}
