
# @UserAddr
# %UserPasswd
# %UserName
# %UserGroups
# %UserFlags
#

sub ReadUsers {
	local( $handle, $Addr, $Passwd, $Name, $Groups, $Flags, $dg );
	if( ! &TestConfig( 'USERS' )) {
		&logger( 0, "Undefined Users in config file.", "err" );
		return 0;
	}
	if( ! open( handle, $FConfig{'USERS'} )) {
		&logger( 0, "Cannot open Users file.", "err" );
		return 0;
	}
	while( <handle> ) {
		/^[ \t]*$/	&& next;
		/^[ \t]*#/	&& next;
		chop;
		( $Addr, $Passwd, $Name, $Groups, $Flags ) = split( /[ \t]+/, $_, 5 );
		$UserAddr[$#UserAddr + 1] = $Addr;
		$UserPasswd{$Addr} = $Passwd;
		$UserName{$Addr} = $Name;
		$dg="";
		if( &TestConfig( 'DEFGROUP' )) {
			$dg = $FConfig{'DEFGROUP'};
		}
		$Groups =~ s/\*/$dg/g;
		
		$UserGroups{$Addr} = $Groups;
		$UserFlags{$Addr} = $Flags;
	}
	close( handle );
	&logger( 7, "Read Users Ok.", "info" );
	return 1;
}
