#!/usr/bin/perl

$ConfigFile = "/usr/local/lib/ifmail/filefix/config";

$Version = "FileFix v1.8.3";

#main {
	if( $] < 5 ) {
		print STDERR "Sorry, $Version worked only with Perl v5.xxx.\n";
		exit 1;
	}
	if( $ARGV[0] =~ /^-t$/ ) {
		&ReadConfig( "toss" ) || die "Bad config file.";
		&SetLock();
		&Tosser();
		&UnsetLock();
		&CloseLog();
	} elsif( $ARGV[0] =~ /^-m$/ ) {
		&ReadConfig( "mgr" ) || die "Bad config file.";
		&SetLock();
		&Manager();
		&UnsetLock();
		&CloseLog();
	} elsif( $ARGV[0] =~ /^-s$/ ) {
		&ReadConfig( "scan" ) || die "Bad config file.";
		&SetLock();
		&Scaner();
		&UnsetLock();
		&CloseLog();
	} elsif( $ARGV[0] =~ /^-n$/ ) {
		&ReadConfig( "name" ) || die "Bad config file.";
		if( &TestConfig( "ECHOLIST" )) {
			&SetLock();
			&Namer();
			&UnsetLock();
		} else {
			&logger( 0, "EchoList not defined in config file.", "warning" );
		}
		&CloseLog();
	} else {
		print "Usage: filefix -[m|t|s|n]\n\t-t - tosser\n\t-m - manager\n\t-s - scanner\n\t-n - set fileecho names\n";
		exit 1;
	}
# }

