#!/usr/local/bin/perl

# $Id: talkuser.pl,v 1.4 1997/11/24 01:14:27 crosser Exp $
#
# $Log: talkuser.pl,v $
# Revision 1.4  1997/11/24 01:14:27  crosser
# change message according to new restrictions
#
# Revision 1.3  1997/11/23 23:47:22  crosser
# add comment
#

# User info interface for fido7 "automoderator"
# Copyright (c) 1997 Eugene G. Crosser

$BOUNDARY="========== multipart message boundary ==========";

sub sendhello {
	local($sender,$challenge,$deny)=@_;
	print <<__END__
To: $sender
From: Fido7 Auto Registration Facility $OPER
Reply-To: "Do not reply, write a new message" :;
Subject: Greetings from fido7 gateway
MIME-Version: 1.0
Content-Type: multipart/mixed; boundary="$BOUNDARY"

--$BOUNDARY
Content-Type: text/plain; charset=us-ascii; language=en
Content-Transfer-Encoding: 7bit
Content-Language: en

Dear madam or sir!

You are reading an automated reply from the fido7 automoderator; this is
the first part of the three-part MIME message; second part is in
Russian.  Your article (attached as the third part of this message),
posted from the address:

	$sender

did not pass to the newsgroup for the following reason:

	$deny

Fido7 is not a normal usenet hierarchy, it is Russian-language ECHOMAIL
gatewayed from FidoNet(r).  If you do not speak Russian, you do not want
to post to any of fido7 newsgroups.  If you do, please read the next
(second) part of this message.

To learn what fido7 hierarchy is, please see:

	http://www.fido7.ru/

If you have further questions, please contact the gatekeeper:

	$OPER

Thank you.

--
Gatekeeper

--$BOUNDARY
Content-Type: text/plain; charset=koi8-r; language=ru
Content-Transfer-Encoding: 8bit
Content-Language: ru

 ,   -   fido7    
   Fidonet,      
 .        fido7   , 
    .  Fido7 -   
 ,       Fidonet.
   ,  , :

1.        .
    ,    ** ,
       ** .  ,
            
         .

2.       fido7   ,   
   ,       .  
    ,         .
        .      
        ţ     ,
        .

3.  "From:"       
        .     
   "root", "admin"  ..

4. ,       () 
    (       ).  
         
   .

5.   ,    ,  ,  
    .      .

6.    .  ,    
     . ,   E-mail   
         .   
        .

7.      ">"   -
     -    .

8.   ,  - ,   
    "".

,   ,     
,    ,    fido7  
.

 ,        ,
   ,   usa.net, hotmail.com 
.     ,     
         
.          
 "$BADDOM",
     ,   ""
,      $OPER, , ,  
  "".

     ,  e-mail  :

	$REGADDR

          "
": $challenge.       e-mail-
  ,       
( )    .   ,
       From:  , 
     Reply-To:.

:       ,  
 "From:"  ""   **  
 ,     ,   "$sender".  
    -   ,
 , ,    
"john\@somehost.acme.com", a    -  
"john\@acme.com".    .

 :        
$OPER!      .   
    $REGADDR.

    , ,  
  .    , ţ    
()   .

--
     fido7 $OPER

--$BOUNDARY
Content-Type: message/news

__END__
}

sub closehello {
	print "--$BOUNDARY--\n";
}

sub sendok {
	local($sender,$ok,$deny,$challenge)=@_;
	$result=$ok?"successfully registered":
	$deny."\n(Maybe you did not specify the magic number? It is $challenge)";
	$result="registered" unless ($deny);
	print <<__END__
To: $sender
From: Fido7 Auto Registration Facility $OPER
Reply-To: "Do not reply, write a new message" :;
Subject: Registration result from fido7 gateway

Dear madam or sir!

You are reading an automated reply from the fido7 automoderator.

Your registration request was received from the address:

	$sender

The result of the request is:

	$result

--
If you have troubles registering with fido7 automoderator, please see
http://www.fido7.ru/  If this does not help, please contact the human
operator at $OPER.
__END__
}

sub sendinfo {
	local($sender)=@_;

	print <<__END__
To: $sender
From: Fido7 Auto Registration Facility $OPER
Reply-To: "Do not reply, write a new message" :;
Subject: Information about fido7 gateway

Dear madam or sir!

Fido7 is NOT a normal usenet hierarchy.  Rather, it contains Fidonet
echomail areas.  The newsgroups are mostly Russian-language.  If you do
not speak Russian, you probably do not want to subscribe to any of them.
The hierarchy is "auto-moderated", i.e. after you register with the
gateway, your postings pass to the newsgroups without manual
intervention.  Before you register, your postings are returned back
to you along with an instruction how to register.

For details, please see:

	http://www.fido7.ru/

--
Sincerely, $OPER
__END__
}

sub sendbounce {
	local($sender)=@_;

	print <<__END__
To: $sender
From: Fido7 Auto Registration Facility $OPER
Reply-To: "Do not reply, write a new message" :;
Subject: Article bounced
MIME-Version: 1.0
Content-Type: multipart/mixed; boundary="$BOUNDARY"

--$BOUNDARY
MIME-Version: 1.0
Content-Type: text/plain; charset=us-ascii; language=en
Content-Transfer-Encoding: 7bit
Content-Language: en

Dear madam or sir!

You are reading an automated reply from the fido7 automoderator; this is
the first part of the three-part MIME message; second part is in
Russian.

Your article (attached as the third part of this message) did not pass
to the newsgroup(s) because the newsgroup it was posted to is available
to the Internet subscribers on the "read-only" basis, that is, only
Fidonet members are allowed to post there.  Please do not complain, this
is not the gatekeeper's initiative, but a requirement of the Fidonet
folks.  Most of the rest fido7 newsgroups are available for read and
post.

Fido7 is not a normal usenet hierarchy, it is Russian-language ECHOMAIL
gatewayed from FidoNet(r).

--
Sincerely, $OPER

--$BOUNDARY
MIME-Version: 1.0
Content-Type: text/plain; charset=koi8-r; language=ru
Content-Transfer-Encoding: 8bit
Content-Language: ru

  (     )  
  (),   ,    
,       .  
 Fidonet      .  , 
 ,     Fidonet.   
   fido7    ,   .

Fido7 -     ,    
  Fidonet.

--
Sincerely, $OPER

--$BOUNDARY
Content-Type: message/news

__END__
}

sub closebounce {
	print "--$BOUNDARY--\n";
}

sub sendnonkosher {
	local($sender,$reason)=@_;

	print <<__END__
To: $sender
From: Fido7 Auto Registration Facility $OPER
Reply-To: "Do not reply, write a new message" :;
Subject: Article not acceptable
MIME-Version: 1.0
Content-Type: multipart/mixed; boundary="$BOUNDARY"

--$BOUNDARY
MIME-Version: 1.0
Content-Type: text/plain; charset=us-ascii; language=en
Content-Transfer-Encoding: 7bit
Content-Language: en

Dear madam or sir!

You are reading an automated reply from the fido7 automoderator; this is
the first part of the three-part MIME message; second part is in
Russian.

Your article (attached as the third part of this message) was not posted
to the newsgroup(s) because of the following reason:

	$reason

In Fidonet there is no analogue of MIME, and Russian-language articles
must come in the encoding standard for the Internet (koi8-r).  Also, due
to the limitations of the gateway software, we cannot accpet 7bit
encapsulation like base64 or quoted-printable.  Please ensure that your
postings have:

	Content-Type: text/plain; charset=koi8-r
	Content-Transfer-Encoding: 8bit

and no 7bit encoded 8bit data in the headers.

Also, there is no concept of crosspost (post into multiple newsgroups)
in Fidonet, so only one newsgroup is allowed in the Newsgroups header.

--
Sincerely, $OPER

--$BOUNDARY
MIME-Version: 1.0
Content-Type: text/plain; charset=koi8-r; language=ru
Content-Transfer-Encoding: 8bit
Content-Language: ru

  (     )  
     :

	$reason

 Fidonet   MIME,   -   
,    (koi8-r).   , -
    ,    
    7  (base64 
quoted-printable).  , ,     

	Content-Type: text/plain; charset=koi8-r
	Content-Transfer-Encoding: 8bit

       MIME.

 ,  Fidonet   ,   
Newsgroups    .

--
Sincerely, $OPER

--$BOUNDARY
Content-Type: message/news

__END__
}

sub closenonkosher {
	print "--$BOUNDARY--\n";
}

1;
