#!/usr/bin/perl

open( IFPASSWD, "<".$ARGV[0] ) or die "Can't open ifmail config '$ARGV[0]': $!\n";
open( AFPASSWD, ">".$ARGV[1] ) or die "Can't create areafix passwords file '$ARGV[1]': $!\n";

while (<IFPASSWD>) {
    ($ftnlink, $pass)=(/^password\s+(.+)\s+(.+)/);
    ($z, $n, $f) = (2, 5020, 931);
    $lnk = ftn2dom($ftnlink);
    printf AFPASSWD "%s.fidonet.org:%s:%s\n", $lnk, $lnk, $pass;
}

# That's all, folks! ;-)


# Translate ftn-style addresses to domain-style (2:5020/931 -> f931.n5020.z2)
# Incomplete addresses allowed - $z,$n,$f contains "default" address

sub ftn2dom
{
    my $a = @_[0];
    if($a=~/(\d+):(\d+)\/(.+)/) {
	    ($z, $n, $fp) = ($1, $2, $3);
    }
    elsif($a=~/(\d+)\/(.+)/) {
	    ($n, $fp) = ($1, $2);
    }
    else {
	    $fp = $a;
    }
    if( $fp =~ /(\d+)\.(\d+)/ ) {
	    $f  = $1;
	    $fp = "p$2.f$1";
    }
    elsif( $fp =~ /\.(\d+)/ ) { $fp = "p$1.f$f"; }
    else { $f = $fp; $fp = "f$f"; }
    return ($fp.".n".$n.".z".$z);
}
