#!/usr/bin/perl
$AreasFile="/etc/ifmail/Areas";
$AreaFixDir="/usr/lib/ifmail/areafix";

local (%Newsfeeds, %echo2ng);

open( FECFG, "<".$ARGV[0] ) or die "Can't open FE config '$ARGV[0]': $!\n";
open( OUTFEEDS, ">".$ARGV[1] ) or die "Can't create newsfeeds file '$ARGV[1]': $!\n";
open( AREAS, "<".$AreasFile ) or die "Can't open Areas file '$ARGV[1]': $!\n";

system("cp ".$AreasFile." ".$AreasFile.".Bak");

# read Areas file

while(<AREAS>) {
    my($echo, $ngroup);
    next if (/^\s*#/o);
    next unless(($echo,$ngroup)=/(\S+)\s+(\S+)/o);
    next if ($echo=~/\*/o);
    $echo2ng{$echo}=$ngroup;
}
close(AREAS);

# skip to echolinks configuration

do {
	$_=<FECFG>;
} until $_ eq "Areas\r\n";

for ($i=0; $i<4; $i++) {
	$_=<FECFG>;
}

while (<FECFG>) {
	if($_ eq "\r\n") {
		# end of echolinks configuration
		&storearea($Area, @Links);
		last;
	} 
	if(/^\s+\S\s+/) {
		&storearea($Area, @Links) if(defined $Area); 
		($Board, $Area, $Origin, $Group, @Links) = split;
	}
	else {
		push @Links, split;
	}
	
	
}

# create newsfeeds file

foreach $_ (keys %Newsfeeds) {
    print OUTFEEDS "#".("-"x30)."\n$_\\\n:";
    print OUTFEEDS substr($Newsfeeds{$_}, 0, length($Newsfeeds{$_})-3);
    print OUTFEEDS "\\\n:Tf,Wfb,B4096/1024:\n";
}

# That's all, folks! ;-)


# make %Newsfeeds{$Area} hash and print $Area subscribers

sub storearea
{
    my($Area, @Links)=@_;
    my($z, $n, $f, $fp);
    foreach $_ (@Links) {
	    $_ = ftn2dom($_);
	    if(! exists($echo2ng{$Area})) {
		print "$Area not exists, creating...\n";
		addarea($Area);
	    }
	    $Newsfeeds{$_}.=$echo2ng{$Area}.",\\\n";
    }
    print "${Area}: ".join(',', @Links)."\n";
    print +($#Links+1)." link(s).\n"; 
}


# Translate ftn-style addresses to domain-style (2:5020/931 -> f931.n5020.z2)
# Incomplete addresses allowed - $z,$n,$f contains "default" address

sub ftn2dom
{
    if(/(\d+):(\d+)\/(.+)/) {
	    ($z, $n, $fp) = ($1, $2, $3);
    }
    elsif(/(\d+)\/(.+)/) {
	    ($n, $fp) = ($1, $2);
    }
    else {
	    $fp = $_;
    }
    if( $fp =~ /(\d+)\.(\d+)/ ) {
	    $f  = $1;
	    $fp = "p$2.f$1";
    }
    elsif( $fp =~ /\.(\d+)/ ) { $fp = "p$1.f$f"; }
    else { $f = $fp; $fp = "f$f"; }
    return ($fp.".n".$n.".z".$z);
}

# add area to Areas file and create newsgroup
# stolen from autocreate by Serge Oskin (2:5020/20) and rewritten a little ;-)
# usage: addarea Area

sub addarea {
	my ($Area) = @_;
	my ($Newsgroup) = "fido7.\L$Area";
	$Newsgroup =~ s/\$//g;
	$Newsgroup =~ tr/\'`!:\/\\&\*\+\"/\./;
	print "New area: $Area -> $Newsgroup\n";

	open( AREAS, ">>".$AreasFile ) or die "Can't open $AreasFile for writing: $!\n";
	print AREAS "$Area\t$Newsgroup\tfido7\n";
	close(AREAS);

	print "About to run '$AreaFixDir/newgroup $Newsgroup'\n";
	system "$AreaFixDir/newgroup $Newsgroup";
	$echo2ng{$Area}=$Newsgroup;
}
