#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "uuerobot.h"
#include "_selectgroup.h"
#include "_scanareas.h"
#include "_listheader.h"
#include "_decode.h"

/******************************************************************************
                               G L O B A L S
******************************************************************************/
HEADER_UUE    *_headerHead = NULL;
HEADER_UUE    *_headerTail = NULL;
char          _hostname[ MAX_LENGTH_STRING ];
pid_t         _mypid;                       

char  *_uueSRC             = UUESRC;
char  *_uueOUT         	   = UUEOUT;
char  *_uueBAD             = UUEBAD;
char  *_fileActive         = ACTIVEFILE;
char  *_fileTemp           = TEMPFILE;
char  *_articles           = ARTICLES;
char  *_fileDebug          = DEBUGFILE;
char  *_fileLog            = LOGFILE;
char  *_decodeProgramm     = DECODEPROGRAMM;
int   _echoScreen          = ECHOSCREEN;
char  *_fileArea	   = AREAFILE;
char  *_fileCfg            = CFGFILE;


/******************************************************************************
                                 T Y P E S
******************************************************************************/
void Usage( void );
void Renumber( void );


/******************************************************************************
                                  M A I N 
******************************************************************************/
int main( int argc, char **argv )
{
  int             index;  

  DEBUG( "\n" );
  LOG  ( "\n" );
  DEBUG( "----------------- Start UUERobor ----------------\n" );
  LOG  ( "----------------- Start UUERobor ----------------\n" );
  DEBUG( " Argc - %d\n", argc );
  LOG  ( " Argc - %d\n", argc );
  DEBUG( " Argv - %s\n", argv[ 1 ] );
  LOG  ( " Argv - %s\n", argv[ 1 ] );
  DEBUG( "-------------------------------------------------\n" );
  LOG  ( "-------------------------------------------------\n" );
  
  if( argc != 2 ) {
     Usage();
     exit( -1 );
  }
  
  gethostname( _hostname, index );
  _mypid = getpid();  

  if( strcmp( argv[1], "tune" ) == 0 ) {
     SelectGroup();
  }  
  else {  
     if( strcmp( argv[1], "scan" ) == 0 ) {
        ReadCfg();
        ScanAreas();
        DeleteHeader();
     }
     else {  
        if( strcmp( argv[1], "decode" ) == 0 ) {
           Decode();
        }
	else {
	  if( strcmp( argv[1], "auto" ) == 0 ) {
	     ReadCfg();
             ScanAreas();
             DeleteHeader();
	     Decode();
          }	     
	  else {	   
	     Usage();
	     exit( -1 );
          }	     
	}
     }	
  } 	  
  remove( _fileTemp );
  
  DEBUG( "\n" );
  LOG  ( "\n" );
  DEBUG( "----------------- End UUERobor ----------------\n\n" );
  LOG  ( "----------------- End UUERobor ----------------\n\n" );

  exit( 1 );
}



void Usage( void )
{
   printf( "\n" );
   printf( "UUERobot 0.1   Automatic UUE decoder\n" );
   printf( "Copyright (c) 1998 Andrey G.Kobrin   2:5030/238.3@fidonet Email:nil14@setcorp.ru\n\n" );
   printf( "Usage:\n" );
   printf( "   uuerobot <command>\n\n" ); 
   printf( "Commands:\n\n" );
   printf( "   tune      Select area for scanning\n" );
   printf( "   scan      Scanning message areas for UUE-message\n" );
   printf( "   decode    Decode entire UUE-code\n");   
   printf( "   auto      Scanning and decode\n\n" );
}

