#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/param.h>
#include <sys/resource.h>
#include <sys/types.h>
#include <dirent.h>
#include "uuerobot.h"
#include "_scanmsg.h"
#include "_testline.h"
#include "_saveheadermsg.h"
#include "_saveuue.h"



/******************************************************************************
                          UUE
******************************************************************************/
int ScanMsg( char *dir, char *ffname )
{
   char        fname[ NAME_MAX + 1];
   FILE        *fp; 
   char        str[ MAX_LENGTH_STRING ];
   long        currLine;
   FOUND_UUE   *fUUE;
   int         flagFound = FALSE;
   
   sprintf( fname, "%s/%s", dir, ffname );
   DEBUG( "Test %s\n", fname );
   
   if( (fp = fopen( fname, "r" )) == NULL ) {
      DEBUG( "Error! Unable open msg %s. Die...\n", fname );
      exit( -1 );
   }

   currLine = 0;
   while( fgets( str, MAX_LENGTH_STRING - 1, fp ) != NULL )    
   {
      fUUE = TestLine( str );
      if( fUUE != NULL ) {
	 if( fUUE->numberSection == 1 ) {
	   SaveHeaderMsg( fname, fUUE, currLine );
	 }
	 SaveUUE( fname, fUUE, currLine );
	 flagFound = TRUE;
	 break;
      }
      currLine++;
   } /* end  while( fgets( str, MAX_LENGTH_STRING - 1, fp ) != NULL )  */
   fclose( fp );
   
   if( flagFound == FALSE ) {
      DEBUG( "No found UUE\n" );
      return( FALSE );
   }
   
   return( TRUE );
}

