#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "uuerobot.h"
#include "_readcfg.h"
#include "_other.h"
#include "_listheader.h"


/*****************************************************************************
                         
*****************************************************************************/
void ReadCfg( void )
{  
   FILE *fp;   
   char str[ MAX_LENGTH_STRING ];
   char *tmpPtr;      
   int  index;
   HEADER_UUE *header;

   DEBUG( "Read cfg. Wait...\n" );
   LOG  ( "Read cfg. Wait...\n" );

   if( (fp = fopen( _fileCfg, "r" )) == NULL ) {
     DEBUG( "Unable open cfg file %s\n", _fileCfg );
     LOG  ( "Unable open cfg file %s\n", _fileCfg );
   }
   
   while( fgets( str, MAX_LENGTH_STRING - 1, fp ) != NULL ) 
   {            
      /*      */
      if( str[ 0 ] != '[' ) continue;
      
      /*     */
      AddHeader();
      
      /*   */
      strcpy( _headerTail->name, str );
      fgets( str, MAX_LENGTH_STRING - 1, fp );
      tmpPtr = strchr( str, (int)'=' );
      tmpPtr++;      
      ReadOneParam( &_headerTail->header, tmpPtr );
      
      /*  skipline */
      fgets( str, MAX_LENGTH_STRING - 1, fp );
      tmpPtr = strchr( str, (int)'=' );
      tmpPtr++;      
      ReadOneParam( &_headerTail->skipline, tmpPtr );
      
      /*  endline */
      fgets( str, MAX_LENGTH_STRING - 1, fp );
      tmpPtr = strchr( str, (int)'=' );
      tmpPtr++;      
      ReadOneParam( &_headerTail->endline, tmpPtr );     
      
      DEBUG( "UUE HEADER:\n" );
      LOG  ( "UUE HEADER:\n" );
      strcpy( str, "" );
      for( index = 0; index < _headerTail->header.countMeaning; index++ ) {
	 strcat( str, _headerTail->header.meaning[ index ] );
	 strcat( str, " " );
      }
      _headerTail->header.countKey = 0;
      for( index = 0; index < _headerTail->header.countMeaning; index ++ ) {
	 if( _headerTail->header.meaning[ index ][0] != '%' ) 
	    _headerTail->header.countKey++;
      }
      DEBUG( "   %s\n", str );
      LOG  ( "   %s\n", str );
      _headerTail->header.countNum = _headerTail->header.countMeaning - 
                                     _headerTail->header.countKey; 
      
      DEBUG( "UUE SkipLine:\n" );
      LOG  ( "UUE SkipLine:\n" );
      strcpy( str, "" );
      for( index = 0; index < _headerTail->skipline.countMeaning; index++ ) {
	 strcat( str, _headerTail->skipline.meaning[ index ] );
	 strcat( str, " " );
      }
      DEBUG( "   %s\n", str );
      LOG( "   %s\n", str );
      
      DEBUG( "UUE EndLine:\n" );
      LOG  ( "UUE EndLine:\n" );
      strcpy( str, "" );
      for( index = 0; index < _headerTail->endline.countMeaning; index++ ) {
	 strcat( str, _headerTail->endline.meaning[ index ] );
	 strcat( str, " " );
      }
      DEBUG( "   %s\n\n", str );
      LOG  ( "   %s\n\n", str );
            
   }   /* end while( fgets( str, MAX_LENGTH_STRING - 1, fp ) != NULL )  */
   fclose( fp );   
   DEBUG( "Done read cfg file.\n\n" );   
   LOG( "Done read cfg file.\n\n" );   
}


/***********************************************************************
                parm   str
************************************************************************/
void ReadOneParam( VAR_TYPE *parm, char *str )
{
   int index;
   
   index = 0;
   while( GetWord( str, index ) != NULL ) {
      strcpy( parm->meaning[ index ], GetWord( str, index ) );
      index ++;
   }	       
   parm->countMeaning = index;
}


