#include <unistd.h>
#include <stdio.h>
#include <sys/param.h>
#include <sys/resource.h>
#include <sys/types.h>
#include <dirent.h>
#include "uuerobot.h"
#include "_other.h"



void Decode( void )
{
   DIR             *dir;
   struct dirent  *currUUE;  
   int             numberSection;
   int             totalSection;
   char            fmaska[ MAX_LENGTH_STRING ];
   int             flagDecode;
   long            totalUUE = 0;

   
   LOG( "Decoding UUE...\n" );
   DEBUG( "Decoding UUE...\n" );
   

  RESTART:
   flagDecode = FALSE;	
	 
   /*     UUE */
   if( (dir = opendir( _uueSRC )) == NULL ) {
      LOG( "Error open dir %s", _uueSRC );
      DEBUG( "Error open dir %s", _uueSRC );
      exit( -1 );
   }  
  
   while( (currUUE = readdir( dir )) != NULL )
   {
      if( currUUE->d_name[0] == '.' ) continue;
      
      /*
       *          
       */

      if( GetNumbers( currUUE->d_name, fmaska, 
	              &numberSection, &totalSection ) == TRUE ) 
      {

	 if( numberSection == totalSection ) {

	    /*
	    *     totalSection
	    *                 fmask
	    */
	    DEBUG( "Search all section for decode file %s\n", fmaska );
	    if( CollectionUUE( fmaska, totalSection ) == TRUE ) {
	       LOG( "Decode %s...\n", fmaska );
	       DEBUG( "All section found\n" );
	       DecodeFoundSection( fmaska);
	       DeleteSrc( fmaska );
	       flagDecode = TRUE;
	       totalUUE ++;
	    }
	 }
      } 

   }  /* end while( (currUUE = readdir( dir )) != NULL ) */
   closedir( dir );

   if( flagDecode == TRUE ) goto RESTART;
   
   LOG( "Total %d UUE decoding\n", totalUUE );
   DEBUG( "Total %d UUE decoding\n", totalUUE );
   DEBUG( "Done decoding UUE.\n" );   
   LOG( "Done decoding UUE.\n" );   
}




int CollectionUUE( char *maska, int total )
{
   DIR             *dir;
   struct dirent  *currUUE;  
   int             currSection;
   int             numberSection;
   int             totalSection;
   char            tmpStr[ MAX_LENGTH_STRING ];
   int             foundSection;


   /*    */
   remove( _fileTemp );
   
   foundSection = 0;
   for( currSection = 1; currSection <= total; currSection++ )
   {
      dir = opendir( _uueSRC );
      while( (currUUE = readdir( dir )) != NULL )
      {
	 if( currUUE->d_name[0] == '.' ) continue;
	 if( strstr( currUUE->d_name, maska ) == 0 ) continue;
	 if( GetNumbers( currUUE->d_name, tmpStr, 
	              &numberSection, &totalSection ) == TRUE ) 
         {
	    if( numberSection == currSection ) {
	       foundSection++;
	       sprintf( tmpStr, "%s/%s", _uueSRC, currUUE->d_name );
	       CopyFile( tmpStr, _fileTemp, "a+" );	     
	    }	    
	 }	 
      }
      closedir( dir );
   }
   
   if( foundSection != total ) {
      sprintf( tmpStr, "rm -f %s", _fileTemp );
      system( tmpStr );
      return FALSE;   
   }   
   return TRUE;
}


int DecodeFoundSection( char *maska )
{
   char  tmpStr [ MAX_LENGTH_STRING ];
   char  tmpStr2[ MAX_LENGTH_STRING ];
   char  currDir[ MAX_LENGTH_STRING ];
   FILE  *fp;
   char  *chPtr;
   char  flagFoundArea;
   int   rescode;   
   
   /*    */
   flagFoundArea = FALSE;
   sprintf( tmpStr, "%s/%s%s", _uueSRC, maska, MASKA_DESCRIPTION_FILE );
   fp = fopen( tmpStr, "r" );
   while( fgets( tmpStr, MAX_LENGTH_STRING - 1, fp ) != NULL )
   {
      if( (chPtr = (char *)strstr( tmpStr, "X-FTN-AREA: " )) != NULL ) {
	 chPtr += strlen( "X-FTN-AREA: " );
	 chPtr[ strlen( chPtr ) - 1 ] = '\0';
         DEBUG( "Find area name in header UUE: %s\n", chPtr );
	 /*        */
	 sprintf( currDir, "%s/%s", _uueOUT, chPtr );	 
	 if( access( currDir, F_OK ) != 0 ) {
	    DEBUG( "Create dir %s\n", currDir );
	    sprintf( tmpStr, "mkdir %s", currDir );
	    system( tmpStr );
	 }   
	 /*   hdr   */
	 sprintf( tmpStr, "%s/%s", currDir, MASKA_DESCRIPTION_FILE );
	 if( access( tmpStr, F_OK ) != 0 ) {
	    DEBUG( "Create dir %s/%s\n", currDir, MASKA_DESCRIPTION_FILE );
	    sprintf( tmpStr, "mkdir %s/%s", currDir, MASKA_DESCRIPTION_FILE );
	    system( tmpStr );
	 }   

	 flagFoundArea = TRUE;
	 break;
      }
   }   
   fclose( fp );
   
   /*       ,    _uueOUT */
   if( flagFoundArea == FALSE ) sprintf( currDir, "%s", _uueOUT );

   /*   */
   sprintf( tmpStr, "%s -p %s %s >> /dev/null", _decodeProgramm, currDir, _fileTemp );
   DEBUG( "Start decode program %s\n", tmpStr );
   system( tmpStr );
   
   /*  -   */
   sprintf( tmpStr, "%s/%s", currDir, maska );
   if( access( tmpStr, F_OK ) != 0 ) {
      DEBUG( "    Error decoding file %s\n", maska );
      LOG  ( "    Error decoding file %s\n", maska );
      DEBUG( "    Save collection UUE\n" );
      sprintf( tmpStr, "%s/%s.uue", _uueBAD, maska );
      CopyFile( _fileTemp, tmpStr, "w" );
      sprintf( tmpStr, "%s/%s%s", _uueSRC, maska, MASKA_DESCRIPTION_FILE );
      sprintf( tmpStr2, "%s/%s%s", _uueBAD, maska, MASKA_DESCRIPTION_FILE );
      CopyFile( tmpStr, tmpStr2, "w" );
   }
   else {   
     /*   */
     sprintf( tmpStr,  "%s/%s%s", _uueSRC, maska, MASKA_DESCRIPTION_FILE );
     sprintf( tmpStr2, "%s/%s/%s%s", currDir, MASKA_DESCRIPTION_FILE,
                                       maska, MASKA_DESCRIPTION_FILE ); 
     CopyFile( tmpStr, tmpStr2, "w" );
     LOG  ( "    Ok decode file %s/%s\n", currDir, maska );
   }     
   
   /*    */
   remove( _fileTemp );   
}


int DeleteSrc( char *maska )
{
   DIR             *dir;
   struct dirent  *currUUE;  
   char           tmpStr[ MAX_LENGTH_STRING ];


   DEBUG( "Delete source %s\n",maska );
   dir = opendir( _uueSRC );
   while( (currUUE = readdir( dir )) != NULL )
   {
      if( currUUE->d_name[0] == '.' ) continue;
      if( strstr( currUUE->d_name, maska ) == 0 ) continue;
      sprintf( tmpStr, "%s/%s", _uueSRC, currUUE->d_name );
      remove( tmpStr );
   }      
   closedir( dir );
   
}

