#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <ctype.h>
#include "ifpollP.h"


/*******************************************************************************
                            a
*******************************************************************************/
void ShowTransferReceive( int flag )
{
  char         *indicator={"-\\|/-\\|/\0"};  
  static char  *ptrInd = indicator;
  static int   currYReceiveWnd = -1;  
  static char  fileReceive[ MAX_LENGTH_STRING ] = "";  
  struct stat  fStat;
  char         tmpStr[ MAX_LENGTH_STRING ];  

  /*  */
  if( flag == RESET_VIEW ) {
     ptrInd = indicator;
     currYReceiveWnd = -1;  
     strcpy( fileReceive, "" );
     return;  
  }
  
  /* skip file */
  if( flag == SKIP_FILE ) {
     remove( fileReceive );
     PrintInfoString( "Skip current file..." );
  }


  /*  */
  if( infoEmsi.numReceiveFile != infoEmsiOld.numReceiveFile ) 
  {
     //printf( "%s\n", infoEmsi.fileReceive );
     _flagNoTick = TRUE;
     
     int index = 0;
     while( strcmp( GetLastFileMask(), "" ) == 0 ) {
        LOG( 0, "!!!!!!!!!!!!!! %d\n", index );
	index++;
	if( index == 250 ) {
	  for( int i = 0; i < strlen(infoEmsi.fileReceive); i++ ) 
	    infoEmsi.fileReceive[i] = tolower( infoEmsi.fileReceive[i] );
	}
     }
     _flagNoTick = FALSE;
     strcpy( fileReceive, GetLastFileMask() );
     //printf( ".......%s\n", fileReceive );
     currYReceiveWnd++;
     if( currYReceiveWnd > wndReceiv->_maxy ) {
        ScrollDown( wndReceiv );
        currYReceiveWnd--;
     }
  }
  
  /*     -  */  
  if( strcmp( fileReceive, "" ) == 0 ) return;
  
  
  if( strlen( infoEmsi.fileReceive ) > 24 )
     infoEmsi.fileReceive[ 24 ] = '\0';

  /*     -  */
  if( stat( fileReceive, &fStat ) == -1 ) {
     //printf( ".......Ok\n" );
     mvwaddch( wndReceiv, currYReceiveWnd, 0, ' ');  
     sprintf( tmpStr, "%-24s            Ok", infoEmsi.fileReceive );    
     mvwaddstr( wndReceiv, currYReceiveWnd, 1, tmpStr );  
     wrefresh( wndReceiv );
     strcpy( fileReceive, "" );
     return;
  }
  
  /*
   *       
   */
  
  /*     */
  int currProc = fStat.st_size * 100 / infoEmsi.sizeCurrReceive;
  /*  */
  sprintf( tmpStr, "%-24s[%8d]%3d%%", infoEmsi.fileReceive, fStat.st_size, currProc );
  mvwaddstr( wndReceiv, currYReceiveWnd, 1, tmpStr );  
  
  /*   */
  mvwaddch( wndReceiv, currYReceiveWnd, 0, *ptrInd );  
  if( *(++ptrInd) == '\0' ) ptrInd = indicator;

  wrefresh( wndReceiv );
  
  /*       */
  mvwaddstr( wndTop, wndLog->_maxy+3, 
             wndTop->_maxx-strlen(infoEmsi.echomail)-1, infoEmsi.echomail );       
  /*    */
  sprintf( tmpStr, " %d byte(s) ", infoEmsi.sizeTotalReceive+fStat.st_size );  
  mvwaddstr( wndQueue, Y_HLINE_EMSI, wndTop->_maxx - strlen(tmpStr)-2, tmpStr );       
  wrefresh( wndTop );
  wrefresh( wndQueue );  
  //printf( "_______%d\n", fStat.st_size );  
}


/*******************************************************************************
                            a
*******************************************************************************/
void ShowTransferSend( int flag )
{
  char         *indicator={"-\\|/-\\|/\0"};  
  static char  *ptrInd = indicator;
  static int   currYSendWnd = -1;  
  static char  fileSend[ MAX_LENGTH_STRING ] = "";  
  struct stat  fStat;
  char         tmpStr[ MAX_LENGTH_STRING ];  

  /*  */
  if( flag == RESET_VIEW ) {
     ptrInd = indicator;
     currYSendWnd = -1;  
     strcpy( fileSend, "" );
     return;  
  }

  /*  */
  if( infoEmsi.numSendFile != infoEmsiOld.numSendFile ) 
  {
     //printf( "%s\n", infoEmsi.fileReceive );
     strcpy( fileSend, infoEmsi.fileSend );
     //printf( ".......%s\n", fileReceive );
     currYSendWnd++;
     if( currYSendWnd > wndSend->_maxy ) {
        ScrollDown( wndSend );
        currYSendWnd--;
     }
  }
  
  /*     -  */  
  if( strcmp( fileSend, "" ) == 0 ) return;
  
  
  if( strlen( infoEmsi.fileSend ) > 24 )
     infoEmsi.fileSend[ 24 ] = '\0';

  /*     -  */
//  if( stat( fileReceive, &fStat ) == -1 ) {
     //printf( ".......Ok\n" );
//     sprintf( tmpStr, "%-24s            Ok", infoEmsi.fileReceive );    
//     mvwaddstr( wndReceiv, currYReceiveWnd, 1, tmpStr );  
//     wrefresh( wndReceiv );
//     strcpy( fileReceive, "" );
//     return;
//  }
  
  /*
   *       
   */
  
  /*     */
//  int currProc = fStat.st_size * 100 / infoEmsi.sizeCurrReceive;

  /*  */
  sprintf( tmpStr, "%-24s          ...", infoEmsi.fileSend );
  mvwaddstr( wndSend, currYSendWnd, 1, tmpStr );  
  wrefresh( wndSend );
  
  /*   */
  mvwaddch( wndSend, currYSendWnd, 0, *ptrInd );  
  if( *(++ptrInd) == '\0' ) ptrInd = indicator;

  
  /*       */
  sprintf( tmpStr, " %d byte(s) ", _sizeOutCurrNode );
  mvwaddstr( wndTop, wndLog->_maxy+3, 
              38-strlen(tmpStr), tmpStr );       
    
  /*    */
  sprintf( tmpStr, " %d byte(s) ", infoEmsi.sizeTotalSend );  
  mvwaddstr( wndQueue, Y_HLINE_EMSI, 
              37-strlen(tmpStr), tmpStr );       
  wrefresh( wndTop );
  wrefresh( wndQueue );  
  //printf( "_______%d\n", fStat.st_size );  
}


/*******************************************************************************
                            
*******************************************************************************/
char *GetLastFileMask( void )
{
   char         tmpStr[ MAX_LENGTH_STRING ];
   static char  fname [ MAX_LENGTH_STRING ];
   struct stat  fStat;
   FILE         *fp;
   time_t       tmpTime = -1;
   
   strcpy( fname, "" );
       
   /*    */
   sprintf( tmpStr, "find %s/tmp -name \'%s", _inbound, infoEmsi.fileReceive );
   tmpStr[ strlen( tmpStr ) - 1 ] = '\0'; 
   strcat( tmpStr, "?\'" );
   
   //printf( "%s\n", tmpStr );
   if( (fp = popen( tmpStr, "r" )) == NULL ) {
      //printf( "No find file\n" );
      return( fname );
   }
   
   while( fgets( tmpStr, MAX_LENGTH_STRING - 1, fp ) != NULL )
   {
      /*     */
      *(strstr( tmpStr, "\n" )) = '\0';
      if( stat( tmpStr, &fStat ) != -1 ) {
         if( fStat.st_ctime > tmpTime ) {
	    strcpy( fname, tmpStr );
	    tmpTime = fStat.st_ctime;
	 }
      }
   }
   pclose( fp );        
   return( fname );
}
