#include <unistd.h>
#include "ifpollP.h"


/*******************************************************************************
                               
*******************************************************************************/
void InitScreen( void )
{    
  int  index;
  
  initscr();  
  start_color();
  
  /*   */
  wndTop = newwin( 0, 0, 0, 0 );
  wndLog = newwin( HEIGHT_LOG_WND, WIDTH_LOG_WND, 
                   START_Y_LOG_WND, START_X_LOG_WND );
  wndQueue = newwin( HEIGHT_QUEUE_WND, WIDTH_QUEUE_WND, 
                     START_Y_QUEUE_WND, START_X_QUEUE_WND );
  
  /*   */
  werase( wndTop );   wclear( wndTop );
  werase( wndLog );   wclear( wndLog );
  werase( wndQueue ); wclear( wndQueue );  

  /*   */
  box( wndTop, 0, 0 );
  InfoOutCall();


  /*    */ 
  mvwhline( wndTop, wndLog->_maxy+3, 1, ACS_HLINE, wndTop->_maxx-1 );
  
//  wmove( wndTop, wndLog->_maxy+3, 1 );
//  whline( wndTop, ACS_HLINE, wndTop->_maxx-1 );
  
  /*   */
  PrintHelpString( " F1  Help     Meta-X Quit " );
  
  /*  */
  mvwaddstr( wndTop, 0, 66, " ifpollP 0.12 " );
  
  /*     etc */
  noecho();
  nodelay( stdscr, FALSE );
  cbreak();
  curs_set( FALSE );
  keypad( stdscr, TRUE );  
  
  /*   */
  wrefresh( wndTop );
  wrefresh( wndLog );
  wrefresh( wndQueue );  
}



/*******************************************************************************
                                
*******************************************************************************/
void DestroyScreen( void )
{
  Clear( wndLog );
  Clear( wndQueue );
  Clear( wndTop );   
  delwin( wndTop );
  delwin( wndLog );
  delwin( wndQueue );  
  curs_set( TRUE );
  endwin();
}



/*******************************************************************************
                                
*******************************************************************************/
void ClearLine( int length, WINDOW *win )
{
  int i,y_start,x_start;
  
  getyx( win, y_start, x_start );
  for( i = x_start+1; i <= length; i++ )
     waddch( win, ' ' );
  wrefresh( win );     
}


/*******************************************************************************
                                
*******************************************************************************/
void Clear( WINDOW *win)
{
   int y, x;

//   werase( win );
//   wclear( win );   
   for( y = 0; y <= win->_maxy; y++ ) {
      for( x = 0; x <= win->_maxx; x++ ) {
        wmove( win, y, x );
	waddch( win, ' ' );
      }
   }      	
   
   wrefresh( win );
}


/*******************************************************************************
                               
*******************************************************************************/
void ScrollDown( WINDOW *win )
{
   scrollok( win, TRUE );
   wscrl( win, +1 );
   scrollok( win, FALSE );	 
   ClearLine( win->_maxy, wndLog );
}


/*******************************************************************************
                               
*******************************************************************************/
void PrintHelpString( char *str )
{
   wmove   ( wndTop, wndTop->_maxy, 1 );
   whline  ( wndTop, ACS_HLINE, wndTop->_maxx-1 );
   wmove   ( wndTop, wndTop->_maxy, 1 );
   waddstr ( wndTop, str );
   wrefresh( wndTop );  
}


/*******************************************************************************
                          
*******************************************************************************/
void PrintInfoString( char *str )
{
  wattrset( wndTop, A_BOLD );      
  wmove   ( wndTop, wndLog->_maxy+2, 1 );
  whline  ( wndTop, ' ', wndTop->_maxx-1 );
  wmove   ( wndTop, wndLog->_maxy+2, 1 );
  waddstr ( wndTop, str );
  wrefresh( wndTop );  
  wattrset( wndTop, A_NORMAL );      
}

/*******************************************************************************
                          
*******************************************************************************/
void InitScreenConnect( void )
{
//  if( _status == SYSTEM_CONNECT ) return;
  
  if( wndSend != NULL ) return;
  if( wndReceiv != NULL ) return;

  Clear( wndQueue );
  
  wndSend   = newwin( 5, 38, wndLog->_maxy+4, 1 );
  wndReceiv = newwin( 5, 39, wndLog->_maxy+4, 40 );
/*  box( wndSend, 0, 0 );
  box( wndReceiv, 0, 0 );
*/  
  wattrset ( wndTop, A_BOLD );    
  mvwaddstr( wndTop, wndLog->_maxy+3, 2,  " Send: " );
  mvwaddstr( wndTop, wndLog->_maxy+3, 42, " Receive: " );
  wattrset ( wndTop, A_NORMAL );    
  
  mvwhline( wndQueue, Y_HLINE_EMSI, 0, ACS_HLINE, wndQueue->_maxx+1 );

  mvwvline( wndQueue, 0, 38, ACS_VLINE, 5 );

  wrefresh ( wndQueue );
  wrefresh ( wndTop );  
  wrefresh ( wndSend );
  wrefresh ( wndReceiv );  
}

/*******************************************************************************
                           
*******************************************************************************/
void DestroyScreenConnect( void )
{
  if( wndSend != NULL ) {
    werase( wndSend ); wclear( wndSend ); Clear( wndSend ); delwin( wndSend ); 
    werase( wndReceiv );  wclear( wndReceiv ); Clear( wndReceiv ); delwin( wndReceiv ); 
    /*    */ 
    mvwhline( wndTop, wndLog->_maxy+3, 1, ACS_HLINE, wndTop->_maxx-1 );
    wrefresh( wndTop );      
    Clear( wndQueue );
    wrefresh( wndQueue );  
    wndSend = NULL;
    wndReceiv = NULL;
  }    
}

/*******************************************************************************
                     
*******************************************************************************/
void InfoOutCall( void )
{
  if( TestOutCall() == FALSE ) 
    mvwaddstr( wndTop, 0, 1, " No call " );  
  else {
    wmove( wndTop, 0, 1 );
    whline( wndTop, ACS_HLINE, 10 );
  }        
  wrefresh( wndTop );                
}
  
