#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/resource.h>
#include <string.h>
#include <time.h>
#include "ifpollP.h"

/*******************************************************************************
                         
*******************************************************************************/
void ( *SetSignal( int signo, void (*hndlr)(int)) )(int)
{
  struct sigaction  act, oact;
  
  act.sa_handler = hndlr;
  sigemptyset( &act.sa_mask );
  act.sa_flags = 0;
  if( signo != SIGALRM )
    act.sa_flags |= SA_RESTART;
    
  if( sigaction( signo, &act, &oact ) < 0 )
    return( SIG_ERR );
    
  return( oact.sa_handler );    
}


/************************************************************************************
                             SIGUSR2			   
************************************************************************************/
void SigAlrm( int signo )
{ 
   static int tickShowQueue = 0;
   static int tickShowDelay = 0;
   static int tickSec = 0;
   
   
   /*    */
   infoEmsiOld = infoEmsi;
   
   /*   */
   semshm.LockSemaphore();
   semshm.ReadShm( &infoEmsi );
   semshm.UnlockSemaphore();
   
   PrintLogString();   

   if( _flagNoTick == TRUE ) return;  
   
   if( ++tickSec == 10 ) {
      char       tmpStr[ MAX_LENGTH_STRING ];
      time_t     GMTime;      
      GMTime = time( (time_t *)NULL );
      sprintf( tmpStr, " %s ", ctime( &GMTime ) );
      *(strstr( tmpStr, "\n" )) = '\0';
      strcat( tmpStr, " " );
      mvwaddstr( wndTop, wndTop->_maxy, wndTop->_maxx-strlen( tmpStr ), tmpStr );      
      wrefresh( wndTop );
      tickSec = 0;
      InfoOutCall();
   }
   
   
   


   if( ++tickShowDelay == 5 ) {
         ShowDelay();
         tickShowDelay = 0;
   }       
   
   if( infoEmsi.status == SYSTEM_CONNECT ) {
      InitScreenConnect();    
      ShowConnect();
      ShowTransferReceive( VIEW );     
      ShowTransferSend( VIEW );     
   }
   else {
      DestroyScreenConnect();
      ShowTransferReceive( RESET_VIEW );     
      ShowTransferSend( RESET_VIEW );     
      if( ++tickShowQueue == 2 ) {
         ShowQueue(); 
	 tickShowQueue = 0;
      }	 
   }
   
//   SaveEmsi();   
}

void SaveEmsi( void )
{
   if( strcmp( infoEmsi.origStr, infoEmsiOld.origStr ) == 0 ) return;
   LOG( 0, "+++++++++++++++++++++++++ EMSI +++++++++++++++++++++\n" );
   LOG( 0, "%s\n", infoEmsi.origStr );
   LOG( 0, "%d\n", infoEmsi.status );
   LOG( 0, "%s\n", infoEmsi.connect );
   LOG( 0, "%s\n", infoEmsi.address );
   LOG( 0, "%s\n", infoEmsi.passwd );
   LOG( 0, "%s\n", infoEmsi.uses );
   LOG( 0, "%s\n", infoEmsi.time );
   LOG( 0, "%s\n", infoEmsi.system );
   LOG( 0, "%s\n", infoEmsi.location );   
   LOG( 0, "%s\n", infoEmsi.sysop );
   LOG( 0, "%s\n", infoEmsi.phone );
   LOG( 0, "%s\n", infoEmsi.baud );
   LOG( 0, "%s\n", infoEmsi.flags );
   LOG( 0, "%s\n", infoEmsi.mail );
   LOG( 0, "%s\n", infoEmsi.echomail );
   LOG( 0, "%s\n", infoEmsi.fileSend );
   LOG( 0, "%s\n", infoEmsi.fileReceive );
   
   LOG( 0, "%d\n", infoEmsi.sizeCurrReceive );
   LOG( 0, "%d\n", infoEmsi.sizeCurrSend );
   LOG( 0, "%d\n", infoEmsi.numReceiveFile );
   LOG( 0, "%d\n", infoEmsi.numSendFile );
   LOG( 0, "%d\n", infoEmsi.sizeTotalReceive );
   LOG( 0, "%d\n", infoEmsi.sizeTotalSend );
   
}


