#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "ifpollP.h"

/******************************************************************************
                             
*******************************************************************************/
void ShowInfoNode( void )
{
   char  tmpStr[ MAX_LENGTH_STRING ];   

   _flagNoTick = TRUE;

   /*       */
   if( ClientReceiveReport( MSG_ANSWER_NODE_INFO ) == TRUE ) goto RESTART;
   
   /*    */
   _message.nodeIndex = _indexCurrNode;
   ClientSendInquiry( SEND_SHOW_INFO_NODE_INDEX );   
   
   /*   */
   if( ClientReceiveReport( MSG_ANSWER_NODE_INFO ) == FALSE ) {
     _flagNoTick = FALSE;
     return;
   }     
   
 RESTART:   
   PrintHelpString( " r - view freq  h - view hold  s - view send  Other key - exit " );
   sprintf( tmpStr, "Info for node %d:%d/%d.%d", _message.address.zone,
                                                 _message.address.net, 
						 _message.address.node, 
						 _message.address.point );                                                 
   PrintInfoString( tmpStr );
  
   Clear( wndQueue );
   wmove( wndQueue, 0, 0 );
   sprintf( tmpStr, "Name System    - %s\n", _message.name );
   waddstr( wndQueue, tmpStr );					     
   sprintf( tmpStr, "Location       - %s\n", _message.location );
   waddstr( wndQueue, tmpStr );					     
   sprintf( tmpStr, "SysOp          - %s\n", _message.sysop );
   waddstr( wndQueue, tmpStr );					     
   sprintf( tmpStr, "Phone          - %s\n", _message.phone );
   waddstr( wndQueue, tmpStr );					     
   sprintf( tmpStr, "Speed          - %s\n", _message.speed );
   waddstr( wndQueue, tmpStr );					     
   
   if( _message.startTimeHour < 0 || _message.startTimeMin < 0 ||
       _message.endTimeHour < 0 || _message.endTimeMin < 0 ) 
       sprintf( tmpStr, "Work time      - undefine\n" );
   else        
      sprintf( tmpStr, "Work time      - %d:%d-%d:%d\n", _message.startTimeHour,
                                                      _message.startTimeMin,
                                                      _message.endTimeHour,
                                                      _message.endTimeMin );         					      
   waddstr( wndQueue, tmpStr );					     

   wrefresh( wndQueue );   
   
   int ch =getch();   
   
   if( ch == 'r' ) {
       ViewOutbound( ".req" );
       goto RESTART;
   }       
   if( ch == 'h' ) {
       ViewOutbound( ".hlo" );
       goto RESTART;
   }       
   if( ch == 's' ) {
       ViewOutbound( ".flo" );
       goto RESTART;
   }           
   
   Clear( wndQueue );   

   _flagNoTick = FALSE;
   
   /*   */
  PrintHelpString( " F1 Help   Meta-X Quit " );
//  PrintInfoString( "" );
}


/******************************************************************************
                          Outbound`a
*******************************************************************************/
void ViewOutbound( char *flag )
{
  char  maska[ MAX_LENGTH_STRING ];
  char  str[ MAX_LENGTH_STRING ];
  int   currY;
  int   top = 0;
  FILE  *fp;
  int   ch;
  int   done = 0;
  
  Clear( wndQueue );
  PrintHelpString( " KeyUp - ScrollUp  KeyDown - ScrollDown  q - Exit " );
  sprintf( maska, "%d:%d/%d.%d...", _message.address.zone, _message.address.net, 
                                    _message.address.node, _message.address.point );                                                 
  if( strstr( flag, "req" ) )
         sprintf( str, "View file request for node " );
  if( strstr( flag, "hlo" ) )
         sprintf( str, "View hold file for node " );
  if( strstr( flag, "flo" ) )
         sprintf( str, "View send file for node " );

  strcat( str, maska );  			       
  PrintInfoString( str );  
  
  AddressDig2Str( &_message.address, maska );
  strcat( maska, flag );  
  
  if( access( maska, F_OK ) == 0 ) 
  {
     fp = fopen( maska, "r" );
QQQ:     
     currY = 0;
     while( !done )
     {
       if( fgets( str, MAX_LENGTH_STRING - 1, fp ) == NULL ) {
          strcpy( str, "----- End File ----\n" );
	  currY = wndQueue->_maxy + top;
       }	  
	  
       if( currY < top ) {
	 currY++;
         continue;
       }
       mvwaddstr( wndQueue, currY-top, 0, str );
       wrefresh( wndQueue );
       currY++;
       if( currY-top > wndQueue->_maxy ) {

         ch = getch();
	 if( ch == KEY_DOWN ) {	    
            rewind( fp );
	    if( strstr( str, "End File" ) == NULL ) top++;
	    Clear( wndQueue );	 
            printf( "\a\n" );
	    goto QQQ;
	 }
	 if( ch == KEY_UP ) {
	    rewind( fp );
   	    if( top > 0 ) top--;
	    Clear( wndQueue );	 
            printf( "\a\n" );
	    goto QQQ;
	 }    
	 if( ch == 'q' ) done = 1;
       }
     }     
     fclose( fp );
  }
  else {
     if( strstr( flag, "req" ) )
         mvwaddstr( wndQueue, 3, 25, "---=== No file request ===---" );
     if( strstr( flag, "hlo" ) )
         mvwaddstr( wndQueue, 3, 26,  "---=== No hold file ===---" );
     if( strstr( flag, "flo" ) )
         mvwaddstr( wndQueue, 3, 26,  "---=== No send file ===---" );	
     wrefresh( wndQueue );
     ch = getch();
  }
}
