#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ifpollP.h"

/*******************************************************************************
                                                         
*******************************************************************************/
void CreateFlag( int flag )
{
   char          address [ MAX_LENGTH_STRING ];
   char          ffiles  [ MAX_LENGTH_STRING ];
   WINDOW        *wnd;
  
   _flagNoTick = TRUE; 
  
   Clear( wndQueue );
   switch( flag ) 
   {
     case FLAG_POLL: PrintInfoString( "Create poll to address..." );   break;                 
     case FLAG_FREQ: PrintInfoString( "Create freq from address..." ); break;	                     
     case FLAG_HOLD: PrintInfoString( "Hold files to node..." );       break;
     case FLAG_SEND: PrintInfoString( "Send files to node..." );       break;
   }
   
   if( flag == FLAG_POLL ) {
      wnd = newwin( 3, 37, 19, 21 );   
      mvwaddstr( wnd, 1, 2, "Address: ");
   }
   else {
      wnd = newwin( 4, 50, 19, 14 );   
      mvwaddstr( wnd, 1, 2, "Files: ");
      mvwaddstr( wnd, 2, 2, "Address: ");
   }
   box( wnd, 0, 0 );
  
   curs_set( TRUE );
   wrefresh( wnd );
   echo();
   
   strcpy( address, "" );
   strcpy( ffiles,  "" ); 

   if( flag == FLAG_POLL ) {
      mvwgetstr( wnd, 1, 11, address );
   }
   else {
      mvwgetstr( wnd, 1, 11, ffiles );
      mvwgetstr( wnd, 2, 11, address );      
   }
   
   if( strcmp( address, "" ) != 0 ) {
      AddressStr2Dig( address, &_message.address );
      CreateFlag( flag, &_message.address, ffiles );
      ClientSendInquiry( SEND_REREAD_QUEUE );  
   }      
   werase( wnd );
   wclear( wnd );      
   Clear( wnd );  
   curs_set( FALSE );
   noecho();
   delwin( wnd );   
   _flagNoTick = FALSE;
}


/*******************************************************************************
                                
*******************************************************************************/
void SendTransitFileCP( void )
{
   char          address [ MAX_LENGTH_STRING ];
   char          ffiles  [ MAX_LENGTH_STRING ];
   char          tmpStr  [ MAX_LENGTH_STRING ];
   WINDOW        *wnd;
   FILE          *fp;
  
   _flagNoTick = TRUE; 
  
   Clear( wndQueue );
   PrintInfoString( "Send transit file..." );

   wnd = newwin( 4, 50, 19, 14 );   
   mvwaddstr( wnd, 1, 2, "Files: ");
   mvwaddstr( wnd, 2, 2, "Address: "); 
   box( wnd, 0, 0 );
  
   curs_set( TRUE );
   wrefresh( wnd );
   echo();
   
   strcpy( address, "" );
   strcpy( ffiles,  "" ); 
   
   mvwgetstr( wnd, 1, 11, ffiles );
   mvwgetstr( wnd, 2, 11, address );      
   
   if( strcmp( address, "" ) != 0 ) {
      AddressStr2Dig( address, &_message.address );
      SendTransitFile( &_message.address, ffiles );      
   }      
 
   werase( wnd );
   wclear( wnd );      
   Clear( wnd );  
   curs_set( FALSE );
   noecho();
   delwin( wnd );   
   _flagNoTick = FALSE;
}
