#ifndef __IFPOLLLIB__MESSAGE__
#define __IFPOLLLIB__MESSAGE__

#include <curses.h>

#define FLAG_POLL      1
#define FLAG_FREQ      2
#define FLAG_SEND      3
#define FLAG_HOLD      4
#define FLAG_SENDKILL  5 
#define FLAG_CRASH     6


#define PERM       0666
#define KEY_QUEUE  666
#define KEY_SEMSHM 888


#define MSG_SERVER_INQUIRY         10L                 /*      */
#define MSG_ANSWER_INFO_QUEUE      20L                 /*       */
#define MSG_ONE_SEC                30L                 /*  1  */      
#define MSG_ANSWER_NODE_INFO       50L
#define MSG_ANSWER_DELAY           40L

#define REPLY_NO_QUEUE  0
#define REPLY_YES_NEXT  1
#define REPLY_NO_NEXT   2
#define REPLY_FOUND_YES 3
#define REPLY_FOUND_NO  4


#define SEND_SHOW_QUEUE            1
#define SEND_SHOW_INFO_NODE        2
#define SEND_SHOW_INFO_NODE_INDEX  3
#define SEND_SHOW_DELAY            4
#define SEND_SETSTATUS_INDEX       5
#define SEND_SETSTATUS             6
#define SEND_HANGUP                7
#define SEND_SETDELAY              8
#define SEND_REREAD_QUEUE          9
#define SEND_REREAD_LOG            10
#define SEND_DELETE_NODE_INDEX     11
#define SEND_DELETE_NODE           12

#define NO_SET_DELAY -1


typedef struct
{
       int  zone;                             /*  */
       int  net;                              /*  */ 
       int  node;                             /*  */
       int  point;                            /*  */
} address_type;



/******************************************************************************
                                 
******************************************************************************/
typedef struct our_msgbuf
{
  long          mtype;  
  int           codCommand;
  int           retData; 
  int           flagCurrentNode;
  int           flagCallNow;  
  int           status;
  int           nodeIndex;
  char          name    [ 30 ];    /*   */
  char          location[ 30 ];    /*  */
  char          sysop   [ 30 ];    /*   */
  char          phone   [ 30 ];    /*  */
  char          speed   [ 30 ];    /*  */
  int           startTimeMin;
  int           startTimeHour;
  int           endTimeMin;
  int           endTimeHour;
  address_type  address;
  int           delayZeroQueue;
  int           delayCall;
  int           delayNow;
  int           flagDelayCall;
  int           sizeOutMail;
  int		sizeOutFile;  
  int           sizeOutHold;
} MESSAGE_TYPE;


#define MSG_SIZE ( sizeof( MESSAGE_TYPE ) - sizeof( long ) )


#endif
