#ifndef __HEADER_IFFTN__
#define __HEADER_IFFTN__

#include <dirent.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/types.h>
#include <ncurses/ncurses.h>
#include "_log.h"
#include "message.h"
#include "_other.h"
#include "_convert.h"

//#define DEFAULT_ZONE 2
//#define DEFAULT_NET  5030
extern long  DEFAULT_ZONE;
extern long  DEFAULT_NET ;



#define MAX_LENGTH_STRING  (NAME_MAX+1)  /*    */

#define SET_STATUS        1
#define RESET_STATUS      0

#define STATUS_NORMAL     1
#define STATUS_CRASH      2
#define STATUS_HOLD       4
#define STATUS_IMMEDIATE  8
#define STATUS_UNDIALABLE 16
#define STATUS_REQUEST    32
#define STATUS_HLO        64
#define STATUS_OUT        128
#define STATUS_BSY        256


extern char  *_nlookup      ;
extern char  *_fileLog      ;     /*   */					   
extern char  *_temp         ;
extern char  *_subst        ;
extern char  *_outbound     ;
extern int   _levelLog      ;
extern char  *_fileLogIfcico;
extern char  *_fileNocall;
extern char  *_filePid;       /*   */
extern char            *_mta;
extern char            *_domain;


class ftn_node 
{
    protected: 
       char tmpStr  [ MAX_LENGTH_STRING ];
       int  deltaTime;
    
    public:        /* */
       char          name    [ 30 ];    /*   */
       char          location[ 30 ];    /*  */
       char          sysop   [ 30 ];    /*   */
       char          phone   [ 30 ];    /*  */
       char          speed   [ 30 ];    /*  */
       long          minspeed;    /*    */
       int           flagCallNow;
       address_type  address;
       int           startTimeMin;
       int           startTimeHour;
       int           endTimeMin;
       int           endTimeHour;
       int           status;
       int           sizeOutMail;
       int           sizeOutFile;  
       int           sizeOutHold;
       
    private:
       void DetectTimeFlag( char *str );
       
    public:       
       ftn_node();
      ~ftn_node();
       
       void ReadNodelist  ( void );
       void ReadSubst     ( void );    
       void TestCallNow   ( void );
       void SRStatus      ( int flag, int newstatus );
       void ReadStatus    ( void );
       void RemoveAllFlags( void );
       void GetOutSize    ( void );
};


#endif
