#include <unistd.h>
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ifftn.h"



/************************************************************************************
                           
		       ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
************************************************************************************/
void ftn_node::ReadSubst( void )
{
   FILE         *fp;
   char         str[ MAX_LENGTH_STRING ];
   char         *strPtr;
   address_type saddr;
   char         sphone[ MAX_LENGTH_STRING ];   
   
   if( (fp = fopen( _subst, "r" )) == NULL ) {
      LOG( 0, "Warning! Unable open file subst %s. Continue...\n", _subst );
      return;
   }



   LOG( 2, "     Rescan %s for node %d:%d/%d.%d...\n", _subst, 
                                                  address.zone, address.net,
                                                  address.node, address.point );
						  
   /*          */
   while( fgets( tmpStr, MAX_LENGTH_STRING - 1, fp ) != NULL )
   {
      /*  ,  */
      if( (*tmpStr == '#') || (*tmpStr == ';' ) ) continue;
	 
      /*   ,  */
      if( *tmpStr == '\n' ) continue;
      
      /*     -  */
      if( isdigit( *tmpStr ) )
      {
	 /*   */
	 strcpy( str, tmpStr );
	 strPtr = &str[ 0 ];
	 while( (*strPtr != '\0') && (*strPtr != '\n' ) ) {	    
	    if( (*strPtr == ' ' ) || (*strPtr == '\t') ) {
	       *strPtr = '\0';
	       break;
	    }
	    strPtr++;
	 }
	 saddr.zone  = DEFAULT_ZONE;
	 saddr.net   = DEFAULT_NET;
	 saddr.node  = 0;
	 saddr.point = 0;
	 sscanf( str, "%d:%d/%d.%d", &saddr.zone, &saddr.net, 
	                             &saddr.node, &saddr.point );
	 if( (saddr.zone  == address.zone) &&
             (saddr.net   == address.net ) &&
             (saddr.node  == address.node) &&
             (saddr.point == address.point) )
	 {
	    LOG( 2, "     Found address in %s %d:%d/%d.%d\n", _subst,
		                              saddr.zone, saddr.net, 
	                                      saddr.node, saddr.point );
	    /*     */
	    strPtr = strstr( tmpStr, "Phone" );
	    if( strPtr == NULL ) {
	       LOG( 2, "        Phone: %s (No Change)\n", phone );
	       goto LABEL_GETTIME;
	    }
	    
	    LOG( 2, "        Old Phone: %s\n", phone );
	    while( !isdigit( *strPtr ) ) strPtr ++;
            strcpy( str, strPtr );
	    strPtr = &str[ 0 ];
            while( (*strPtr != '\0') && (*strPtr != '\n' ) && 
		   (*strPtr != '\t' ) && (*strPtr != ' ' )) strPtr++;
	    *strPtr = '\0';	
	    strcpy( phone, str );
	    LOG( 2, "        Phone: %s (Change)\n", phone );

	    /* 
	     *     
	     */	    
	   LABEL_GETTIME: 
	    strPtr = strstr( tmpStr, "Time" );
	    if( strPtr == NULL ) {
              LOG( 2, "        Time:  %d:%d-%d:%d ( No Change)\n", startTimeHour, 
		                                                   startTimeMin,
		                                                   endTimeHour, 
		                                                   endTimeMin );
	      goto LABEL_GETSPEED;
	    } 	       
    	    while( !isdigit( *strPtr ) ) strPtr ++;
            strcpy( str, strPtr );
    	    strPtr = &str[ 0 ];
	    while( (*strPtr != '\0') && (*strPtr != '\n' ) && 
                    (*strPtr != '\t' ) && (*strPtr != ' ' )) strPtr++;
	    *strPtr = '\0';	
	    LOG( 2, "        OldTime:  %d:%d-%d:%d\n", startTimeHour, startTimeMin,
		                                       endTimeHour, endTimeMin );
	    
	    sscanf( str, "%d:%d-%d:%d", &startTimeHour, &startTimeMin,
		                        &endTimeHour,   &endTimeMin );
					
      	    LOG( 2, "        Time:  %d:%d-%d:%d (Change)\n", startTimeHour, startTimeMin,
		                                             endTimeHour, endTimeMin );
	      						     
	    /* 
	     *     
	     */
	   LABEL_GETSPEED:
	    strPtr = strstr( tmpStr, "MinSpeed" );
	    if( strPtr == NULL ) {
	        LOG( 2, "        MinSpeed - NoDefines\n" );
		goto LABEL_ENDSCAN;	     
	    }
	    while( !isdigit( *strPtr ) ) strPtr ++;
	    sscanf( strPtr, "%d", &minspeed );
	    LOG( 2, "        MinSpeed - %d\n", minspeed );

           LABEL_ENDSCAN:
	    break; 
	 }   
         
      } /* end if( isdigit( *tmpStr ) )  */
   }   
   
   fclose( fp );
   LOG( 2, "   Done...\n" );
}


