#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ifftn.h"
#include "_other.h"


/*******************************************************************************
                            
*******************************************************************************/
void ftn_node::SRStatus( int flag, int newstatus )
{
   char          maska[ MAX_LENGTH_STRING ];
   char          fname[ MAX_LENGTH_STRING ];
   FILE          *fp;
   int           index;
 
   /*    */
   AddressDig2Str( &address, maska );

   switch( newstatus )
   {
     case STATUS_NORMAL:    strcat( maska, ".flo" ); break;
     case STATUS_CRASH:     strcat( maska, ".clo" ); break;
     case STATUS_HLO:       strcat( maska, ".hlo" ); break;
     case STATUS_HOLD:      strcat( maska, ".hld" ); break;
     case STATUS_IMMEDIATE: strcat( maska, ".imm" ); break;     
     case STATUS_REQUEST:   strcat( maska, ".req" ); break;     
     case STATUS_OUT:       strcat( maska, ".out" ); break;     
     case STATUS_BSY:       strcat( maska, ".bsy" ); break;     
   }
   
   if( flag == SET_STATUS ) {   
      /*   ,     */
      if( address.point != 0 ) {
        sprintf( fname, "mkdir %s", maska );
        for( index = strlen( fname ) ; index > 0; index-- ) {
           if( fname[ index ] == '/' ) {
              fname[ index ] = '\0';
	      break;
           }    	 
        }       
	/*      */
	if( access( maska, F_OK ) != 0 ) system( fname );
      }

      if( access( maska, F_OK ) != 0 ) {
         fp = fopen( maska, "w" );
         fclose( fp );
      }     
   }
   else {
      remove( maska );
   }      
}

/*******************************************************************************
                            
*******************************************************************************/
void ftn_node::ReadStatus( void )
{
   char          maska[ MAX_LENGTH_STRING ];
   char          fname[ MAX_LENGTH_STRING ];
   int           flagFLO = FALSE;
   int           flagCLO = FALSE;
   int           flagOUT = FALSE;
   int           flagREQ = FALSE;
   int           flagIMM = FALSE;
   int           flagHLD = FALSE;
   int           flagHLO = FALSE;
   
   
   /*    */
   AddressDig2Str( &address, maska );
   
   status = 0;
   
   /*     */
   sprintf( fname, "%s.flo", maska );   
   if( access( fname, F_OK ) == 0 ) flagFLO = TRUE;
   sprintf( fname, "%s.clo", maska );   
   if( access( fname, F_OK ) == 0 ) flagCLO = TRUE;
   sprintf( fname, "%s.out", maska );   
   if( access( fname, F_OK ) == 0 ) flagOUT = TRUE;
   sprintf( fname, "%s.req", maska );   
   if( access( fname, F_OK ) == 0 ) flagREQ = TRUE;
   sprintf( fname, "%s.imm", maska );   
   if( access( fname, F_OK ) == 0 ) flagIMM = TRUE;
   sprintf( fname, "%s.hld", maska );   
   if( access( fname, F_OK ) == 0 ) flagHLD = TRUE;
   sprintf( fname, "%s.hlo", maska );   
   if( access( fname, F_OK ) == 0 ) flagHLO = TRUE;

   
//   LOG( 3, "   flagFLO - %d\n", flagFLO );
//   LOG( 3, "   flagCLO - %d\n", flagCLO );
//   LOG( 3, "   flagOUT - %d\n", flagOUT );
//   LOG( 3, "   flagREQ - %d\n", flagREQ );
//   LOG( 3, "   flagIMM - %d\n", flagIMM );
//   LOG( 3, "   flagHLD - %d\n", flagHLD );
//   LOG( 3, "   flagHLO - %d\n", flagHLO );
      
   /*  .req  .flo   .flo  .clo  */
   if( (flagREQ == TRUE ) && (flagFLO == FALSE ) ) SRStatus( SET_STATUS, STATUS_NORMAL );
   
   /*  .out  .flo   .flo  .clo */
   if( (flagOUT == TRUE ) && (flagFLO == FALSE ) ) SRStatus( SET_STATUS, STATUS_NORMAL );
       
   if( flagFLO == TRUE ) status |= STATUS_NORMAL;
   if( flagCLO == TRUE ) status |= STATUS_CRASH;
   if( flagHLD == TRUE ) status |= STATUS_HOLD;  
   if( flagIMM == TRUE ) status |= STATUS_IMMEDIATE;
   if( flagHLO == TRUE ) status |= STATUS_HLO;
}

/*******************************************************************************
                           __  
*******************************************************************************/
void ftn_node::RemoveAllFlags( void )
{
  SRStatus( RESET_STATUS, STATUS_NORMAL    );
  SRStatus( RESET_STATUS, STATUS_CRASH     );
  SRStatus( RESET_STATUS, STATUS_HOLD      );
  SRStatus( RESET_STATUS, STATUS_IMMEDIATE );
  SRStatus( RESET_STATUS, STATUS_REQUEST   );  
  SRStatus( RESET_STATUS, STATUS_HLO       );  
  SRStatus( RESET_STATUS, STATUS_OUT       );    
}
