#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <signal.h>
#include <sys/stat.h>
#include "ifftn.h"


/*******************************************************************************
                     
*******************************************************************************/
void ftn_node::ReadNodelist( void )
{
   FILE *fp;
   struct stat fStat;

 RESTART:   
   /*    nlookup */
   sprintf( tmpStr, "%s -v %d:%d/%d.%d > %s", _nlookup, 
	                                       address.zone, 
	                                       address.net, 
	                                       address.node, 
	                                       address.point, 
	                                       _temp );   
   system( tmpStr );
   
   /*     ,    */
   if( (fp = fopen( _temp, "r" )) == NULL ) {
      LOG( 0, "Unable open temp file in function ReadNodelist\n" );
      goto RESTART;
   }
   
   /*     */
   while( fgets( tmpStr, MAX_LENGTH_STRING - 1, fp ) != NULL )
   {
      if( strstr( tmpStr, "Name:" ) != NULL ) 
         strcpy( name, strstr( tmpStr, "Name:" ) + strlen( "Name: " ) );
      if( strstr( tmpStr, "Location:" ) != NULL ) 
         strcpy( location, strstr( tmpStr, "Location:" ) + strlen( "Location: " ) );
      if( strstr( tmpStr, "SysOp:" ) != NULL ) 
         strcpy( sysop, strstr( tmpStr, "SysOp:" ) + strlen( "SysOp: " ) );
      if( strstr( tmpStr, "Phone:" ) != NULL ) 
         strcpy( phone, strstr( tmpStr, "Phone:" ) + strlen( "Phone: " ) );
      if( strstr( tmpStr, "Speed:" ) != NULL ) 
         strcpy( speed, strstr( tmpStr, "Speed:" ) + strlen( "Speed: " ) );
      if( strstr( tmpStr, "Flags:" ) != NULL ) {
	 DetectTimeFlag( tmpStr );
      }
      if( strstr( tmpStr, "HOLD" ) != NULL ) {
	 status &= STATUS_UNDIALABLE;
      }          	 
   }   
   fclose( fp );      
   name[ strlen(name) - 1 ]         = '\0';
   location[ strlen(location) - 1 ] = '\0';
   sysop[ strlen(sysop) - 1 ]       = '\0';
   phone[ strlen(phone) - 1 ]       = '\0';
   speed[ strlen(speed) - 1 ]       = '\0';   
   
   /*    */   
   remove( _temp );
}



/*******************************************************************************
                         (GMT)             
*******************************************************************************/
void ftn_node::DetectTimeFlag( char *str )
{
   /*   flags */
   while( *str != ' ' ) str ++;
   
   /*    */
   while( *str != '\0' && *str != '\n' ) {
      while( (*str == ' ') || (*str ==',' ) ) str++;
      
      if( (*str == 'T') ||
	   ( (*str == 'U' ) && (*(str+1) == 'T' ) ) ) {
	 
         startTimeHour =  (int)(toupper(*(str+1)) - 'A');
	 if( islower( *(str+1) ) ) 	  
	    startTimeMin = 30; 
	 else 
	    startTimeMin = 0;
	 
         endTimeHour =  (int)(toupper(*(str+2)) - 'A');
	 if( islower( *(str+2) ) ) 	  
	    endTimeMin = 30; 
	 else 
	    endTimeMin = 0;	 
      }
      else {
	 if( (*str == 'C') && (*(str+1) == 'M') ) {
	    startTimeHour = 0;
	    startTimeMin  = 0;
	    endTimeHour   = 24;
	    endTimeMin    = 00;	    
	 }
      }
      while( (*str != ' ') && (*str != '\0') ) str ++;
   }   
   
   /*     */
//   LOG( 2, "     Work time(GMT) %d:%d - %d:%d\n", startTimeHour, startTimeMin,
//                                                  endTimeHour, endTimeMin );
//   LOG( 2, "DeltaTime - %d\n", deltaTime );						
   if( startTimeHour != 0 ) startTimeHour += deltaTime;
   if( startTimeHour >= 24 ) startTimeHour -= 24;
   if( endTimeHour != 24 )  endTimeHour += deltaTime;
   if( endTimeHour > 24 )   endTimeHour -= 24;   
   
   LOG( 2, "     Work time %d:%d - %d:%d\n", startTimeHour, startTimeMin,
                                             endTimeHour, endTimeMin );

}
