#ifndef __HEADER_SEMAPHORE_LIB__
#define __HEADER_SEMAPHORE_LIB__

#include <sys/ipc.h>
#include <sys/types.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include "ifftn.h"

#define _LOCK_         0
#define _UNLOCK_       1

#define SYSTEM_WAIT            0
#define SYSTEM_WAIT_CONNECT    1
#define SYSTEM_CONNECT         2


typedef struct
{  
   char    origStr[ MAX_LENGTH_STRING ];     /*     */
   int     status;
   char    connect [ 50 ];
   char    address [ MAX_LENGTH_STRING ];
   char    passwd  [ 30 ];
   char    uses    [ MAX_LENGTH_STRING ];
   char    time    [ 30 ];
   char    system  [ 30 ];
   char    location[ 30 ];
   char    sysop   [ 30 ];
   char    phone   [ 30 ];
   char    baud    [ 30 ];
   char    flags   [ 40 ];
   char    mail    [ 20 ];
   char    echomail[ 20 ];    

   char    fileSend   [ MAX_LENGTH_STRING ]; /*      */
   char    fileReceive[ MAX_LENGTH_STRING ]; /*     */
   long    sizeCurrReceive;                  /*     */ 
   long    sizeCurrSend;                     /*     */ 
   long    numReceiveFile;                   /*     */
   long    numSendFile;                      /*     */   
   long    sizeTotalReceive;                 /*     */
   long    sizeTotalSend;                    /*     */
   long    timeOnLine;
} emsi_and_info_type;


#define SIZE_SHM ( sizeof( emsi_and_info_type ) )




class semshm_obj 
{     
  private:
    key_t           keySem;           /*   */      
    int             semId;            /*    */  
    
    key_t           keyShm;
    emsi_and_info_type            *shmPtr;
    int             shmId;
        
  public:
    semshm_obj();
    ~semshm_obj();   
    
    int CreateSemaphore( void );
    int DeleteSemaphore( void );
    int OpenSemaphore( void );
    int GetValSemaphore ( void );
    int UnlockSemaphore ( void );
    int LockSemaphore   ( void );

    int CreateAndAttachShm( void );
    int DetachAndDeleteShm( void );
    int OpenAndAttachShm( void );
    int DetachShm( void );
    
    void SaveShm( emsi_and_info_type *emi );
    void ReadShm( emsi_and_info_type *emi );    
};


#endif

