#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include "ifftn.h"




/***************************************************************************
                 
                       ifmailo`m
 "2:5030/238.3" -> FTN_NODE		      
***************************************************************************/
void AddressStr2Dig( char *str, address_type *addr )
{
   char             tmpStr[ MAX_LENGTH_STRING ];
   char             *tmpPtr = tmpStr;
   
   strcpy( tmpStr, str );
   memset( addr, 0, sizeof( addr ) );
   
   addr->zone = DEFAULT_ZONE;
   addr->net  = DEFAULT_NET;
   
   if( (tmpPtr = strchr( tmpStr, '.' )) != NULL ) {
      addr->point = (int)atol( tmpPtr+1 );
      *tmpPtr = '\0';    
   } 
   else addr->point = 0;

  if( (tmpPtr = strchr( tmpStr, '/' )) != NULL ) {
     addr->node = (int)atol( tmpPtr+1 );
     *tmpPtr = '\0';
  }
  else {
    addr->node = (int)atol( tmpStr );
    goto END;
  }
  
  if( (tmpPtr = strchr( tmpStr, ':' )) != NULL ) {
    addr->net = (int)atol( tmpPtr+1 );
    *tmpPtr = '\0';
  }
  else {
    addr->net = (int)atol( tmpStr );
    goto END;
  }
  
  addr->zone = (int)atol( tmpStr );  
 END: 
 
  return;
}

/***************************************************************************
                        
		   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
***************************************************************************/
void AddressDig2Str( address_type *addr, char *str  )
{
  char tmpStr[ MAX_LENGTH_STRING ];

  strcpy( str, _outbound );
  if( addr->zone != DEFAULT_ZONE )   {
    sprintf( tmpStr, ".%03x", addr->zone );
    strcat( str, tmpStr );

    /*      */
    if( access( str, F_OK ) != 0 ) {
      sprintf( tmpStr, "mkdir %s", str );
      system( tmpStr );
    }
  }  
  sprintf( tmpStr, "/%04x%04x", addr->net, addr->node );
  strcat( str, tmpStr );
  
  if( addr->point != 0 ) {
      sprintf( tmpStr, ".pnt/%08x", addr->point );
      strcat( str, tmpStr );
  }
}


/***************************************************************************
                   . 
		   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
***************************************************************************/
void AddressPath2Dig( char *str, address_type *addr )
{
    char  *tmpPtr;
    char  tmpAddr[ MAX_LENGTH_STRING ];
    
    /*     outbound`a */
    tmpPtr = str + strlen( _outbound );

    /*    `.`      */
    if( *tmpPtr == '.' ) {    
       tmpPtr++;
       /*     */
       strncpy( tmpAddr, tmpPtr, strchr( tmpPtr, '/' ) - tmpPtr );
       tmpAddr[ strchr( tmpPtr, '/' ) - tmpPtr ] = '\0';
       addr->zone = strtol( tmpAddr, NULL, 16 );
    }
    else {
       addr->zone = DEFAULT_ZONE;
    }
    /*    `/` */
    while( *tmpPtr != '/' ) tmpPtr ++;
    tmpPtr++;
    
    /*   */
    strncpy( tmpAddr, tmpPtr, 4 );
    tmpAddr[4] = '\0';
    addr->net = strtol( tmpAddr, NULL, 16 );
    
    /*   */
    tmpPtr += 4;
    strncpy( tmpAddr, tmpPtr, 4 );
    tmpAddr[4] = '\0';
    addr->node = strtol( tmpAddr, NULL, 16 );
    
    /*   */
    tmpPtr = strstr( tmpPtr, ".pnt" );
    if( tmpPtr == NULL )  {    
       addr->point = 0;
    }
    else {
      tmpPtr += 5;
      *(tmpPtr + 8 ) = '\0';
      addr->point = strtol( tmpPtr, NULL, 16 );
    }       
}





/***************************************************************************
                        
***************************************************************************/
void CreateFlag( int flag, address_type *addr, char *str )
{
  ftn_node      tmpNode;
  char          maska[ MAX_LENGTH_STRING ];
  FILE          *fp;
  int           index;
  
  tmpNode.address = *addr;    

  /*  FLAG_HOLD  hlo  flo */
  if( flag == FLAG_HOLD ) tmpNode.SRStatus( SET_STATUS, STATUS_HLO );
  else                    tmpNode.SRStatus( SET_STATUS, STATUS_NORMAL );
  
  /*  FLAG_POLL      */
  if( flag == FLAG_POLL ) return;
  
  AddressDig2Str( addr, maska ); 

  switch( flag )
  {
    case FLAG_FREQ:       strcat( maska, ".req" ); break;
    case FLAG_CRASH:      strcat( maska, ".clo" ); break;
    case FLAG_SEND:       strcat( maska, ".flo" ); break;
    case FLAG_SENDKILL:   strcat( maska, ".flo" ); break;
    case FLAG_HOLD:       strcat( maska, ".hlo" ); break;
  }
  
  /*   */
  fp = fopen( maska, "a+" );
  if( flag == FLAG_SENDKILL ) fprintf( fp, "^" ); 
  
  /*     */
  index = 0;
  while( (str[ index ] != '\n') && (str[ index ] != '\0' ) ) {
    if( str[ index ] != ' ' )
      fprintf( fp, "%c", str[ index ] );
    else {
      fprintf( fp, "\n" );
      if( (str[ index+1 ] != '\n') && (str[ index+1 ] != '\0' ) ) {
         if( flag == FLAG_SENDKILL ) fprintf( fp, "^" ); 
      }	 
      /*^^^^^^^^^^^^^^^^^*/
      while( str[ index ] == ' ' ) index++;
      index--;
    }      
    index++;  
  }  
  fprintf( fp, "\n" );  
  fclose( fp );
}

/***************************************************************************
                          
  : TRUE  -  
         FALSE -  		       
***************************************************************************/
int TestOutCall( void )
{
  if( access( _fileNocall, F_OK ) == 0 ) {
      return( FALSE );
  }
  return TRUE;
}

/***************************************************************************
                        NOCALL 
***************************************************************************/
void CreateNocallFile( void )
{
  FILE *fp;
  fp = fopen( _fileNocall, "w" );
  fclose( fp );
}

/***************************************************************************
                        NOCALL 
***************************************************************************/
void DeleteNocallFile( void )
{
  remove( _fileNocall );
}


/***************************************************************************
                          
FALSE -  
TRUE  - 		       
***************************************************************************/
int TestPidFile( void )
{
  if( access( _filePid, F_OK ) == 0 ) {
      return( TRUE );
  }
  return FALSE;
}

/***************************************************************************
                         
***************************************************************************/
void DeletePidFile( void )
{
  remove( _filePid );
}


/***************************************************************************
                         
***************************************************************************/
void CreatePidFile( void )
{
  FILE *fp;
  fp = fopen( _filePid, "w" );
  fprintf( fp, "%d\n", getpid() );
  fclose( fp );
}

/***************************************************************************
                         
***************************************************************************/
void SendTransitFile( address_type *addr, char *ffiles )
{
   FILE          *fp;
   char          tmpStr[ MAX_LENGTH_STRING ];
   
   fp = fopen( "/tmp/tmp.mta.tmp", "w" );
   fprintf( fp, "From: root@localhost\n" );
   fprintf( fp, "To: SysOp@p%d.f%d.n%d.z%d.%s\n", addr->point, addr->node,
				   	          addr->net, addr->zone,
						  _domain );
   fprintf( fp, "Subject: %s\n", ffiles);						   
   fprintf( fp, "X-FTN-FLAGS: ATT\n" );      
   fclose( fp );      
   sprintf( tmpStr, "%s < /tmp/tmp.mta.tmp", _mta );
   system( tmpStr );
   remove( "/tmp/tmp.mta.tmp" );
}

