#include <unistd.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include "_semshm.h"



/*******************************************************************************
                         
*******************************************************************************/
int semshm_obj::CreateAndAttachShm( void )
{
   shmId = shmget( keyShm, SIZE_SHM, PERM|IPC_CREAT );
   if( shmId < 0 ) return( FALSE );
   
   /*   */
   shmPtr = (emsi_and_info_type *)shmat( shmId, 0, 0 );
   if( shmPtr < 0 )  return( FALSE );
   
   return( TRUE );
}

/*******************************************************************************
                          
*******************************************************************************/
int semshm_obj::DetachAndDeleteShm( void )
{
   /*  */
   shmdt( (char *)shmPtr );
   /*   */
   shmctl( shmId, IPC_RMID, 0 );   
   return( TRUE );
}

/*******************************************************************************
                   
*******************************************************************************/
int semshm_obj::OpenAndAttachShm( void )
{
   shmId = shmget( keyShm, SIZE_SHM, PERM );
   if( shmId < 0 ) return( FALSE );
   
   /*   */
   shmPtr = (emsi_and_info_type *)shmat( shmId, 0, 0 );
   if( shmPtr < 0 )  return( FALSE );
   
   return( TRUE );
}

/*******************************************************************************
                     
*******************************************************************************/
int semshm_obj::DetachShm( void )
{
   /*  */
   shmdt( (char *)shmPtr );
 
}



/*******************************************************************************
                  C 
:  &emsi_and_info_type       
:      		  
*******************************************************************************/
void semshm_obj::SaveShm( emsi_and_info_type *emi )
{
   memcpy( shmPtr, emi, sizeof( emsi_and_info_type ) ); 
}


/*******************************************************************************
                    
:    

:      		  
*******************************************************************************/
void semshm_obj::ReadShm( emsi_and_info_type *emi )
{
   memcpy( emi, shmPtr, sizeof( emsi_and_info_type ) ); 
}
