#include <unistd.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include "_semshm.h"


/*******************************************************************************
                          
			  ~~~~~~~~~~~
*******************************************************************************/
semshm_obj ::semshm_obj()
{
  keySem     = KEY_SEMSHM;            /*   */
  keyShm     = KEY_SEMSHM;
}


/*******************************************************************************
                                
				~~~~~~~~~~
*******************************************************************************/
semshm_obj ::~semshm_obj()
{
}

/*******************************************************************************
   
*******************************************************************************/
int semshm_obj::CreateSemaphore( void )
{
   semId = semget( keySem, 1, PERM|IPC_CREAT );
   if( semId < 0 ) {
      return( FALSE );
   }
   return( TRUE );
}

/*******************************************************************************
                      
*******************************************************************************/
int semshm_obj::DeleteSemaphore( void )
{
   union semun tmpS;
   tmpS.val = 0;   
   if( (semctl( semId, 0, IPC_RMID, tmpS )) < 0 ) {
      return( FALSE );
   }
   return( TRUE );
}

int semshm_obj::OpenSemaphore( void )
{
   semId = semget( keySem, 1, PERM );
   if( semId < 0 ) {
      return( FALSE );
   }
   return( TRUE );
}


/*******************************************************************************
                        
		     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
: 
: 
*******************************************************************************/
int semshm_obj::GetValSemaphore( void )
{
   int  semval;
   union semun tmpS;
   tmpS.val = 0;   

   semval = semctl( semId, 0, GETVAL, tmpS );
   return(semval);
}

/*******************************************************************************
                        
		       ~~~~~~~~~~~~~~~~~~~~~~
: 		       
: 
*******************************************************************************/
int semshm_obj::UnlockSemaphore( void )
{
   struct sembuf sem_unlock={ 0, 1, 0 };
   int res;
   
   res = GetValSemaphore();
   if( res == _UNLOCK_ ) {
      return( TRUE );
   }      
   
   sem_unlock.sem_num = 0;
   
   if( (semop( semId, &sem_unlock, 1 ) ) == -1 ) {
      return( FALSE );
   }
   return( TRUE );   
}

/*******************************************************************************
                        
		       ~~~~~~~~~~~~~~~~~~~~
: 		       		       
: 
*******************************************************************************/
int semshm_obj::LockSemaphore( void )
{
   struct sembuf sem_lock={ 0, -1, 0 };
   
//   if( GetValSemaphore( num ) == _LOCK_ ) return( TRUE );
   
   sem_lock.sem_num = 0;
   
   if( (semop( semId, &sem_lock, 1 )) == -1 ) {
      return( FALSE );
   }
   return( TRUE );   
}
