#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include "ifftn.h"




/***************************************************************************
                 
                       ifmailo`m
 "2:5030/238.3" -> FTN_NODE		      
***************************************************************************/
void AddressStr2Dig( char *str, address_type *addr )
{
   char             tmpStr[ MAX_LENGTH_STRING ];
   char             *tmpPtr = tmpStr;
   
   strcpy( tmpStr, str );
   memset( addr, 0, sizeof( addr ) );
   
   addr->zone = DEFAULT_ZONE;
   addr->net  = DEFAULT_NET;
   
   if( (tmpPtr = strchr( tmpStr, '.' )) != NULL ) {
      addr->point = (int)atol( tmpPtr+1 );
      *tmpPtr = '\0';    
   } 
   else addr->point = 0;

  if( (tmpPtr = strchr( tmpStr, '/' )) != NULL ) {
     addr->node = (int)atol( tmpPtr+1 );
     *tmpPtr = '\0';
  }
  else {
    addr->node = (int)atol( tmpStr );
    goto END;
  }
  
  if( (tmpPtr = strchr( tmpStr, ':' )) != NULL ) {
    addr->net = (int)atol( tmpPtr+1 );
    *tmpPtr = '\0';
  }
  else {
    addr->net = (int)atol( tmpStr );
    goto END;
  }
  
  addr->zone = (int)atol( tmpStr );  
 END: 
 
  return;
}

/***************************************************************************
                        
		   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
***************************************************************************/
void AddressDig2Str( address_type *addr, char *str  )
{
  char tmpStr[ MAX_LENGTH_STRING ];

  strcpy( str, _outbound );
  if( addr->zone != DEFAULT_ZONE )   {
    sprintf( tmpStr, ".%03x", addr->zone );
    strcat( str, tmpStr );

    /*      */
    if( access( str, F_OK ) != 0 ) {
      sprintf( tmpStr, "mkdir %s", str );
      system( tmpStr );
    }
  }  
  sprintf( tmpStr, "/%04x%04x", addr->net, addr->node );
  strcat( str, tmpStr );
  
  if( addr->point != 0 ) {
      sprintf( tmpStr, ".pnt/%08x", addr->point );
      strcat( str, tmpStr );
  }
}


/***************************************************************************
                   . 
		   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
***************************************************************************/
void AddressPath2Dig( char *str, address_type *addr )
{
    char  *tmpPtr;
    char  tmpAddr[ MAX_LENGTH_STRING ];
    
    /*     outbound`a */
    tmpPtr = str + strlen( _outbound );

    /*    `.`      */
    if( *tmpPtr == '.' ) {    
       tmpPtr++;
       /*     */
       strncpy( tmpAddr, tmpPtr, strchr( tmpPtr, '/' ) - tmpPtr );
       tmpAddr[ strchr( tmpPtr, '/' ) - tmpPtr ] = '\0';
       addr->zone = strtol( tmpAddr, NULL, 16 );
    }
    else {
       addr->zone = DEFAULT_ZONE;
    }
    /*    `/` */
    while( *tmpPtr != '/' ) tmpPtr ++;
    tmpPtr++;
    
    /*   */
    strncpy( tmpAddr, tmpPtr, 4 );
    tmpAddr[4] = '\0';
    addr->net = strtol( tmpAddr, NULL, 16 );
    
    /*   */
    tmpPtr += 4;
    strncpy( tmpAddr, tmpPtr, 4 );
    tmpAddr[4] = '\0';
    addr->node = strtol( tmpAddr, NULL, 16 );
    
    /*   */
    tmpPtr = strstr( tmpPtr, ".pnt" );
    if( tmpPtr == NULL )  {    
       addr->point = 0;
    }
    else {
      tmpPtr += 5;
      *(tmpPtr + 8 ) = '\0';
      addr->point = strtol( tmpPtr, NULL, 16 );
    }       
}




