#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include "ifpollD.h"



/*******************************************************************************
                            
                        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
void ftn_queue::ShowQueue( void )
{
   char   tmpStr[ MAX_LENGTH_STRING ];
   char   tmpStr2[ MAX_LENGTH_STRING ];
   int    index;

   /*    */
   ClientSendInquiry( SEND_SHOW_QUEUE );
   printf( "\nQueue" );
   if( TestOutCall() == FALSE ) printf( " (no call)" );
   printf( ":\n" );
   printf( "---------------------------------------------\n" );   
   printf( "      Node        Mail   File   Hold   Flag  \n" );  
   printf( "---------------------------------------------\n" );   
   
   do{
      while( ClientReceiveReport( MSG_ANSWER_INFO_QUEUE ) == FALSE ) {;}
      
      /*   ,   */
      if( message.retData == REPLY_NO_QUEUE ) {
	 printf( "\n\n   Mail queue is empty.\n" );
	 break;
      }      
      
      /*      */
      if( message.flagCurrentNode == TRUE ) printf( ">" );
      else                                  printf( " " );
      
      /*  */
      sprintf( tmpStr, " %d:%d/%d.%d", message.address.zone, message.address.net,
                                       message.address.node, message.address.point );      
      for( index = strlen( tmpStr ); index < 14; index ++ ) strcat( tmpStr, " " );
      
      /*    */
      sprintf( tmpStr2, "%6d %6d %6d  ", message.sizeOutMail, 
                                         message.sizeOutFile,
				         message.sizeOutHold  );
      strcat( tmpStr, tmpStr2 );				       
      
      strcat( tmpStr,  "   " );      
      strcpy( tmpStr2, "..." );      
      if( (message.status & STATUS_IMMEDIATE)  == STATUS_IMMEDIATE )  tmpStr2[0] = 'I';      
      if( (message.status & STATUS_CRASH)      == STATUS_CRASH )      tmpStr2[1] = 'C';
      if( (message.status & STATUS_HOLD)       == STATUS_HOLD )       tmpStr2[2] = 'H';
      if( (message.status & STATUS_UNDIALABLE) == STATUS_UNDIALABLE ) strcpy( tmpStr2, "-U-" );
      
      strcat( tmpStr, tmpStr2 );
      
      printf( "%s\n", tmpStr );      
      
   } while( message.retData == REPLY_YES_NEXT );
   
   semshm->LockSemaphore();
   semshm->ReadShm( &infoEmsi );
   semshm->UnlockSemaphore();
   switch( infoEmsi.status ) {
     case SYSTEM_WAIT: printf( "Wait for call or event...\n" ); break;
     case SYSTEM_WAIT_CONNECT: printf( "Waiting for connect ...\n" ); break;
     case SYSTEM_CONNECT: printf( "%s\n", infoEmsi.connect ); break;
   }
   

   printf( "\n" );
}

/*******************************************************************************
                          
                    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
void ftn_queue::ShowInfoNode( char *str )
{
   
   AddressStr2Dig( str, &message.address );
   
   /*    */
   ClientSendInquiry( SEND_SHOW_INFO_NODE );
  
   while( ClientReceiveReport( MSG_ANSWER_NODE_INFO ) == FALSE ) {;}
   printf( "\nInfo node:\n" );
   
   if( message.retData == REPLY_FOUND_NO ) {
      printf( "No node %d:%d/%d.%d in queue\n", message.address.zone, message.address.net, 
 	                                         message.address.node, message.address.point );
      return;
   }
   printf( "Address     - %d:%d/%d.%d\n", message.address.zone, message.address.net, 
                                          message.address.node, message.address.point );

   printf( "Name system - %s\n", message.name );
   printf( "Location    - %s\n", message.location );
   printf( "Sysop       - %s\n", message.sysop );
   printf( "Phone       - %s\n", message.phone );
   printf( "Speed       - %s\n", message.speed );   
   
   printf( "Work Time   - " );
   if( (message.startTimeHour < 0) || (message.startTimeMin < 0) ||
       (message.endTimeHour   < 0) || (message.endTimeMin < 0) ) 
       printf( "Undefined\n" );
   else
       printf( "%d:%d-%d:%d\n", message.startTimeHour, message.startTimeMin,
                                message.endTimeHour, message.endTimeMin );  
   printf( "\n" );				       
}


/*******************************************************************************
                      
                    ~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
void ftn_queue::ShowDelay( void )
{
   /*    */
   ClientSendInquiry( SEND_SHOW_DELAY );      
   
   while( ClientReceiveReport( MSG_ANSWER_DELAY ) == FALSE ) {;}
   printf( "Info time interval: \n" );
   printf( "Delay now        - %d\n", message.delayNow );
   printf( "Delay call       - %d\n", message.delayCall );
   printf( "Delay zero queue - %d\n", message.delayZeroQueue );
   printf( "\n" );
}


/*******************************************************************************
                       
                    ~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
void ftn_queue::Poll( char *str )
{

  AddressStr2Dig( str, &message.address );
  CreateFlag( FLAG_POLL, &message.address, NULL );
  printf( "Create poll to node %d:%d/%d.%d\n", message.address.zone, message.address.net, 
 	                                       message.address.node, message.address.point );  
  ClientSendInquiry( SEND_REREAD_QUEUE );   			     				       					       					       
}


/*******************************************************************************
                    .  
                    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
void ftn_queue::SetOutCall( char *str )
{
  if( strcmp( str, "on" ) == 0 ) {
    printf( "Remove Nocall flag %s\n", _fileNocall );
    DeleteNocallFile();
    ClientSendInquiry( SEND_REREAD_QUEUE );   			     				       					       					       
    return;
  }
  if( strcmp( str, "off" ) == 0 ) {
    printf( "Create Nocall flag %s\n", _fileNocall );
    CreateNocallFile();
    return;
  }
}


/*******************************************************************************
                      
                    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
void ftn_queue::SetDelay( char *str )
{
  message.delayZeroQueue = NO_SET_DELAY;
  message.delayCall      = NO_SET_DELAY;
  message.delayNow       = NO_SET_DELAY;
  
  if( *str == 'c' ) {
    printf( "Set delay call time " );
    message.delayCall = atol( str+1 );
    printf( "%d second\n", message.delayCall ); 
    ClientSendInquiry( SEND_SETDELAY ); 
    ClientSendInquiry( SEND_REREAD_QUEUE );   			     				       					       					       
    return;
  }
  if( *str == 'q' ) {
    printf( "Set delay zero queue time " );
    message.delayZeroQueue = atol( str+1 );
    printf( "%d second\n", message.delayZeroQueue ); 
    ClientSendInquiry( SEND_SETDELAY ); 
    ClientSendInquiry( SEND_REREAD_QUEUE );
    return;
  }    
}

/*******************************************************************************
                           
                    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
void ftn_queue::SetStatus( char *str )
{
   int   index;
   int   flagFound = FALSE;
   int   st;
 
   AddressStr2Dig( str+1, &message.address );  
   
   switch( *str ) {
     case 'c': message.status = STATUS_CRASH;     
               printf( "Set/Reset flag CRASH for node " );
	  break;
     case 'i': message.status = STATUS_IMMEDIATE; 
               printf( "Set/Reset flag IMMEDIATE for node " );
	  break;
     case 'h': message.status = STATUS_HOLD;      
               printf( "Set/Reset flag HOLD for node " );
	  break;
     case 'n': message.status = STATUS_NORMAL;      	 
               printf( "Reset all flags for node " ); 
          break;	       
   }
   printf( " %d:%d/%d.%d\n", message.address.zone, message.address.net, 
 	                     message.address.node, message.address.point );      
   ClientSendInquiry( SEND_SETSTATUS );   			     
   ClientSendInquiry( SEND_REREAD_QUEUE );     
}

/*******************************************************************************
                            
                    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
void ftn_queue::DeleteNode( char *str )
{
  AddressStr2Dig( str, &message.address );
  printf( "Delete node %d:%d/%d.%d\n", message.address.zone, message.address.net, 
 	                               message.address.node, message.address.point );      
  ClientSendInquiry( SEND_DELETE_NODE );   			     				       
  ClientSendInquiry( SEND_REREAD_QUEUE );   			     				       
}
