#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include "ifpollD.h"
#include "_msignal.h"



/*******************************************************************************
                            
                        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
void ftn_queue::ReportQueue( void )
{ 
   int  index;  
   int  cn;
   
//   LOG( 3, "Report Queue....\n" );  
   
   /*     (+1  ) */
   if( pidIfcico != -1 ) cn = currentNode;
   else {
     cn = currentNode + 1;
     if( cn >= countNode ) cn = 0;
   }     

   if( countNode == 0 ) 
   {
      message.retData = REPLY_NO_QUEUE;
      ServerSendReport( MSG_ANSWER_INFO_QUEUE );
   }
   else 
   {
      /*        */
      for( index = 0; index < countNode; index ++ ) 
      {	 
	 message.address = node[ index ]->address;
	 message.status  = node[ index ]->status;
	 
	 if( index == cn ) message.flagCurrentNode = TRUE;
	 else message.flagCurrentNode = FALSE;
	 
	 if( index == (countNode-1) ) message.retData = REPLY_NO_NEXT;
	 else message.retData = REPLY_YES_NEXT;	 
	 
	 message.flagCallNow = node[ index ]->flagCallNow;
	 message.sizeOutFile = node[ index ]->sizeOutFile;
         message.sizeOutMail = node[ index ]->sizeOutMail;
	 message.sizeOutHold = node[ index ]->sizeOutHold;
	 
	 ServerSendReport( MSG_ANSWER_INFO_QUEUE );
	         
      }   /* end for( index = 0; index < countNode; index ++ ) */
   }
//   LOG( 3, "Report Queue done....\n" );  
}


/*******************************************************************************
                        
                ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
void ftn_queue::ReportInfoNodeIndex( void )
{
   LOG( 3, "ReportInfoNodeIndex...\n" );  
      
   message.retData = REPLY_FOUND_YES;
      
   message.address       = node[ message.nodeIndex ]->address;
   message.status        = node[ message.nodeIndex ]->status;
   message.startTimeMin  = node[ message.nodeIndex ]->startTimeMin;
   message.startTimeHour = node[ message.nodeIndex ]->startTimeHour;
   message.endTimeMin    = node[ message.nodeIndex ]->endTimeMin;
   message.endTimeHour   = node[ message.nodeIndex ]->endTimeHour;
   strcpy( message.name,     node[ message.nodeIndex ]->name );
   strcpy( message.location, node[ message.nodeIndex ]->location );
   strcpy( message.sysop,    node[ message.nodeIndex ]->sysop );
   strcpy( message.phone,    node[ message.nodeIndex ]->phone );
   strcpy( message.speed,    node[ message.nodeIndex ]->speed );	  
   message.sizeOutFile   = node[ message.nodeIndex ]->sizeOutFile;
   message.sizeOutMail   = node[ message.nodeIndex ]->sizeOutMail;
   
   ServerSendReport( MSG_ANSWER_NODE_INFO );
   
   LOG( 3, "ReportInfoNodeIndex done...\n" );  
}


/*******************************************************************************
                        
		~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
void ftn_queue::ReportInfoNode( void )
{
   int   index;
   int   flagFound = FALSE;
   
   LOG( 3, "ReportInfoNode...\n" );  
    
   for( index = 0; index < countNode; index++ )
   {
     if( (message.address.zone  == node[ index ]->address.zone) &&
         (message.address.net   == node[ index ]->address.net ) &&
	 (message.address.node  == node[ index ]->address.node) &&
	 (message.address.point == node[ index ]->address.point) ) 
     {
        message.nodeIndex = index;
	ReportInfoNodeIndex();
	flagFound = TRUE;
	break;	 
     }         
   }
   
   if( flagFound == FALSE ) {
      message.retData = REPLY_FOUND_NO;
      ServerSendReport( MSG_ANSWER_NODE_INFO );   
   }              
   
   LOG( 3, "ReportInfoNode done...\n" );  
}


/*****************************************************************************
                        
******************************************************************************/
void ftn_queue::ReportDelay( void )
{
//   LOG( 3, "ReportDelay...\n" );  
   message.delayZeroQueue = _delayZeroQueue;
   message.delayCall      = _delayCall;
   message.delayNow       = delayNow;
   message.flagDelayCall  = flagDelayCall;
   ServerSendReport( MSG_ANSWER_DELAY );      
//   LOG( 3, "ReportDelay done...\n" );  
}

/*****************************************************************************
                       ifcico
******************************************************************************/
void ftn_queue::ReportHangUp( void )
{
//  char tmpStr[ MAX_LENGTH_STRING ];
  
  /*    ifcic`y */
  LOG( 3, "ReportHangup...\n" );  

  if( pidIfcico != -1 ) {
     LOG( 1, "ifcico Hangup ...\n" );      
//     kill( pidIfcico, SIGHUP);
     kill( pidIfcico+1, SIGHUP );

//     kill( pidIfcico+1, SIGTERM );
//     kill( pidIfcico, SIGTERM );           
     bzero( &infoEmsi, sizeof( emsi_and_info_type ) );
     infoEmsi.status = SYSTEM_WAIT;     
//     node[ currentNode ]->SRStatus( RESET_STATUS, STATUS_NORMAL    );
     RestoreFloClo();     
  }
  LOG( 3, "ReportHangup done...\n" );  

}

/*****************************************************************************
                           
******************************************************************************/
void ftn_queue::ReportSetDelay( void )
{
  LOG( 3, "ReportSetDelay...\n" );  
  LOG( 1, "Set delay:\n" );
  if( message.delayCall != NO_SET_DELAY ) {
     _delayCall = message.delayCall;
     LOG( 1, "    Delay call %d\n", _delayCall );
  }     
  if( message.delayZeroQueue != NO_SET_DELAY ) {
     _delayZeroQueue = message.delayZeroQueue;
     LOG( 1, "    Delay zero call %d\n", _delayZeroQueue );
  }     
  if( message.delayNow != NO_SET_DELAY ) {
     delayNow = message.delayNow;
     LOG( 1, "    Reset delay now...\n" );
  }       
  LOG( 3, "ReportSetDelay done...\n" );  
}


/*****************************************************************************
                      _message.nodeIndex 
******************************************************************************/
void ftn_queue::ReportDeleteNodeIndex( void )
{
  LOG( 3, "ReportDeleteNodeIndex...\n" );  
  node[ message.nodeIndex ]->RemoveAllFlags();
  ClientSendInquiry( SEND_REREAD_QUEUE );  
  LOG( 3, "ReportDeleteNodeIndex done...\n" );  
}

/*****************************************************************************
                            
******************************************************************************/
void ftn_queue::ReportDeleteNode( void )
{
  int   index;

  LOG( 3, "ReportDeleteNode...\n" );  
  for( index = 0; index < countNode; index++ )
  {
     if( (message.address.zone  == node[ index ]->address.zone) &&
         (message.address.net   == node[ index ]->address.net ) &&
	 (message.address.node  == node[ index ]->address.node) &&
	 (message.address.point == node[ index ]->address.point) ) 
     {
        message.nodeIndex = index;
	ReportDeleteNodeIndex();
	break;	 
     }         
   } 
   LOG( 3, "ReportDeleteNode done...\n" );  
}


/*****************************************************************************
                       
******************************************************************************/
void ftn_queue::ReportSetStatusIndex( void )
{
  LOG( 3, "ReportSetStatusIndex...\n" );  
  if( message.status == STATUS_NORMAL ) {
     node[ message.nodeIndex ]->status = STATUS_NORMAL;
     node[ message.nodeIndex ]->SRStatus( RESET_STATUS, STATUS_CRASH );
     node[ message.nodeIndex ]->SRStatus( RESET_STATUS, STATUS_HOLD );
     node[ message.nodeIndex ]->SRStatus( RESET_STATUS, STATUS_IMMEDIATE );     
  }     
  else  {
     node[ message.nodeIndex ]->status ^= message.status;      
     if( (node[ message.nodeIndex ]->status & message.status) == message.status )
        node[ message.nodeIndex ]->SRStatus( SET_STATUS, message.status );
     else      
        node[ message.nodeIndex ]->SRStatus( RESET_STATUS, message.status );
  }	
  ClientSendInquiry( SEND_REREAD_QUEUE );  
  LOG( 3, "ReportSetStatusIndex done...\n" );  
}

/*****************************************************************************
                      
******************************************************************************/
void ftn_queue::ReportSetStatus( void )
{
   int   index;
   int   flagFound = FALSE;
   
   LOG( 3, "ReportSetStatus...\n" );  
   for( index = 0; index < countNode; index++ )
   {
     if( (message.address.zone  == node[ index ]->address.zone) &&
         (message.address.net   == node[ index ]->address.net ) &&
	 (message.address.node  == node[ index ]->address.node) &&
	 (message.address.point == node[ index ]->address.point) ) 
     {
        message.nodeIndex = index;
	ReportSetStatusIndex();
	flagFound = TRUE;
	break;	 
     }         
   }
   
   if( flagFound == FALSE ) {
      message.retData = REPLY_FOUND_NO;
   }              
   LOG( 3, "ReportSetStatus done...\n" );  
}


/*****************************************************************************
                            
******************************************************************************/
void ftn_queue::ReportRereadLog( void )
{
   LOG( 3, "ReportRereadLog...\n" );  
   ReportHangUp();
   CloseLogIfcico();
   OpenLogIfcico();
   LOG( 3, "ReportRereadLog done...\n" );  
}
