#include <unistd.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <signal.h>
#include "ifpollD.h"


/*******************************************************************************
                          
                        ~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
int ftn_queue::CreateQueueMessages( void )
{
/*   if( (key=ftok("./ifpollD",'A')) < 0 ) {
     LOG( 0, "Server Error key!\n" );
     kill( getpid(), SIGTERM );
   }
*/
   key = KEY_QUEUE;      
   if( (msgid = msgget(key, PERM | IPC_CREAT ) ) < 0 ) {
     LOG( 0, "Server Error queue!\n" );
     kill( getpid(), SIGTERM );
   }
   return( TRUE );
}


/*******************************************************************************
                          
                        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
void ftn_queue::DestroyQueueMessages( void )
{
   if( msgctl( msgid, IPC_RMID, 0 ) < 0 ) {
     LOG( 0, "Server Error destroe queue!\n" );
     kill( getpid(), SIGTERM );
   }
}


/*******************************************************************************
                          
                        ~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
int ftn_queue::ServerTestInputMessage( void )
{
   int  n;
   
//   LOG( 3, ".....Test input Message\n" );
   
   message.mtype = MSG_SERVER_INQUIRY;   
   n = msgrcv( msgid, (struct msgbuf * )&message, MSG_SIZE, message.mtype, IPC_NOWAIT );
   if( n > 0 )
   {
     //LOG( 3, "++++Yes Message - %d\n", message.codCommand );
     return TRUE;     
   }   
   return FALSE;
}

/*******************************************************************************
                           
                        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
void ftn_queue::ServerDispetcher( void )
{
     /*        */

     switch( message.codCommand )
     {
       case SEND_SHOW_QUEUE:            ReportQueue();          break;
       case SEND_SHOW_INFO_NODE_INDEX:  ReportInfoNodeIndex();  break;
       case SEND_SHOW_INFO_NODE:        ReportInfoNode();       break;       
       case SEND_SHOW_DELAY:            ReportDelay();          break;
       case SEND_HANGUP:                ReportHangUp();         break;
       case SEND_SETDELAY:              ReportSetDelay();       break;
       case SEND_REREAD_QUEUE:          flagReRead = TRUE; delayNow = 1; break;
       case SEND_REREAD_LOG:            ReportRereadLog();      break;
       case SEND_DELETE_NODE_INDEX:     ReportDeleteNodeIndex();break;
       case SEND_DELETE_NODE:           ReportDeleteNode();     break;
       case SEND_SETSTATUS_INDEX:       ReportSetStatusIndex(); break;
       case SEND_SETSTATUS:             ReportSetStatus();      break;
     }     

}


/*******************************************************************************
                            
			~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
void ftn_queue::ServerSendReport( long type )
{
   message.mtype = type;      
   if( msgsnd( msgid, (struct msgbuf *)&message, MSG_SIZE, 0 ) == -1 ) {
      LOG( 0, "Error send report!\n" );
      kill( getpid(), SIGTERM );
   }        
}
