#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <signal.h>
#include <glob.h>
#include "ifpollD.h"
#include "_msignal.h"



/*******************************************************************************
                          
*******************************************************************************/
void ftn_queue::ScanScript( void )
{
   char           tmpStr[ MAX_LENGTH_STRING ];
   char           maska [ MAX_LENGTH_STRING ]; 
   char           flagAnyLast = FALSE;
   FILE           *fp;

   LOG( 2, "Start scan script....\n" );  
 
   fp = fopen( _script, "r" );
   if( fp == NULL ) {
      LOG( 0, "Warning! Unable open script file %s. Continue...\n", _script );
      goto Endd;
      return;
   }

//   signal( SIGALRM, SIG_IGN );
 
  /*      ALWAYS_FIRST */
   while( fgets( tmpStr, MAX_LENGTH_STRING - 1, fp ) != NULL )
   {
      if( (*tmpStr == '#') || (*tmpStr == ';' ) ) continue;	 
      if( *tmpStr == '\n' ) continue;
      if( strstr( tmpStr, "ALWAYS_FIRST" ) != 0 ) {
	    GetAndStartScript( tmpStr );
	    break;
      }
   }     

   rewind( fp );
   while( fgets( tmpStr, MAX_LENGTH_STRING - 1, fp ) != NULL )
   {
      /*  ,  */
      if( (*tmpStr == '#') || (*tmpStr == ';' ) ) continue;
	 
      /*   ,  */
      if( *tmpStr == '\n' ) continue;

      /*   */
      sscanf( tmpStr, "%s", maska );
      
      /*       */      
      if( TestMaska( maska ) == TRUE )
      {
	 flagAnyLast = TRUE;
	 GetAndStartScript( tmpStr );
      }     

   } /* end while( fgets( tmpStr, MAX_LENGTH_STRING - 1, fp ) != NULL ) */
   
   /*   flagAnyLast     ANY_LAST */
   if( flagAnyLast == TRUE )
   {
      rewind( fp );
      while( fgets( tmpStr, MAX_LENGTH_STRING - 1, fp ) != NULL )
      {
	 if( (*tmpStr == '#') || (*tmpStr == ';' ) ) continue;	 
         if( *tmpStr == '\n' ) continue;
	 if( strstr( tmpStr, "ANY_LAST" ) != 0 ) {
	    GetAndStartScript( tmpStr );
	    break;
	 }
      }      
   }/*  end if( flagAnyLast == TRUE )  */

   /*      ALWAYS_LAST */
   rewind( fp );
   while( fgets( tmpStr, MAX_LENGTH_STRING - 1, fp ) != NULL )
   {
      if( (*tmpStr == '#') || (*tmpStr == ';' ) ) continue;	 
      if( *tmpStr == '\n' ) continue;
      if( strstr( tmpStr, "ALWAYS_LAST" ) != 0 ) {
	    GetAndStartScript( tmpStr );
	    break;
      }
   }   
  
   fclose( fp );       
  //SetSignal( SIGALRM, SigAlrm );    
Endd:  
  kill( getpid(), SIGKILL );
  exit( -1 );
  LOG( 2, "End scan script....\n" );  
}



/***********************************************************************************
                      
: TRUE  - 
       FALSE - 	      
***********************************************************************************/
int ftn_queue::TestMaska( char *maska )
{
   glob_t         foundFiles;
   char           tmpStr[ MAX_LENGTH_STRING ];  
   int            rcode;  
   
   sprintf( tmpStr, "%s/%s", _inbound, maska );
   rcode = glob( tmpStr, 0, 0, &foundFiles );  
   
   switch( rcode ) 
   {
     case GLOB_NOSPACE: LOG( 0, "Run out of memory for glob in function TestMaska. Die...\n" );
                        kill( getpid(), SIGTERM );
			break;
     case GLOB_ABEND:   LOG( 0, "Glob read error in function TestMaska. Die...\n" );
                        kill( getpid(), SIGTERM );
			break;						
     case GLOB_NOMATCH: return FALSE;
   }  
   return TRUE;   
}



/***********************************************************************************
                            
***********************************************************************************/
void ftn_queue::GetAndStartScript( char *str )
{
   int  index;
   char scriptName[ MAX_LENGTH_STRING ];   
   FILE *fp;

   
   LOG( 2, "String with script : %s", str );
   /*     */
   while( (*str != '\n') ) {
      while( *str != '"' ) {
         if( *str == '\n' ) return;
      	 str ++;
      }
      str++;
      strcpy( scriptName, str );
   
      /*    */
      for( index = 0; index < strlen( scriptName ); index ++ )
         if( scriptName[ index ] == '"' ) {
      	    scriptName[ index ] = '\0';
	    break;
         }
      
      LOG( 2, "    Start script %s\n", scriptName );
      
      /*        ifmail`a */
/*      if( (fp = fopen( _fileLogIfcico, "a+" )) != NULL )
      {
        fprintf( fp, "ifpollD[%d]: Start script %s\n", getpid(), scriptName );      
        fclose( fp );
      }
*/      
      system( scriptName );
      
      /*    */
      while( *str != '"' ) str ++;
      str++;   
    }   
}

