#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/wait.h>
#include "ifpollD.h"
#include "_msignal.h"




/************************************************************************************
                            
			  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
************************************************************************************/
void ftn_queue::Rescan( void )
{
  char           tmpStr[ MAX_LENGTH_STRING ];  
  address_type   addr;  
  int            index;
  FILE           *fp;
  int            flagYesNode;
  ftn_node       tmpNode;
  
  
  flagReRead = FALSE;
  
  signal( SIGALRM, SIG_IGN );

 RESTART:

  LOG( 1, "---------------------------------------------------------\n" );
  LOG( 1, "Rescan queue...\n" );
  
  countNode = 0;
  RemoveAllNodeFromList();

  
  /*       */
  
  sprintf( tmpStr, "find %s* -type f", _outbound );

  fp = popen( tmpStr, "r" );
  if( fp == NULL ) {
    LOG( 0, "Null in popen\n" );
    kill( getpid(), SIGTERM );
  }
  
  /*    */
  while( fgets( tmpStr, MAX_LENGTH_STRING - 1, fp ) != NULL )
  { 

    flagYesNode = FALSE;    
    if( strstr( tmpStr, ".flo" ) != NULL ) flagYesNode = TRUE;
    if( strstr( tmpStr, ".hlo" ) != NULL ) flagYesNode = TRUE;
    if( strstr( tmpStr, ".clo" ) != NULL ) flagYesNode = TRUE;
    if( strstr( tmpStr, ".out" ) != NULL ) flagYesNode = TRUE;
    if( strstr( tmpStr, ".req" ) != NULL ) flagYesNode = TRUE;        
    
    /*  flagYesNode == TRUE -   */
    if( flagYesNode == FALSE ) continue;   
    /*   */
    AddressPath2Dig( tmpStr, &addr );     
    /*          */
    if( TestDoubleNode( &addr ) == TRUE ) continue;	



    LOG( 1, "   Found address - %d:%d/%d.%d\n", addr.zone,
                                                addr.net,
                                 		addr.node,
                             		        addr.point );      
    					 

    /*         */
    AddNodeInList();   
    node[ countNode - 1 ]->address = addr;
    
    /*       */
    node[ countNode - 1 ]->ReadNodelist();
    node[ countNode - 1 ]->ReadSubst();
    node[ countNode - 1 ]->TestCallNow();     
     
    /*     */
    node[ countNode - 1 ]->ReadStatus();
     
    /*       */    
    node[ countNode - 1 ]->GetOutSize();    
  }  
  pclose( fp );

  
  
  LOG( 1, "   Found %d flags\n", countNode );
  LOG( 1, "Done.\n" );  
  

  SetSignal( SIGALRM, SigAlrm );    

}



/************************************************************************************
                              
			  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
TRUE  -   
FALSE -  			  
************************************************************************************/
int ftn_queue::TestDoubleNode( address_type *addr )
{
   int   index;
   
   for( index = 0; index < countNode; index++ )
   { 
      if( (node[ index ]->address.zone  == addr->zone) &&
          (node[ index ]->address.net   == addr->net)  &&
	  (node[ index ]->address.node  == addr->node) &&
	  (node[ index ]->address.point == addr->point) )  return TRUE;
   }
   return FALSE;
}
