#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include "ifpollD.h"




/************************************************************************************
                             
			 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
************************************************************************************/
void ftn_queue::AddNodeInList( void )
{
   ftn_node  **temp;
   ftn_node  *newnode; 
   
   temp = new ftn_node* [ countNode + 1 ];
   if( temp == NULL ) {
      LOG( 0, "Error! Unable new memory for AddNodeInList. Die...\n" );
      kill( getpid(), SIGTERM );
   }
   
   memcpy( temp, node, countNode * sizeof( ftn_node* ) );
      
   delete node;
   node = temp;

   countNode++;
   
   newnode = new ftn_node();
   
   node[ countNode - 1 ] = newnode;
}



/************************************************************************************
                              
			   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
************************************************************************************/
void ftn_queue::RemoveAllNodeFromList( void )
{
   int index;   
   for( index = 0; index < countNode; index ++ )
      delete node[ index ];
   
   delete node;        
   node      = ( ftn_node ** )NULL;   
   
   countNode = 0;
}
