#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <signal.h>
#include "ifpollD.h"
#include <sys/wait.h>


/*******************************************************************************
                   ifmail`o
		~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
int ftn_queue::AnalysReturnCode( ftn_node *currNode, int code )
{
   char   str[ MAX_LENGTH_STRING ];
   int    flagRescanQueue = FALSE;   
   
   LOG( 2, "Ifcico return code %d\n", code );
   switch( code )
   {
      case CALL_SUCCESFULL:  LOG( 1, "Call succesfull.\n" );
                             currNode->RemoveAllFlags();
  		             /*        */
			     pid_t pid;
			     pid_t tmppid;
			     int   returnCode;

			     pid = fork();
			     if( pid == 0 ) {
			        ScanScript();
                             }  				
			     else {
			      QQQ:
			        tmppid = waitpid( pid, &returnCode, WNOHANG );
				if( tmppid == 0 ) goto QQQ;
			     }
			     kill( pid, SIGKILL );
			     
			     Sleep( _delayCall );
			     flagRescanQueue = TRUE;
			     flagBeAnyCall = TRUE;
                   break;
      case CALL_PRESENT_NOCALL_FILE:  LOG( 1, "Present nocall file\n" );
                                      Sleep( _delayZeroQueue );
				      flagBeAnyCall = TRUE;
                   break;		   
      case CALL_ERROR:       LOG( 1, "No succesfull :-(\n" );
                             flagBeAnyCall = TRUE;
			     RestoreFloClo();     
                             Sleep( _delayCall );
                   break;                        
      case CALL_NO_NOW:
                             LOG( 1, "No call in now\n" );
	           break;                        
      case CALL_NO_PHONE:
                             LOG( 1, "No phone define\n" );
                   break;			     		         
   }  /*   end  switch( code )  */
   
   return( flagRescanQueue );
}



void ftn_queue::RestoreFloClo( void )
{
     char tmpStr[ MAX_LENGTH_STRING ];
     /*   flo */
     AddressDig2Str( &node[ currentNode ]->address, tmpStr );
     if( statusCurrNode == STATUS_CRASH ) strcat( tmpStr, ".clo" );
     if( statusCurrNode == STATUS_NORMAL ) strcat( tmpStr, ".flo" );	 
     /*  flo    */
     if( access( tmpStr, F_OK ) != 0 ) {

	if( statusCurrNode == STATUS_NORMAL ) CreateFlag( FLAG_POLL, &node[ currentNode ]->address, NULL );
     }     

}
