#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "ifpollD.h"
#include "_msignal.h"
#include "_option.h"

/************************** G L O B A L S **********************************/
char  *_ifcico        = IFCICO;        /*  */
char  *_inbound       = INBOUND;
int   _delayCall      = DELAYCALL;     /*    */
int   _delayZeroQueue = DELAYQUEUE;    /*     */
char  *_script        = SCRIPT;
ftn_queue             queue;  
/***************************************************************************
                                  M A I N 
***************************************************************************/
void Usage( void );
int main( int argc, char **argv )
{ 
   struct itimerval  mtimer;
   int               fd;
   struct rlimit     flim;
   
   
   if( (argc < 2) || (strcmp( argv[1], "--help" ) == 0) ) {
      Usage();
      exit( 1 );
   }      
      
   printf( "ifpollD startup...\n" );      

   _levelLog = 0;   
   
   /*    */
   if( TestOption( argc, argv ) == FALSE ) {
      printf( "No daemon. Exit...\n" );
      return 0;
   }
   
   /*     
    *    ,    
    */
   if( TestPidFile() == TRUE ) {
      printf( "Pid file present. Die...\n " );
      LOG( 0, "Pid file present. Die...\n " );       
      exit( -1 );
   }    
   
   if( queue.semshm->CreateSemaphore() == FALSE ) {
      printf( "Unable create semaphore. Die...\n" );
      LOG( 0, "Unable create semaphore. Die...\n" );
      kill( getpid(), SIGTERM );
   }
   queue.semshm->UnlockSemaphore();
   if( queue.semshm->CreateAndAttachShm() == FALSE ) {
      printf( "Unable create shared memory. Die...\n" );
      LOG( 0, "Unable create shared memory. Die...\n" );
      kill( getpid(), SIGTERM );
   }
   
   /*    */
   printf( "Start daemon...\n" );
   
   if( getppid() != 1 )
   {
     signal( SIGTTOU, SIG_IGN );
     signal( SIGTTIN, SIG_IGN );
     signal( SIGTSTP, SIG_IGN );     
     if( fork() != 0 ) exit( 0 );       
     setsid();
   }          
   getrlimit( RLIMIT_NOFILE, &flim );
   for( fd = 0; fd < flim.rlim_max; fd++ )  close( fd );     
   chdir( "/" );   
   LOG( 0, "\n" );
   LOG( 0, "\n" );
   LOG( 0, "\n" );      
   LOG( 0, "--------------- Startup ---------------\n" );
   LOG( 0, "Start daemon...\n" );
   
   /*    */
   CreatePidFile();
   
   /*    */   
   queue.CreateQueueMessages();
   /*     */
   while( queue.ServerTestInputMessage() == TRUE ) {
      LOG( 3, "Server receive old msg\n" );
   }
   
   queue.OpenLogIfcico();
   
   /*    */
   SetSignal( SIGALRM, SigAlrm );    
   SetSignal( SIGINT,  SigIntTerm );    
   SetSignal( SIGTERM, SigIntTerm );          
   
   /*   */
   mtimer.it_interval.tv_sec  = 0;
   mtimer.it_interval.tv_usec = 125000;
   mtimer.it_value.tv_sec     = 0;
   mtimer.it_value.tv_usec    = 125000;
   setitimer( ITIMER_REAL, &mtimer, (struct itimerval *)0 );    
   
   while( 1 ) {
     queue.Work(); 
   }
   
   /*    */
   DeletePidFile();  
}

/******************************************************************************
                                    Usage
******************************************************************************/
void Usage( void )
{
   printf( "ifpollD 0.6    Copyright 1998-99 Andrey G.Kobrin\n" );
   printf( "------------------------------------------------\n" );
   printf( "Usage (on start):                               \n" );
   printf( "    -bd        - start daemon                   \n" );
   printf( "    -Dq<n>     - set delay queue                \n" );
   printf( "    -Dc<n>     - set delay call                 \n" );
   printf( "    -L<n>      - log level( 0-3 )               \n" );
   printf( "Usage (on daemon startup):                      \n" );   
   printf( "    -rq        - rescan queue                   \n" );
   printf( "    -rl        - reread log ifcico              \n" );   
   printf( "    -h         - hand up                        \n" );
   printf( "    -sq        - shoq queue                     \n" );
   printf( "    -sn<node>  - show node info                 \n" );
   printf( "    -sd        - show delay                     \n" );
   printf( "    -P<node>   - poll to node                   \n" );
   printf( "    -Ssc<node> - set status crash for node      \n" );
   printf( "    -Ssh<node> - set status hold for node       \n" );
   printf( "    -Ssi<node> - set status immediate for node  \n" );
   printf( "    -Scon      - set on out call                \n" );
   printf( "    -Scoff     - set off out call               \n" );
   printf( "    -Sdq<n>    - set delay queue                \n" );
   printf( "    -Sdc<n>    - set delay call                 \n" );
   printf( "    -d<node>   - delete node poll               \n" );       
   printf( "\n" );
}
