#include <stdio.h>
#include <string.h>
#include <getopt.h>
#include <stdlib.h>
#include "ifpollD.h"


/*******************************************************************************
                          
: TRUE  -  
       FALSE -  			
*******************************************************************************/
int TestOption( int argc, char **argv )
{
   struct option long_options[] = {
	{ "be",	     	1,	0,      'b' },
        { "Delay",	1,	0,	'D' },
	{ "delete",	1,	0,	'd' },
        { "show",     	1,	0,	's' },
        { "Set",	1,	0,	'S' },
        { "Poll",	1,	0,	'P' },	
	{ "Log",	1,	0,	'L' },
	{ "hangup",	1,	0,	'h' },
	{ "rescan",	1,	0,	'r' },
	{ 0,		0,	0,	 0  }
   };
   int  c;
   int  option_index = 0;
   int  flagDaemon = FALSE;
   
   while ( 1 )
   { 
      c = getopt_long( argc, argv, "b:D:s:S:P:L:d:r:h",
	               long_options, &option_index );
      if( c == -1 ) {
         break; 
      }
      switch( c )
      {
      	 case 'b':  
	       if( *optarg == 'd' ) flagDaemon = TRUE;	     
	     break;
         case 'D':
	       if( *optarg == 'q' ) {
		  _delayZeroQueue = (int)atol( optarg+1 );
		  printf( "Delay zero queue - %d\n", _delayZeroQueue );
		  LOG( 0, "Delay zero queue - %d\n", _delayZeroQueue );
	       }
       	       if( *optarg == 'c' ) {
		  _delayCall = (int)atol( optarg+1 );
		  printf( "Delay call - %d\n", _delayCall );
		  LOG( 0, "Delay call - %d\n", _delayCall );
	       }		  
	     break;	   
	 case 's':
	       if( *optarg == 'q' ) queue.ShowQueue();
	       if( *optarg == 'n' ) queue.ShowInfoNode( optarg+1 );
	       if( *optarg == 'd' ) queue.ShowDelay();
             break;
         case 'P': queue.Poll( optarg );
	     break;
         case 'S':
	       if( *optarg == 's' ) queue.SetStatus ( optarg + 1 );
	       if( *optarg == 'c' ) queue.SetOutCall( optarg + 1 );
	       if( *optarg == 'd' ) queue.SetDelay  ( optarg + 1 );	       
	     break;  	     
         case 'L':
	       _levelLog = (*optarg - '0');
	       printf( "levelLog - %d\n", _levelLog );
	       LOG( 0, "levelLog - %d\n", _levelLog );
	     break;  	     
	 case 'h':
	      printf( "Hangup...\n" );
	      queue.ClientSendInquiry( SEND_HANGUP );   			     	
	     break;  	     
	 case 'r':
	      if( *optarg == 'q' ) {
  	         printf( "Rescan queue...\n" );
	         queue.ClientSendInquiry( SEND_REREAD_QUEUE );   			     	
              }		 
	      if( *optarg == 'l' ) {
  	         printf( "Reread log ifcico...\n" );
	         queue.ClientSendInquiry( SEND_REREAD_LOG );   			     	
              }		 
      	     break;  	     	     
         case 'd':
	      queue.DeleteNode( optarg );
	     break;  
      } /* end switch( c ) */
   } /* end while ( 1 ) */   
   
   if( flagDaemon == TRUE ) return( TRUE );
   else return( FALSE );
}



