#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/resource.h>
#include "ifpollD.h"


/*******************************************************************************
                              
			    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*******************************************************************************/
void ( *SetSignal( int signo, void (*hndlr)(int)) )(int)
{
  struct sigaction  act, oact;
  
  act.sa_handler = hndlr;
  sigemptyset( &act.sa_mask );
  act.sa_flags = 0;
//  if( signo != SIGALRM )
    act.sa_flags |= SA_RESTART;
    
  if( sigaction( signo, &act, &oact ) < 0 )
    return( SIG_ERR );
    
  return( oact.sa_handler );    
}


/************************************************************************************
                             SIGALRM
			   ~~~~~~~~~~~~~~~~~~~~~~~~~			   
************************************************************************************/
void SigAlrm( int signo )
{ 
  static int tick = 0;

  tick ++;
  if( tick == 8 ) {
    //perror( "Send one second message\n" );
    if( queue.infoEmsi.status == SYSTEM_CONNECT ) {
      queue.infoEmsi.timeOnLine++;
      queue.semshm->LockSemaphore();  
      queue.semshm->SaveShm( &queue.infoEmsi );  
      queue.semshm->UnlockSemaphore();    
    }
    
    if( queue.flagDoCall == FALSE )  {
      queue.ServerSendReport( MSG_ONE_SEC );
    }    
    tick = 0; 
  }
  
  /*     */
  if( queue.ServerTestInputMessage() == TRUE ) {
    queue.ServerDispetcher();
  }
  queue.ScanLogIfcico();
}


/************************************************************************************
                       SIGINT  SIGTERM
  		     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~			   
************************************************************************************/
void SigIntTerm( int signo )
{ 
   /*    */
   DeletePidFile();  

   /*    */
   queue.DestroyQueueMessages();
   
   LOG( 0, "Receive SIGTERM or SIGINT signal. Die...\n" );
   queue.semshm->DetachAndDeleteShm();
   queue.semshm->DeleteSemaphore();   
   queue.CloseLogIfcico();
   exit( -1 );
}
