#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ftnfreq.h"
#include "_searchaddress.h"
#include "_screen.h"
#include "_show.h"
#include "_analys.h"
#include "_selectarea.h"
#include "_generatefreq.h"
#include "_find.h"
#include "_listselect.h"
#include "_selectfilelist.h"




/************************** G L O B A L S **********************************/
char             *_areaTmp = "/tmp/areaList.tmp";
char           _fileList[ MAX_LENGTH_STRING ];
address_type   _address;
WINDOW         *_wndTop;
WINDOW         *_wndOut;
fileparam_type _filelistParm;
fileparam_type _arealistParm;

fileparam_type *_currParm;

select_type    *_selectHead = NULL;
select_type    *_selectTail = NULL;
long           _countSelect = 0;

char           *_descDir    = DESCDIR;
char           *_descMaska  = DESCMASKA;
char           *_areaMaskaCfg = AREAMASKA;

/*      */
char           *_unzip   = UNZIP;
char           *_unarj   = UNARJ;
char           *_unzoo   = UNZOO;
char           *_unrar   = UNRAR;
char           *_arcdir  = ARCDIR;
char           *_decoder = DECODER;


/***************************************************************************
                                  M A I N 
***************************************************************************/

void main( int argc, char **argv )
{
   int               flag = 0;
   int               done = 0;
   int               ch;

   if( argc != 2 ) return 1;
   
   if( SelectFileList( argv[1] ) == FALSE ) exit( -1 );
      
   InitScreen();
   
   /*  2  */
   bzero( &_filelistParm, sizeof( fileparam_type ) );
   bzero( &_arealistParm, sizeof( fileparam_type ) );
   strcpy( _filelistParm.fname, _fileList );
   strcpy( _arealistParm.fname, _areaTmp );
   _currParm = &_filelistParm;
   
   

   AnalysFilelist();
   SearchAddress( _filelistParm.fname );

   ungetch( 123 );
   while( !done )
   {      
      ShowFileList( _currParm->fname );
      ch = getch(); 
      switch( ch )
      {      
         case 0x1b:
	        ch = getch();
	        if( ch == 'x' ) done = 1;
		if( ch == 'a' ) {      /*      */
		  if( _currParm != &_arealistParm ) {
		      if( _arealistParm.count != 0 ) {
		         _currParm = &_arealistParm; 
			 GoCurrArea();
		         ClearWindow( _wndOut );
                      }			 
                  }
		  else _currParm = &_filelistParm;		  		      		                        		      
		}  
		if( ch == 'f' && _currParm == &_filelistParm ) FindForward();
	    break;
	    
         case KEY_DOWN:       /*   */
	        if( _currParm->curr >= _currParm->count-1 ) break;
		_currParm->curr++;	        
		if( ( _currParm->curr - _currParm->top ) > _wndOut->_maxy ) {
		   _currParm->top++;
		   ScrollUp( _wndOut );		  
		}
		break;	         
         case KEY_NPAGE:      /*   */
	        if( (_currParm->top + _wndOut->_maxy ) < _currParm->count ) {
		   _currParm->top += _wndOut->_maxy;
		   _currParm->curr = _currParm->top;
		   ClearWindow( _wndOut );
		}
            break;	    
         case KEY_UP:	      /*   */  			    	    
	        if( (_currParm->curr - 1) < 0 ) break;
		_currParm->curr--;		
		if( _currParm->curr < _currParm->top ) {
		   _currParm->top--;
		   ScrollDown( _wndOut );		  
		}
		break;
         case KEY_PPAGE:       /*   */
	        if( (_currParm->top - _wndOut->_maxy ) > 0 ) {		
		   _currParm->top -= _wndOut->_maxy;
		   if( _currParm->curr > (_currParm->top + _wndOut->_maxy) )
 		      _currParm->curr = _currParm->top + _wndOut->_maxy;
		}   	   		
		else {
		   _currParm->top = 0;
		   _currParm->curr= _wndOut->_maxy;
                }		   
                ClearWindow( _wndOut ); 		   		   
            break; 
   	 case KEY_HOME:   /*    */ 
	               if( _currParm == &_filelistParm ) {
	                  _filelistParm.top = 0;
			  _filelistParm.curr = 0;
			  ClearWindow( _wndOut );
			}
            break;
         case KEY_END:    /*    */
	                if( _currParm == &_filelistParm ) {
	                  _filelistParm.top = _filelistParm.count - _wndOut->_maxy;
			  _filelistParm.curr = _filelistParm.top ;
			  ClearWindow( _wndOut );
			} 
	    break; 
	 case KEY_IC:	  /* INS */    
	                if( _currParm == &_filelistParm ) {
	                   AddElementInListSelect();
			   AddDelIndexInListSelect( _currParm->curr );
			   ungetch( KEY_DOWN );
			}   
            break;			

	 case 10:         /*  Enter */
	        if( _currParm == &_arealistParm ) SelectArea();	 
		else GenerateFreq();
            break;
	    
         default: 
	        if( !flag ) {
	           DestroyScreen();
	           InitScreen();
		   char str[ MAX_LENGTH_STRING ];
		   sprintf( str, "Address: %d:%d/%d.%d", _address.zone,
		                                         _address.net,
							 _address.node,
							 _address.point );		   
                   mvwaddstr( _wndTop, 0, 1, str );
		   sprintf( str, "Found: %d areas", _arealistParm.count );		   
		   mvwaddstr( _wndTop, 0, 27, str );		   
                   wrefresh( _wndTop );    

	           flag = 1;
		}
	    break;	       
      }	   
   } /* end    while( !done )  */
   DestroyScreen();
   remove( _areaTmp );
   char str[ MAX_LENGTH_STRING ];
   sprintf( str, "rm -fr %s", _arcdir );
   system( str );
}
