#include <unistd.h>
#include "ftnfreq.h"
#include "_screen.h"



/*******************************************************************************
                               
*******************************************************************************/
void InitScreen( void )
{      
  initscr();  
  start_color();
  
  /*   */
  _wndTop = newwin( 0, 0, 0, 0 );  
  _wndOut = newwin( 23, 80, 1, 0 );
  werase( _wndTop ); wclear( _wndTop );  
  
  /*  */
  init_pair( 1, COLOR_WHITE, COLOR_BLUE );
  wattrset( _wndTop, COLOR_PAIR(1) );
//  wattrset( _wndTop, A_REVERSE );      
  for(int index=0; index < _wndTop->_maxx; index++ ) {
    mvwaddch( _wndTop, 0, index, ' ' );
    mvwaddch( _wndTop, _wndTop->_maxy, index, ' ' );
  }    
  
  mvwaddstr( _wndTop, 0, 65, "| ftnfreq 0.1 " );
  mvwaddstr( _wndTop, 24, 1, "Alt+A - Show/hide arealist      Alt+F - find      Enter - freq     Alx+X - exit " );
  
  
  /*     etc */
  noecho();
  nodelay( stdscr, FALSE );
  cbreak();
  curs_set( FALSE );
  keypad( stdscr, TRUE );  
  
  /*   */
  wrefresh( _wndTop );
  wrefresh( _wndOut );
}



/*******************************************************************************
                                
*******************************************************************************/
void DestroyScreen( void )
{
  ClearWindow( _wndTop );   
  delwin( _wndTop );
  curs_set( TRUE );
  endwin();
}

/*******************************************************************************
                                
*******************************************************************************/
void ClearWindow( WINDOW *win)
{
   int y, x;

   werase( win );
   wclear( win );   
/*   for( y = 0; y <= win->_maxy; y++ ) {
      for( x = 0; x <= win->_maxx; x++ ) {
        wmove( win, y, x );
	waddch( win, ' ' );
      }
   }      	   
*/   
   wrefresh( win );
}

/*******************************************************************************
                                
*******************************************************************************/
void ClearLine( int length, WINDOW *win )
{
  int i,y_start,x_start;
  
  getyx( win, y_start, x_start );
  for( i = x_start+1; i <= length; i++ )
     waddch( win, ' ' );
  wrefresh( win );     
}


void ScrollUp( WINDOW *win )
{
   scrollok( win, TRUE );
   wscrl( win, +1 );
   scrollok( win, FALSE );	 
   ClearLine( win->_maxy, win );
}

void ScrollDown( WINDOW *win )
{
   scrollok( win, TRUE );
   wscrl( win, -1 );
   scrollok( win, FALSE );	 
   ClearLine( 0, win );
}
