#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include "ftnfreq.h"
#include "_screen.h"
#include "_listselect.h"


/******************************************************************************
                        
		     ~~~~~~~~~~~~~~~~~~~~~~~~~
      _selectTail
******************************************************************************/
void AddElementInListSelect( void )
{
   select_type  *tmp;
   
   tmp = (select_type *)new select_type*[ 1 ];
   if( tmp == NULL ) {
      DestroyScreen();
      printf( "Error! Unable alloc memory for malloc select_type\n" );
      exit( -1 );
   }
   if( _selectTail ) {
      _selectTail->next = tmp;
   }
   _selectTail = tmp;   
   if( !_selectHead ) {
      _selectHead = tmp;
   }
   tmp->next = NULL;      
   _selectTail->index = -1;
}

/******************************************************************************
                           
			 ~~~~~~~~~~~~~~~~~~~
******************************************************************************/
void DeleteListSelect( void )
{
   select_type  *tmp;
   
   while( _selectHead != NULL )
   {
      tmp = _selectHead->next;
      delete( _selectHead );
      _selectHead = tmp;
   }
   _selectHead = NULL;
   _selectTail = NULL;
   _countSelect = 0;
   char str[ 30 ];
   sprintf( str, "Select %2d file(s)", _countSelect );
   mvwaddstr( _wndTop, 0, 46, str );		   
   wrefresh( _wndTop );    
}


/******************************************************************************
                            
			 ~~~~~~~~~~~~~~~~~~~~~~~~~~~
******************************************************************************/
void DeleteElementOutListSelect( select_type *de )
{
   select_type *tmp = _selectHead;



   if( _selectHead == de ) {
      _selectHead = _selectHead->next;
      delete( de );
      return;
   }
      
   while( tmp != NULL ) {
     if( tmp->next == de ) {
       tmp->next = de->next;
       delete( de );
       return;
     }
     tmp=tmp->next;
   }
}


/******************************************************************************
                         /   
			 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
******************************************************************************/
void AddDelIndexInListSelect( long num )
{
  select_type *tmp = _selectHead;
  int         flagFound = FALSE;
  
  while( tmp != NULL ) {
    if( tmp->index == num ) {
       flagFound = TRUE;
       break;
    }
    tmp = tmp->next;
  }
  if( flagFound == FALSE ) {
     if( TestCorrect( num ) == TRUE ) {
       _selectTail->index = num;       
       _countSelect++;
     }     
  }  
  else {
     /*    tmp   */  
     DeleteElementOutListSelect( tmp );
     _countSelect--;
  }     
  
  /*     */
  char str[ 30 ];
  sprintf( str, "Select %2d file(s)", _countSelect );
  mvwaddstr( _wndTop, 0, 46, str );		   
  wrefresh( _wndTop );    
}

/******************************************************************************
                         
          	      ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  -   		      
******************************************************************************/
int TestCorrect( long num )
{
  FILE *fp;
  long  countLine;
  char tmpStr[ MAX_LENGTH_STRING ];
  
  fp = fopen( _currParm->fname, "r" );
  
  countLine = _currParm->curr;
   while( countLine-- > 0 ) 
      fgets( tmpStr, MAX_LENGTH_STRING - 1, fp );      
   fgets( tmpStr, MAX_LENGTH_STRING - 1, fp );   
   fclose( fp );
  
   if( isalnum( tmpStr[1] ) == TRUE ) return( TRUE );
   if( tmpStr[1] =='-' ) return( TRUE );
   if( tmpStr[1] =='&' ) return( TRUE );
   
   /*  9 bit */
   if( tmpStr[0] == ':' && tmpStr[1] == ' ' ) return( TRUE );
   return( FALSE );
}
