/* 'bsd-style-copyrights' must be placed here */

#ifndef _PKT_H_
#define _PKT_H_     

#define	VERSION	"1.0"

#define MAX_DT		20
#define MAX_USER	36
#define MAX_SUBJ	72
#define MAX_ATTR	80
#define hdrTOPT	"TOPT"
#define hdrFMPT	"FMPT"

typedef struct
{
  unsigned short int phONode,           // origination node
                     phDNode,           // destination node 
  		     phYear,		// year
  		     phMonth,		// month
  		     phDay,		// day
  		     phHour,		// hour
  		     phMinute,		// minute
  		     phSecond,		// second
  		     phBaud,		// baud
  		     phType,		// packet type 0x200
  		     phONet,		// origination net
  		     phDNet;		// destination net
  unsigned char	phPCode,		// product code (low-order)
                phMajor,		// major version
                phPass[8];		// packet password (not ASCIIZ)
  unsigned short int phQOZone,		// originating zone (QMail)
                     phQDZone,		// destination zone (QMail)
                     phAuxNet,		// auxillary net (unused)
                     phCWValidate;	// CapWord validation
  unsigned char phPCodeHi,		// product code (high-order)
                phPRevMinor;		// minor version
  unsigned short int phCaps,		// capabilities
                     phOZone,		// originating zone (FSC-39)
                     phDZone,		// destination zone (FSC-39)
                     phOPoint,		// originating point (FSC-39)
                     phDPoint;		// destination point (FSC-39)
  unsigned short int phLongData[2];	// product dependent information
} PacketHeader;

typedef struct 
{
  unsigned short int pmType;			// packet type 0x200
  unsigned short int pmONode;			// origination node
  unsigned short int pmDNode;			// destination node
  unsigned short int pmONet;			// origination net
  unsigned short int pmDNet;			// destination net
  unsigned short int pmAttr;			// packet attribute
  unsigned short int pmCost;			// packet cost
} PacketMessageHeader;

#endif /* !_PKT_H_ */
