/* 'bsd-style-copyrights' must be placed here */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>

#include "pkt.h"		// packet header structure

FILE	*fname;			// current pkt
long	pktsize;		// size of pkt
PacketMessageHeader	pm;	// header of pkt
PacketHeader 		ph;	// header of current message
char	DateTime[MAX_DT],	// date & time of current message
	FromUser[MAX_USER],	// name of sender
	ToUser[MAX_USER],	// name of recepient
	Subject[MAX_SUBJ],	// subject of current message
	Attrs[MAX_ATTR];	// attributes of current message (string form)
char	*Text;			// body of current message
char	*mToPoint,		// pointer to cludge "@TOPT"
	*mFromPoint;		// pointer to cludge "@FMPT"
char	mTOPT[]=".0   ",	// ready to print ToPoint information
	mFMPT[]=".0   ";	// ready to print FromPoint information
int 	mesc=1;			// message counter
int 	flagI=0, flagC=0, flag1=0, flagM=0, flagK=0;	// comand line params


char *Attrset[16] = {		// attributes
	"Pvt", "Crs", "Rcv", "Snt", "Att", "Trn", "Orp", "K/s", 
	"Loc", "Hld", "Rsv", "Frq", "Rrq", "Rrc", "Arq", "Fup"
};


void makeAttrs()
{ // converts word of attributes to string
	int a;
	long f = pm.pmAttr;
	
	Attrs[0] = 0;
	
	for ( a = 0; a < 16; a++ )
		if ( f & ( 1L << a ) ) {
			strcat( Attrs, Attrset[a] );
			strcat( Attrs, " " );
		}
	
	if ( ( a == strlen( Attrs ) ) && Attrs[a-1] == ' ' )
		Attrs[a-1] = 0;
}


int readfield( unsigned char Field[] )
{ // Simple subroutine to read any data field until '\0' would be found. 
  // Saves a lot of code space.
	
	int i=0;
	if ( fread(&Field[0],1,1,fname) != 1 )
		return 1;
  
	while( Field[i] != 0x0 ) {		// 00h - end of line
		
		if ( Field[i] == 0x0d ) 
			Field[i] = '\n';	// 0Dh - 'hard' carriage return
		else {
			if ( Field[i] == 0x01 ) {
				Field[i] = '@';	// 01h - system information
			}
		}
		
		i++;
		if ( fread(&Field[i],1,1,fname) != 1 )
			return 1;
	}
	
	return 0;
}


void deline( char c )
{ // Draws delimiter line.
	int i;
	
	for ( i=0; i<79; i++)
		printf( "%c", c );
	
	printf( "\n" );

	return;
}


void xfputc( char c, FILE *fp, int flush )
{ // puts character c to fp, but "formats" text not letting the words
  // to be cut at the end of line
	
	static int charswritten = 0;
	static char buffer[82 * sizeof( char )]="";
	const int margin = 80;
	int i;
	
	if ( flush ) { /* flush buffer */
		for ( i = 0; i < strlen( buffer ); i++ )
			fputc( buffer[i], fp );
		buffer[0] = 0;
		charswritten = 0;
		return;
	}
	
	if ( c == 0xA ) { /* new line */
		for ( i = 0; i < strlen( buffer ); i++ )
			fputc( buffer[i], fp );
		buffer[0] = 0;
		charswritten = 0;
		fputc( 0xA, fp );
		return;
	}
	
	if ( c == ' ' ) { /* space */
		charswritten += strlen( buffer );
		for ( i = 0; i < strlen( buffer ); i++ )
			fputc( buffer[i], fp );
		buffer[0] = 0;
		if ( charswritten < margin ) {
			fputc( ' ', fp );
			charswritten++;
		} else {
			fputc( 0xA, fp );
			charswritten = 0;
		}
		return;
	}
	
	if ( charswritten + strlen( buffer ) < margin ) { /* regular character */
		i = strlen( buffer );
		buffer[i] = c;
		buffer[i+1] = '\0';
	} else {
		if ( charswritten ) {
			fputc( 0xA, fp );
			charswritten = 0;
		}
		
		if ( strlen( buffer ) < margin ) {
			i = strlen( buffer );
			buffer[i] = c;
			buffer[i+1] = '\0';
		} else {
			for ( i = 0; i < strlen( buffer ); i++ )
				fputc( buffer[i], fp );
			fputc( 0xA, fp );
			buffer[0] = c;
			buffer[1] = '\0';
		}
	}
	
	return;
}


void xprintf( char* s )
{ // prints text to stdout without cludges (if !flagK)
	
	char *ptr = s;
	int PrevIsCR = 1;

	if ( flagK )	// show kludges
		while ( *ptr )
			xfputc( *ptr++, stdout, 0 );
      
	else {		// don't show kludges
		while ( *ptr ) {
			if ( *ptr == '@' && PrevIsCR ) { // start of kludge line
				
				while ( *ptr != 0x0a && *ptr != '\0' ) 
					ptr++;
				if ( *ptr != '\0' ) 
					ptr++;
				
			} else { // simple character, not a part of kludge line

				if ( *ptr == 0x0a )
					PrevIsCR = 1;
				else
					PrevIsCR = 0;
      
				xfputc( *ptr++, stdout, 0 );

			} // else
		} // while
	} // else
  
	xfputc( 0, stdout, 1 ); // flush buffer
}


int readpktmsg( void )
{ // read one message from pkt
	
	int i, j;

	// read message header
	if ( fread( &pm, sizeof( PacketMessageHeader ), 1, fname ) != 1 ||
			pm.pmType == 0 )
		return 1;

	if ( readfield( DateTime ) )	// read date & time
		return 1;
	if ( readfield( ToUser ) )	// read sender
		return 1;
	if ( readfield( FromUser ) )	// read recepient
		return 1;
	if ( readfield( Subject ) )	// read subject
		return 1;

	if ( readfield( Text ) )	// read text of message
		return 1;

	// clear FromPoint & ToPoint information
	mTOPT[0] = '.'; mTOPT[1] = '0';
	mFMPT[0] = '.'; mFMPT[1] = '0';
	for ( i = 2; i < 5; i++) mTOPT[i] = ' ';
	for ( i = 2; i < 5; i++) mFMPT[i] = ' ';

	// find & read ToPoint information
	j = 5;
	if ( (int)mToPoint = strstr( Text, hdrTOPT ) )
		while( j < 9 && isdigit( mToPoint[j] ) ) {
			mTOPT[j-4] = mToPoint[j];
			j++;
		}
  
	// if node, don't show ".0"
	if ( mTOPT[1] == '0' )
		for ( j = 0; j < 5; j++)
			mTOPT[j] = ' ';
  
	// find & read FromPoint information
	j = 5;
	if ( (int)mFromPoint = strstr( Text, hdrFMPT ) )
		while( j < 9 && isdigit( mFromPoint[j] ) ) {
			mFMPT[j-4] = mFromPoint[j];
			j++;
		}
	
  	// if node, don't show ".0"
	if ( mFMPT[1] == '0' )
		for ( j = 0; j < 5; j++)
			mFMPT[j] = ' ';
  
	makeAttrs();	// prepare line of attributes
  
	// print number of message & attributes
	printf( "Msg:  %-10d%64s\n", mesc, Attrs );
  
	// print "From" name & time
	if ( !flagC )
		dos2koi( FromUser, FromUser );
	printf( "From: %-32s 2:%i/%i%s  %s\n",
			FromUser, pm.pmONet, pm.pmONode, mFMPT, DateTime );

	// print "To" name
	if ( !flagC )
		dos2koi( ToUser, ToUser );
	printf( "To:   %-32s 2:%i/%i%s\n",
			ToUser, pm.pmDNet, pm.pmDNode, mTOPT) ;

	// printf subject
	if ( !flagC )
		dos2koi( Subject, Subject );
	printf( "Subj: %-74s\n", Subject );

	deline( '-' );			// draw delimiter line

	if ( !flagC )
		dos2koi( Text, Text );	// decode text, if needed

	xprintf( Text );		// print body of message

	deline( '=' );			// draw delimiter line

	bzero( Text, strlen( Text ) );	// clear field for next message

	return 0;
}


void errcode(int code)
{ // print error
	
	switch ( code ) {
		case 0:		break;
		case 1:		printf( "Cannot open input file!\n" ); break;
		case 2:		printf( "Incomplete command line!\n" ); break;
		default:	printf( "Unknown error!\n" ); 
	}
	
	return;
}


int main( int argc, char *argv[] )
{
	int i;

	// check number of parameters
	if ( argc < 2 ) {
		printf( "FTS Packet Viewer, v.%s\n", VERSION );
		printf( "usage: %s [i c 1 k] filename\n", argv[0] );
		printf( "i - print packet header info\n" );
		printf( "c - do not recode text from cp866 (alt) to koi8-r\n" );
		printf( "1 - print only first message\n" );
		printf( "k - show kludges\n" );
		printf( "\n" );
		
		{ errcode( 2 ); return 2; }
	}

	// parse command line flags
	for ( i = 1; i < (argc-1); i++) {
		if ( strcmp( argv[i], "i" ) == 0 )
			flagI = 1;
		if ( strcmp( argv[i], "c" ) == 0 )
			flagC = 1;
		if ( strcmp( argv[i], "1" ) == 0 )
			flag1 = 1;
		if ( strcmp( argv[i], "m" ) == 0 )
			flagM = 1;
		if ( strcmp( argv[i], "k" ) == 0 )
			flagK = 1;
	}

	// try to open pkt
	if ( ( fname = fopen( argv[argc-1], "r" ) ) == NULL ) {
		errcode( 1 );
		return 1;
	}
  
	// now we have to define the size of pkt
	if ( fseek( fname, 0, SEEK_END ) == -1 ) {
		perror( "can't define pkt size" );
		exit( 2 );
	}
	pktsize = ftell( fname );
	rewind( fname );
  
	// ask system for some memory for pkt
	Text = (char *)malloc( pktsize );
	if ( !Text ) {
		perror( "can't get memory for pkt" );
		exit( 3 );
	}
	bzero( Text, pktsize );

// Well, starting from pkt-header reading. To my mind, there is no necessary
// information here, and I'll delete this part later.
	if ( fread( &ph, sizeof( PacketHeader ), 1, fname ) != 1 ) {
		perror( "can't read pkt header" );
		exit( 1 );
	}

	// if needed to print pkt info
	if ( flagI ) {
		printf( "FTS Packet Viewer, v.%s\n", VERSION );
		printf( "Packet %s header information:\n", argv[argc-1] );
	  
		ph.phOPoint ?
			printf( " packed %i/%i/%i by %i:%i/%i.%i\n",
					ph.phDay, ph.phMonth, ph.phYear, 
					ph.phOZone, ph.phONet,ph.phONode,
					ph.phOPoint) :
			printf( " packed %i/%i/%i by %i:%i/%i\n",
					ph.phDay, ph.phMonth, ph.phYear,
					ph.phOZone,ph.phONet,ph.phONode );

		ph.phDPoint ?
			printf( " route via %i:%i/%i.%i on %i speed\n",
					ph.phDZone, ph.phDNet, ph.phDNode,
					ph.phDPoint,ph.phBaud) : 
			printf( " route via %i:%i/%i on %i speed\n",
					ph.phDZone, ph.phDNet, ph.phDNode,
					ph.phBaud);

#ifndef NO_UID 
	  if ( ( getuid() == 0 ) || ( geteuid() == 0 ) )
		  printf( " password %s\n", ph.phPass );
	  else
		  printf( " password XXX (you must be root to see it uncovered)\n" );
#else
	  printf( " Oops! No UID detection avaible (No-UNIX possible?)\n" );
	  printf( " password %s\n", ph.phPass );
#endif

	  { errcode( 0 ); return 0; }
	}
	
	deline( '=' );			// draw delimiter line

	// if only one message must be printed
	if ( flag1 )
		readpktmsg();
	
	else
		while ( 1 ) {	// print all messages
			if (readpktmsg())
				break;
			mesc++;
		}

	{ errcode( 0 ); return 0; }
}
