#
# This script analyses BinkD log and generates some statistics
#
# v.0.03, 27.04.1997
#
# Andrew Sukhorukov, 2:5020/118.42 AKA 2:5020/79.30
#
BEGIN \
{
    FS=" \\(|, | |@" # set field dividers (for auto splitting into $1, $2, ...)

    AllMonths="Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec"

    split(AllMonths, MonthList, ", ")                # create list of months
    for (n in MonthList)
    {
        month[MonthList[n]] = n
        # print MonthListl[n], "= ", n  # debugging
    }
    split("", MonthList)    # clear array

    FakeYear = ""strftime("%Y")    # BinkD doen't save year info in log
                                   # so we use current year :)

    # print "FakeYear = ", FakeYear
    KB = 1024
    BarsInHour = 2  # for channel load diagram
    StrictBarsBoundary = 1

    NodeMask = "^[1-9][0-9]*:(0|[1-9][0-9]*)\\/(0|[1-9][0-9]*)(\\.0|\\.[1-9][0-9]*)?$"
              # needed to check that field is correct FIDO (tm) node number

    Total = "Total"      # used for "total" stats
    SentBytes[Total] = 0+0
    RcvdBytes[Total] = 0+0
    SentTime[Total]  = 0+0
    RcvdTime[Total]  = 0+0

    NNodes = 0+0
    AddToSortedList(Total)

    STAT_DAY  = "DAY"
    STAT_WEEK = "WEEK"
    STAT_24H  = "24H"

    Analyse_WD = "WholeDays"
    Analyse_WB = "WholeBars"

    if     ( (STAT == STAT_DAY) || \
             (STAT == STAT_24H)      )     AnalysePeriod =     3600*24
    else if (STAT == STAT_WEEK)        {
                                           AnalysePeriod = 7 * 3600*24
                                           StrictBarsBoundary = 0
                                       }

    if ( (STAT == STAT_DAY) ||     \
         (STAT == STAT_WEEK)    )      AnalyseTimeType = Analyse_WD
    else if ( STAT== STAT_24H)         AnalyseTimeType = Analyse_WB
    else                               AnalyseTimeType = Analyse_WB

    if ( (STAT == STAT_24H) || !STAT )
        SplitBarDiagram = 1


    if (AnalysePeriod)
    {
        if (FakeDay && FakeMonth)
           StartTime = mktime(strftime("%Y")" "FakeMonth" "FakeDay" 0 0 0")
        else
           StartTime = systime()

        StartTime      -=  AnalysePeriod

        if (AnalyseTimeType == Analyse_WB)
           StartTime += (3600/BarsInHour - 1)  # analyse current interval too

        StartMonth      = strftime("%m", StartTime)+0
        StartDay        = strftime("%d", StartTime)+0
        StartDaySeconds = strftime("%H", StartTime) * 3600 +   \
                          strftime("%M", StartTime) * 60   +   \
                          strftime("%S", StartTime)

        if (AnalyseTimeType == Analyse_WD)
           StartTime  = mktime(strftime("%Y")" "StartMonth" "StartDay" 0 0 0")+0
        else if (AnalyseTimeType == Analyse_WB)
        {
           StartHour     = (StartDaySeconds - (StartDaySeconds%3600))/3600
           StartSeconds  = StartDaySeconds%60
           StartMinutes  = ((StartDaySeconds%3600) - StartSeconds)/60
           StartMinutes -= StartMinutes%(60/BarsInHour)

           StartTime  = mktime(strftime("%Y")" "StartMonth" "StartDay" "StartHour" "StartMinutes" 0")+0
        }
        StartDaySeconds = strftime("%H", StartTime) * 3600 +   \
                          strftime("%M", StartTime) * 60   +   \
                          strftime("%S", StartTime)

        EndTime       = StartTime + AnalysePeriod
        EndMonth      = strftime("%m", EndTime) +0
        EndDay        = strftime("%d", EndTime) +0
        EndDaySeconds = strftime("%H", EndTime) * 3600 +   \
                        strftime("%M", EndTime) * 60   +   \
                        strftime("%S", EndTime)

        #print "StartTime = ", StartTime, "month = ", StartMonth, "Day = ", StartDay

        if      (STAT == STAT_DAY)
        {
           print "       Statistics for ", strftime("%d %B %Y", StartTime)
        }
        else if (STAT == STAT_WEEK)
        {
           print "       Statistics for week from ",             \
                 strftime("%d %B %Y", StartTime),     " to ",    \
                 strftime("%d %B %Y", EndTime-3600*24)
        }
        else if (STAT == STAT_24H)
        {
           print "       Statistics for last 24 hours"
        }

        print ""
    } # if (AnalysePeriod)
    else
    {
        Analyse = "All"
        StrictBarsBoundary = 0

        print "                   Analysing whole LOG"
        print ""

    } # else (AnalysePeriod)

} # BEGIN

{ #Assign values
    FNode   = $11      # Fido node number
    Bytes   = $8+0     # Bytes sent
    FileCPS = $9+0
}
{
    if(FNode ~ NodeMask)
    {
        LogMonth = month[$3]+0
        LogDay   = $2+0
        LogTime  = $4

        if (!Analyse)
        {
            if ( (LogMonth > StartMonth)               ||        \
                 ((LogMonth==1) && (StartMonth==12))   ||        \
                 ((StartMonth==LogMonth) && (StartDay<=LogDay)) )
            {

                if( !AnalyseWholeDays &&
                    (StartMonth==LogMonth) && (StartDay==LogDay) &&
                    (StartDaySeconds>DaySeconds(LogTime) )       )
                {
                   TimeMatched = 0
                }
                else
                {
                   TimeMatched = 1
                }

                if(TimeMatched == 1)
                   Analyse = "WaitEnd"
            }

        }   # if (!Analyse)

        if (Analyse == "WaitEnd")
        {
            if ( (LogMonth > EndMonth)                 ||        \
                 ((LogMonth==1) && (EndMonth==12))     ||        \
                 ((EndMonth==LogMonth) && (EndDay<=LogDay)) )
            {
                if( !AnalyseWholeDays &&
                    (EndMonth==LogMonth) && (EndDay==LogDay) &&
                    (EndDaySeconds>DaySeconds(LogTime) )       )
                {
                   TimeMatched = 0
                }
                else
                {
                   TimeMatched = 1
                }

                if(TimeMatched == 1)
                   exit
            }

        }  # if (Analyse == "WaitEnd")

        if (Analyse && (($6 == "sent:") || ($6 == "rcvd:")) )
        {
            LogString = $0

            if (!FirstLogString[FNode])
            {     # this Node encountered for the first time
               AddToSortedList(FNode)

               FirstLogString[FNode] = LogString
               RcvdBytes[FNode]      = 0+0
               SentBytes[FNode]      = 0+0
               SentTime[FNode]       = 0+0
               RcvdTime[FNode]       = 0+0

               if (!FirstLogString[Total])
               {
                  FirstLogString[Total] = LogString
                  if (!StartTime)
                     StartTime = RecordTime(LogString)
               }
            }

            if ( Bytes>0 && FileCPS>0 ) # normal situation
            {
                FileTime = Bytes/FileCPS

                if (StrictBarsBoundary == 1)
                {
                   if (!TimeSinceStart)   # if not defined
                      TimeSinceStart = RecordTime(LogString) - StartTime

                   if(FileTime>TimeSinceStart)  #compare to previous time
                      TimeSinceStart = RecordTime(LogString) - StartTime

                   if(FileTime>TimeSinceStart)
                   {
                       FileTime = TimeSinceStart
                       Bytes    = FileTime * FileCPS
                       if(TimeSinceStart<0)
                          print "Internal error: TimeSinceStart<0"
                   }
                }
            }
            else                        # maybe not needed, but...
            {
               FileTime = 0
               FileCPS  = Bytes
            }

            if ( $6 ~ /s/    )
            {
                SentBytes[FNode] += Bytes; SentTime[FNode] += FileTime;
                SentBytes[Total] += Bytes; SentTime[Total] += FileTime;

                if (Bytes>0)
                   AddLoad(BarSentBytes, LogTime, FileCPS, FileTime)
            }

            if ( $6 ~ /r/    )
            {
                RcvdBytes[FNode] += Bytes; RcvdTime[FNode] += FileTime;
                RcvdBytes[Total] += Bytes; RcvdTime[Total] += FileTime;

                if (Bytes>0)
                   AddLoad(BarRcvdBytes, LogTime, FileCPS, FileTime)
            }

        } # if (Analyse && (($6 == "sent:") || ($6 == "rcvd:")))

    }  # if(FNode ~ NodeMask)

} # MAIN



END \
{
    if ( (EndTime-StartTime)>(24*3600) )
       DailyStats = 1

    TxtSeparator = ""
    if (DailyStats) TxtSeparator = TxtSeparator""
    TxtSeparator = TxtSeparator"Ĵ\n"

    printf ""
    if (DailyStats)      printf ""
    printf "Ŀ\n"

    printf "                   Total (KB)    "
    if (DailyStats)      printf "   Daily (KB)  "
    printf "        Average         \n"

    printf "     Node        Sent   Received "
    if (DailyStats)      printf "               "
    printf "   KBPS      Bandwidth  \n"

    printf TxtSeparator

    if (!EndTime)
       EndTime = RecordTime(LogString)

    CurIndex = 0
    for (ii=1; ii <= NNodes; ii++)
    {
        NextIndex = NodeIndex[CurIndex]
        CurIndex  = NextIndex

        node = NodeName[CurIndex]


        if (SentTime[node] > 0)
            SentCps = SentBytes[node] / SentTime[node]
        else
            SentCps = 0


        if (RcvdTime[node] > 0)
            RcvdCps = RcvdBytes[node] / RcvdTime[node]
        else
            RcvdCps = 0

        if (StartTime)
            TTime = EndTime - StartTime
        else
            TTime = EndTime - RecordTime(FirstLogString[node])

        if (TTime > 0)
        {
            SentBandw = SentBytes[node] / TTime
            RcvdBandw = RcvdBytes[node] / TTime
            SentDaily = 24*3600 * SentBandw
            RcvdDaily = 24*3600 * RcvdBandw
        }
        else
        {
            SentBandw  = 0+0
            RcvdBandw  = 0+0
            SentDaily  = 0+0
            RcvdDaily  = 0+0
        }


        if (node == Total)
        {
            printf TxtSeparator
            AnalysedTime = TTime
        }

        printf " %-15s%8d/%-8d",                                   \
                      node, SentBytes[node]/KB, RcvdBytes[node]/KB

        if (DailyStats)
            printf " %6d/%-6d ", SentDaily/KB, RcvdDaily/KB

        printf "%5.1f/%-5.1f %5.3f/%-5.3f \n",                     \
                  SentCps/KB,         RcvdCps/KB,                     \
                  SentBandw/KB,       RcvdBandw/KB

    }  # for (ii=1; ii <=NNodes; ii++)

    printf ""
    if (DailyStats)  printf ""
    printf "\n"

    if ( (AnalysedTime%(24*3600)) == 0)
       AddLoad(BarBasis, LogTime, 1, AnalysedTime)
    else
       AddLoad(BarBasis, LogTime, 1, AnalysedTime, "Whole")

    CalcKbpsLoad(BarSentKbps, BarSentBytes, BarBasis)
    CalcKbpsLoad(BarRcvdKbps, BarRcvdBytes, BarBasis)

    printf "\n\n               -= CHANNEL LOAD - SENDING =-\n"
    PrintBarDiagram(BarSentKbps)
    printf "\n\n              -= CHANNEL LOAD - RECEIVING =-\n"
    PrintBarDiagram(BarRcvdKbps)

} # END

#===========================================================================
#
function RecordTime(_LogString,        rmonth, ret, temp) \
{
   split(_LogString, temp, " ")

   rmonth = month[temp[3]]
   if(rmonth)
   {
    split(temp[4], rtime, ":")
    ret = mktime(FakeYear" "rmonth" "temp[2]" "rtime[1]" "rtime[2]" "rtime[3])
   }
   else
   {
    if (temp[3]) print "Unknown month: "temp[3]" , rmonth = "rmonth" str="LogString
   }

   if (DEBUG>=5) print "RecordLog(", LogString, ") =", ret

   return (ret+0)
}

#===========================================================================
# Adds
#
function AddToSortedList (_FNode,
                          ii, CIndex, NIndex, CurNodeNum)                  \
{
   NodeName[++NNodes] = _FNode
   CurNodeNum         = FNodeToNum(_FNode)
   NodeNum[NNodes]    = CurNodeNum

   CIndex = 0
   for (ii=1; ii<NNodes; ii++)
   {
       NIndex = NodeIndex[CIndex]
       if ( CurNodeNum < NodeNum[NIndex] )
         break

       CIndex = NIndex
   }

   NodeIndex[NNodes] = NodeIndex[CIndex]
   NodeIndex[CIndex] = NNodes
}

#===========================================================================
#  for TESTING only!! not used
function PrintSortedList (ttt) \
{
 CIndex = 0
 for (ii=1; ii <=NNodes; ii++)
 {
    NIndex = NodeIndex[CIndex]
    CIndex = NIndex

    printf "%-15s\n", NodeName[CIndex]
 }
 return ""
}

#===========================================================================
#
function FNodeToNum (_FNode,          ret, tt, tt2, temp) \
{
    if ( _FNode ~ NodeMask )
    {
        tt = _FNode".0"
        gsub(/[.\/:]/, " ", tt)
        split(tt, temp, " ")

        tt2 = sprintf("%03d%05d%05d%05d", temp[1], temp[2], temp[3], temp[4])
        split(tt2, ret)

        return ret[1]
    }
    else
        return _FNode
}


#===========================================================================
#
function DaySeconds(_LogTime,                       temp)   \
{
    split(_LogTime, temp, ":")
    return ((temp[1]*60 + temp[2])*60 + temp[3])
}

#===========================================================================
#
function AddLoad(_BarData, _LogTime, _FileCPS, _FileTime, _Whole,   \
                                                                    \
                 temp, LogSeconds, LogHour, SecondsInBar, Hfract,   \
                 LSec, bar, bar_max, NDays, FileSeconds) \
{
    split(_LogTime, temp, ":")
    LogSeconds   = temp[2]*60 + temp[3]
    LogHour      = temp[1] + 0

    SecondsInBar = 60*60/BarsInHour
    Hfract       = (LogSeconds - LogSeconds%SecondsInBar)/ SecondsInBar
    LSec         = LogSeconds - Hfract*SecondsInBar
    bar_max      = 24*BarsInHour
    bar          = LogHour*BarsInHour + Hfract

    NDays = (_FileTime - _FileTime%(24*3600)) /(24*3600)
#  print "FileTime = ", _FileTime, " LogTime = ", _LogTime, " NDays = ", NDays

    if(NDays>0)
    {
        for(bar=0; bar < bar_max; bar++)
           _BarData[bar] += _FileCPS * SecondsInBar * NDays
    }

    FileSeconds = _FileTime - NDays * (24*3600)
  #  print "FileSeconds = ", FileSeconds, " LogSeconds = ", LogSeconds, LSec, Hfract, Sfract
  #  print "FLogHour is ", FLogHour, " Ndays= ", NDays

    if(FileSeconds >= LSec)
    {
        if(_Whole)
           _BarData[bar] += SecondsInBar * _FileCPS
        else
           _BarData[bar] += LSec         * _FileCPS

        FileSeconds -= LSec
    }
    else
    {
        if(_Whole)
           _BarData[bar] += SecondsInBar * _FileCPS
        else
        {
            if(_FileTime > 0)                     # normal situation
               _BarData[bar] += FileSeconds * _FileCPS
            else                                  # maybe not needed, but...
               _BarData[bar] += _FileCPS
        }
        FileSeconds = 0
    }


    while(FileSeconds>0)
    {
        bar--
        if(bar<0)
           bar += bar_max

        if(FileSeconds > SecondsInBar)
        {
            _BarData[bar] += SecondsInBar * _FileCPS
            FileSeconds  -= SecondsInBar
        }
        else
        {
            if(_Whole)
               _BarData[bar] += SecondsInBar * _FileCPS
            else
               _BarData[bar] += FileSeconds  * _FileCPS

            FileSeconds = 0
        }

    }  # while(FileSeconds>0)

}   # AddLoad

#===========================================================================
#
function CalcKbpsLoad(_BarKbps, _BarBytes, _BarBasis,                  bar) \
{
    for(bar = 0; bar < (24*BarsInHour); bar++)
    {
        if ( (_BarBasis[bar] + 0) >0 )
        {
            _BarKbps[bar] += 0
            _BarKbps[bar]  = _BarBytes[bar] / _BarBasis[bar]
            _BarKbps[bar] /= KB
        }
        else
            _BarKbps[bar] = 0+0
    }

}   # CalcKbpsLoad

#===========================================================================
#
function PrintBarDiagram(_BarData,                                         \
                                                                           \
                         bar, LoadLevels, MaxLoad, AverageLoad, Tic, hour, \
                         bar_split                                       ) \
{
    MaxLoad = 0+0
    BWLoad  = 0+0

    if (SplitBarDiagram && ((EndTime-StartTime)<=24*3600) )
    {
        bar_split = ((StartTime - StartTime%(3600/BarsInHour))\
                          /(3600/BarsInHour))%(24*BarsInHour)

      #  barStart = ((StartTime - StartTime%(3600/BarsInHour))\
      #                    /(3600/BarsInHour))%(24*BarsInHour)
      #
      #  barEnd   = ((EndTime - EndTime%(3600/BarsInHour))\
      #                    /(3600/BarsInHour))%(24*BarsInHour)
      #
      #  if(barStart>=barEnd)
      #
    }
    else
        bar_split = -100

    if ( bar_split == 0) # there is "natural" split here
        bar_split = -100


    SplitTxt = "//"

    for(bar = 0; bar < (24*BarsInHour); bar++)
    {
        if (MaxLoad < _BarData[bar])
           MaxLoad = _BarData[bar]

        AverageLoad += _BarData[bar]     # needed for testing only
    }

    AverageLoad /= 24*BarsInHour

    printf "           Scale: %3.3f KBytes/sec\n", MaxLoad
    ##    print AverageLoad, AverageLoad*24*3600 #for testing only

    if(MaxLoad==0)
        MaxLoad=1

    LoadLevels = 20 + 0

    printf "       "
    for(bar = 0+0; bar < (24*BarsInHour); bar++)
    {
        if(bar == bar_split)
            printf SplitTxt

        printf ""
    }
    printf "Ŀ\n"


    Tic   =  1 + 0
    for(level = LoadLevels; level>0; level--)
    {
        if(Tic)
           printf "   %02.1f  ", level/LoadLevels
        else
           printf "        "

        Tic = !Tic

        for(bar = 0+0; bar < (24*BarsInHour); bar++)
        {
            if(bar == bar_split)
               printf "  "

            if(_BarData[bar]>=(0.999999*MaxLoad*level/LoadLevels))
               printf ""
            else
            {
                if( (_BarData[bar] > 0) && (level == 1) )
                    printf ""
                 else
                    printf " "
            }
        }

        printf " \n"

    }   # for(level = LoadLevels; level>0; level--)

    printf "       "

    for(bar = 0+0; bar < (24*BarsInHour); bar++)
    {
        if(bar == bar_split)
            printf SplitTxt

        if( (bar%(2*BarsInHour)) == 0 )
            printf ""
        else
            printf ""
    }
    printf "\n         "

    Tic = 1+0

    hour_split = ((bar_split+BarsInHour-1) - \
                  (bar_split+BarsInHour-1)%BarsInHour) / BarsInHour

    for(hour=0; hour < 24; hour++)
    {
        if( hour_split == hour )
           printf "   "

        if(Tic)
            printf "%-2d", hour
        else
            printf "  "

        for(nn=2; nn < BarsInHour; nn++)
        {
            printf " "
        }

        Tic = !Tic
    }

    printf "\n"

}  # PrintLoadDiagram
