/*
    This file needs to be defined. Originally was a place to put functions.
    Name is subject to change without notice!
*/

#include "cmp3funcs.h"

/****************************************************************************
 *  Change the directory
 *  Pass in current directory and the change you want to make
 *      (.., newdirname)
 *  Returns: 0 if nothing changed, 1 otherwise
 ****************************************************************************/
extern int dirchange(char *directory, char *delta)
{
    char       *theloc;

    if ((directory == NULL) || (*directory == '\0')) {
        fprintf(stderr, "error in dirchange\n");
        return(0);
    }

    if (strcmp(delta, "..") == 0) {
        if (strcmp(directory,"/") == 0)
            return(0);
        theloc = strrchr(directory, '/');
        if (theloc == NULL)
            strcpy(directory, "/");
        else
            *theloc = '\0';
        if (*directory == '\0')
            strcpy(directory, "/");
        return(1);
    }
    if (strcmp(directory, "/") != 0)
        strcat(directory,"/");
    strcat(directory, delta);
    return(1);
}

/****************************************************************************
 *  Is this a directory?
 *  Returns: PASS or FAIL
 ****************************************************************************/
extern int isdir(char* directory, char* name)
{
    static char fullpath[MAX_FULL];
    static struct stat buffer;

    sprintf(fullpath, "%s/%s", directory, name);
    if (stat(fullpath,&buffer) == -1)
        return(-1);
    if (S_ISDIR(buffer.st_mode))
        return(1);
    return(0);
}

/****************************************************************************
 *  Change to a new directory
 *  Returns: nothing
 ****************************************************************************/
extern void newdir(char *dirname)
{
    int             count,
                    numfiles;
    struct dirent   **dirlist;
    list_left_t     leftentry;
    list_right_t    rightentry;
    int             diff;
    char            *dname;

    diff = strlen(dirname);
    if (diff > (COLS / 2) - 14)
        mvwprintw(win_left, 1, 12, "..%s/\n",dirname+(diff-((COLS/2)-18)));
    else
        mvwprintw(win_left,1,12,"%s/\n",dirname);
    box(win_left,0,0);
    wnoutrefresh(win_left);

    leftentry.name = Strdup("..");
    ll_addfirst(list_left, &leftentry);

    numfiles = scandir(dirname, &dirlist, 0, alphasort);
    for (count = 0; count < numfiles; count++) {
        
        dname = dirlist[count]->d_name;

        if (*dname == '.')
            continue;

        if (isdir(dirname,dname) > 0)
        {
            leftentry.name = dname;
            ll_addlast(list_left, &leftentry);
        } else
            if ((Strcmp(dname+(strlen(dname)-4),".mp3") == 0) ||
                isPlaylist(dname))
            {
                rightentry.name = dname;
                ll_addlast(list_right, &rightentry);
            }
    }
    return;
}

/****************************************************************************
 *  Recursively find all mp3s and add to playlist
 *  Even though I think this is bad, users request it.
 *  Set RECURS_DEPTH to a sane value for safety.
 *  Returns: nothing
 ****************************************************************************/
extern void recursdir(char *dirname, int depth)
{
    struct dirent   **dirlist;
    int             numfiles,
                    count;
    char            *dname,
                    fullname[MAX_FULL];

    if (depth == 0)
        return;

    numfiles = scandir(dirname, &dirlist, 0, alphasort);
    for (count = 0; count < numfiles; count++) {
        
        dname = dirlist[count]->d_name;

        if (*dname == '.')
            continue;

        if (isdir(dirname,dname))
        {
            sprintf(fullname, "%s/%s", dirname, dname);
            recursdir(fullname, depth - 1);
        } else
            if (Strcmp(dname+(strlen(dname)-4),".mp3") == 0)
            {
                sprintf(fullname, "%s/%s", dirname, dname);
                pl_addentry(fullname);
            }
    }
    free(dirlist);

    return;
}

/* EOF */
