/*
 *  apcpipe.c -- IPC management tool for apcupsd package.
 *
 *  apcupsd.c -- Simple Daemon to catch power failure signals from a
 *               BackUPS, BackUPS Pro, or SmartUPS (from APCC).
 *            -- Now SmartMode support for SmartUPS and BackUPS Pro.
 *
 *  Copyright (C) 1996-99 Andre M. Hedrick
 *                        <hedrick@astro.dyer.vanderbilt.edu>
 *  All rights reserved.
 */

/*
 *                     GNU GENERAL PUBLIC LICENSE
 *                        Version 2, June 1991
 *
 *  Copyright (C) 1989, 1991 Free Software Foundation, Inc.
 *                           675 Mass Ave, Cambridge, MA 02139, USA
 *  Everyone is permitted to copy and distribute verbatim copies
 *  of this license document, but changing it is not allowed.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 *  IN NO EVENT SHALL ANY AND ALL PERSONS INVOLVED IN THE DEVELOPMENT OF THIS
 *  PACKAGE, NOW REFERRED TO AS "APCUPSD-Team" BE LIABLE TO ANY PARTY FOR
 *  DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING
 *  OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF ANY OR ALL
 *  OF THE "APCUPSD-Team" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  THE "APCUPSD-Team" SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING,
 *  BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 *  ON AN "AS IS" BASIS, AND THE "APCUPSD-Team" HAS NO OBLIGATION TO PROVIDE
 *  MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 *
 *  THE "APCUPSD-Team" HAS ABSOLUTELY NO CONNECTION WITH THE COMPANY
 *  AMERICAN POWER CONVERSION, "APCC".  THE "APCUPSD-Team" DID NOT AND
 *  HAS NOT SIGNED ANY NON-DISCLOSURE AGREEMENTS WITH "APCC".  ANY AND ALL
 *  OF THE LOOK-A-LIKE ( UPSlink(tm) Language ) WAS DERIVED FROM THE
 *  SOURCES LISTED BELOW.
 *
 */

/*
 *  FIXME:
 *  If the fifo files exist before starting apcupsd and apcaccess, things
 *  screw up (experimental observation).
 *  I think that this fifo thing is not the best one we can hope to implement.
 *  I suggest to write the apcaccess as a special case of network connection
 *  (with a network socket dedicated to talking with apcaccess).
 *  Of course this will be part of the major network revamping I am planning.
 *  -RF
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <fcntl.h>
#include <limits.h>
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/ipc.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <ctype.h>

#include <apc_version.h>
#include <apc_defines.h>
#include <apc_struct.h>
#include <apc_extern.h>

#ifndef NEW_THREADS

#define BUFFER_SIZE PIPE_BUF

extern int server_fifo_fd;
extern int client_fifo_fd;

extern FILE *procfile;
extern FILE *logfile;

struct stat statbuf;

DATAINFO myDATA = {
	"\0",          /* data->apcmagic             */
	0,             /* data->update_master_config */
	0,             /* data->get_master_status    */
	-1,            /* data->slave_status         */
	0,             /* data->call_master_shutdown */
	"\0"           /* data->accessmagic          */
};

CONFIGINFO myCONFIG = {
	0,             /* config->new_annoy          */
	0,             /* config->new_maxtime        */
	0,             /* config->new_delay          */
	0,             /* config->new_proctime       */
	0,             /* config->new_logtime        */
	0,             /* config->new_nettime        */
	0,             /* config->new_percent        */

	"\0",          /* config->new_batt_cmd       */
	"\0",          /* config->new_time_cmd       */
	"\0",          /* config->new_load_cmd       */
	"\0",          /* config->new_pwr_cmd        */
	"\0",          /* config->new_ret_cmd        */
	"\0"           /* config->new_remote_cmd     */
};

/*********************************************************************/
int pipe_requests (UPSINFO *ups)
{
	int renetfd;
	int test = 0;
	int bytes_sent = 0;
	int bytes_read = 0;

	ups->remotedown = FALSE;

	if ((server_fifo_fd = open(ACCESS_FIFO, O_RDONLY)) == -1)
		return(0);

	if (mkfifo(PIPE_FIFO, 0777) == -1) {
		close(server_fifo_fd);
		unlink(PIPE_FIFO);
		return(0);
	}

	if ((client_fifo_fd = open(PIPE_FIFO, O_WRONLY)) == -1) {
		close(server_fifo_fd);
		unlink(PIPE_FIFO);
		unlink(ACCESS_FIFO);
		return(0);
	}

	if ((test = read(server_fifo_fd, &myDATA, sizeof(myDATA))) != sizeof(myDATA)) {
		close(client_fifo_fd);
		close(server_fifo_fd);
		unlink(PIPE_FIFO);
		logprintf("%s: client fifo read failure\n", ups->argvalue);
		logprintf("%s: DATA READ ERROR apcaccess Socket.\n", ups->argvalue);
		logprintf("%s: %d size of myDATA\n", ups->argvalue, test);
		logprintf("%s: %d %s\n", ups->argvalue, strlen(myDATA.apcmagic), myDATA.apcmagic);
		logprintf("%s: %d %s\n", ups->argvalue, strlen(myDATA.accessmagic), myDATA.accessmagic);
		logprintf("%s: APCMAGIC     : %s\n", ups->argvalue, myDATA.apcmagic);
		logprintf("%s: ACCESSMAGIC  : %s\n", ups->argvalue, myDATA.accessmagic);
		logprintf("%s: APCUPDATE    : %d\n", ups->argvalue, myDATA.update_master_config);
		logprintf("%s: APCSTATUS    : %d\n", ups->argvalue, myDATA.get_master_status);
		logprintf("%s: %s    : %d\n", ups->argvalue, (ups->fd != -1) ? "APCMASTER" : "APCSLAVE ", myDATA.slave_status);
		logprintf("%s: APCSHUTDOWN  : %d\n", ups->argvalue, myDATA.call_master_shutdown);
		logprintf("%s: %d size of myDATA\n", ups->argvalue, sizeof(myDATA));
		return(0);
	}

	if ((strcmp(APC_MAGIC, myDATA.apcmagic) == 0) &&
	    (strcmp(ACCESS_MAGIC, myDATA.accessmagic) == 0)) {
		if (myDATA.update_master_config == TRUE) {
			do {
				test = read(server_fifo_fd, &myCONFIG, BUFFER_SIZE);
				bytes_read += test;
			} while (test > 0) ;
			close(server_fifo_fd);
			pipe_reconfig(ups, &myCONFIG);
			if ((test = write(client_fifo_fd, &myDATA, sizeof(myDATA))) != sizeof(myDATA)) {
				logprintf("%s: %d size of myDATA\n", ups->argvalue, test);
				logprintf("%s: WRITE ERROR myDATA\n", ups->argvalue);
				close(client_fifo_fd);
				unlink(PIPE_FIFO);
				return(0);
			}
			close(client_fifo_fd);
		} else if (myDATA.get_master_status == TRUE) {
			pipe_master_status(ups);
			while(bytes_sent < sizeof(*ups)) {
				test = write(client_fifo_fd, ups, BUFFER_SIZE);
				bytes_sent += test;
			}
			close(client_fifo_fd);
		} else if ((myDATA.slave_status == TRUE) && (ups->fd != -1)) {
			pipe_slave_reconnect(ups);
			close(client_fifo_fd);
		} else if ((myDATA.slave_status == TRUE) && (ups->fd == -1)) {
			pipe_slave_release(ups);
			unlink(APC_RE_NET);
			if ((renetfd = open(APC_RE_NET, O_CREAT|O_WRONLY, 0644)) >= 0) {
				write(renetfd, REDO_NET "\n", sizeof(REDO_NET));
				close(renetfd);
			}
			close(client_fifo_fd);
		} else if (myDATA.call_master_shutdown == TRUE) {
			close(client_fifo_fd);
			close(server_fifo_fd);
			pipe_call_shutdown(ups);
		}
		/*
		if ((myDATA.update_master_config != TRUE) &&
		(myDATA.get_master_status != TRUE) &&
		(myDATA.call_master_shutdown != TRUE))
		*/
		else {
			logprintf("%s: All polling states are invalid \n", ups->argvalue);
			close(client_fifo_fd);
			close(server_fifo_fd);
		}
	} else {
		close(client_fifo_fd);
		close(server_fifo_fd);
		logprintf("%s: Bad Magic!! Hacker??\n", ups->argvalue);
		logprintf("%s: Disabled apcaccess Port Access.\n", ups->argvalue);
		logprintf("%s: %d size of myDATA\n", ups->argvalue, test);
		logprintf("%s: %d %s\n", ups->argvalue, strlen(myDATA.apcmagic), myDATA.apcmagic);
		logprintf("%s: %d %s\n", ups->argvalue, strlen(myDATA.accessmagic), myDATA.accessmagic);
		logprintf("%s: APCMAGIC     : %s\n", ups->argvalue, myDATA.apcmagic);
		logprintf("%s: ACCESSMAGIC  : %s\n", ups->argvalue, myDATA.accessmagic);
		logprintf("%s: APCUPDATE    : %d\n", ups->argvalue, myDATA.update_master_config);
		logprintf("%s: APCSTATUS    : %d\n", ups->argvalue, myDATA.get_master_status);
		logprintf("%s: %s    : %d\n", ups->argvalue, (ups->fd != -1) ? "APCMASTER" : "APCSLAVE ", myDATA.slave_status);
		logprintf("%s: APCSHUTDOWN  : %d\n", ups->argvalue, myDATA.call_master_shutdown);
		logprintf("%s: %d size of myDATA\n", ups->argvalue, sizeof(myDATA));
/*
 *		ups->enable_access.type = FALSE;
 */
	}
	unlink(PIPE_FIFO);
	return(1);
}

/*********************************************************************/
int pipe_reconfig (UPSINFO *ups, CONFIGINFO *config)
{
	int errors = 0;

	char new_battcmd[MAXSTRING];
	char new_timecmd[MAXSTRING];
	char new_loadcmd[MAXSTRING];
	char new_pwrcmd[MAXSTRING];
	char new_retcmd[MAXSTRING];
	char new_remotecmd[MAXSTRING];

	new_battcmd[0]   = '\0';
	new_timecmd[0]   = '\0';
	new_loadcmd[0]   = '\0';
	new_pwrcmd[0]    = '\0';
	new_retcmd[0]    = '\0';
	new_remotecmd[0] = '\0';

	if (ups->annoy != config->new_annoy)
		ups->annoy = config->new_annoy;

	if ((ups->maxtime != config->new_maxtime) &&
	    (config->new_maxtime >= 0))
		ups->maxtime = config->new_maxtime;

	if (ups->delay != config->new_delay) {
		ups->delay = config->new_delay;
		if (ups->annoy >= ups->delay)
			ups->delay = 0;
	}

	if ((procfile != NULL) && (config->new_proctime > 0) &&
	    (ups->proctime != config->new_proctime))
		ups->proctime = config->new_proctime;
	else if ((procfile == NULL) && (config->new_proctime > 0)) {
		procfile = fopen(UPS_STAT, "w");
		ups->proctime = config->new_proctime;
	} else {
		ups->proctime = 0;
		unlink(UPS_STAT);
	}

	if ((logfile != NULL) && (config->new_logtime > 0) &&
	    (ups->logtime != config->new_logtime))
		ups->logtime = config->new_logtime;
	else if ((logfile == NULL) && (config->new_logtime > 0)) {
		logfile = fopen(LOG_FILE, "a+");
		ups->logtime = config->new_logtime;
	} else {
		ups->logtime = 0;
		unlink(LOG_FILE);
	}

	if ((ups->nettime != config->new_nettime) &&
	    (config->new_nettime > 0))
		ups->nettime = config->new_nettime;

	if ((ups->percent != config->new_percent) &&
	    (config->new_percent >= 10))
		ups->percent = config->new_percent;

	strncpy(new_battcmd, config->new_batt_cmd, FILENAME_MAX);
	if (!((stat(new_battcmd, &statbuf) == 0) &&
	    (S_ISREG (statbuf.st_mode) &&
	    (statbuf.st_mode & S_IXUSR)))) {
		logprintf("Invalid Battery Command: %s\n", config->new_batt_cmd);
		new_battcmd[0] = '\0';
	} else {
		ups->batt_cmd[0] = '\0';
		sprintf(ups->batt_cmd," %s", config->new_batt_cmd);
	}

	strncpy(new_timecmd, config->new_time_cmd, FILENAME_MAX);
	if (!((stat(new_timecmd, &statbuf) == 0) &&
	    (S_ISREG (statbuf.st_mode) &&
	    (statbuf.st_mode & S_IXUSR)))) {
		logprintf("Invalid Time Expired Command: %s\n", config->new_time_cmd);
		new_timecmd[0] = '\0';
	} else {
		ups->time_cmd[0] = '\0';
		sprintf(ups->time_cmd," %s", config->new_time_cmd);
	}

	strncpy(new_loadcmd, config->new_load_cmd, FILENAME_MAX);
	if (!((stat(new_loadcmd, &statbuf) == 0) &&
	    (S_ISREG (statbuf.st_mode) &&
	    (statbuf.st_mode & S_IXUSR)))) {
		logprintf("Invalid Load Limit Command: %s\n", config->new_load_cmd);
		new_loadcmd[0] = '\0';
	} else {
		ups->load_cmd[0] = '\0';
		sprintf(ups->load_cmd," %s", config->new_load_cmd);
	}

	strncpy(new_pwrcmd, config->new_pwr_cmd, FILENAME_MAX);
	if (!((stat(new_pwrcmd, &statbuf) == 0) &&
	    (S_ISREG (statbuf.st_mode) &&
	    (statbuf.st_mode & S_IXUSR)))) {
		logprintf("Invalid Power Command: %s\n", config->new_pwr_cmd);
		new_pwrcmd[0] = '\0';
	} else {
		ups->pwr_cmd[0] = '\0';
		sprintf(ups->pwr_cmd," %s", config->new_pwr_cmd);
	}

	strncpy(new_retcmd, config->new_ret_cmd, FILENAME_MAX);
	if (!((stat(new_retcmd, &statbuf) == 0) &&
	    (S_ISREG (statbuf.st_mode) &&
	    (statbuf.st_mode & S_IXUSR)))) {
		logprintf("Invalid Return Command: %s\n", config->new_ret_cmd);
		new_retcmd[0] = '\0';
	} else {
		ups->ret_cmd[0] = '\0';
		sprintf(ups->ret_cmd," %s", config->new_ret_cmd);
	}

	strncpy(new_remotecmd, config->new_remote_cmd, FILENAME_MAX);
	if (!((stat(new_remotecmd, &statbuf) == 0) &&
	    (S_ISREG (statbuf.st_mode) &&
	    (statbuf.st_mode & S_IXUSR)))) {
		logprintf("Invalid Remote Command: %s\n", config->new_remote_cmd);
		new_retcmd[0] = '\0';
	} else {
		ups->remote_cmd[0] = '\0';
		sprintf(ups->remote_cmd," %s", config->new_remote_cmd);
	}

	if ((ups->sharenet.type == SHAREMASTER) ||
	    (ups->sharenet.type == SHARENETMASTER)) {
		ups->maxtime = 0;
		ups->percent = 10;
	}

	if (errors)
		return(1);
	else
		return(0);
}

/*********************************************************************/
int pipe_master_status (UPSINFO *ups)
{
	if (ups->fd != -1)
		return(check_serial(ups));
	return(0);
}

/*********************************************************************/
int pipe_call_shutdown (UPSINFO *ups)
{
	ups->remotedown = TRUE;
	return(0);
}

/*********************************************************************/
int pipe_slave_reconnect (UPSINFO *ups)
{
	ups->remote_state = 2;
	return(0);
}

/*********************************************************************/
int pipe_slave_release (UPSINFO *ups)
{
	ups->remote_state = 2;
	return(2);
}
#endif /* NEW_THREADS */
