/***************************************************************************
 *   Copyright (C) 2005 by Linares Georges                                 
 *   georges.linares@archipel-software.com                                 
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by  
 *   the Free Software Foundation; either version 2 of the License, or    
 *   (at your option) any later version.                                   
 *                                                                         
 *   This program is distributed in the hope that it will be useful,       
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         
 *   GNU General Public License for more details.                          
 *                                                                         
 *   You should have received a copy of the GNU General Public License     
 *   along with this program; if not, write to the                         
 *   Free Software Foundation, Inc.,                                       
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             
 ***************************************************************************/
#include <qapplication.h>
#include <qstring.h>
#include <qdom.h>
#include <qfiledialog.h>

#include "form1.h"

QString App_Folder;
QString app;
QString langues;
QString themes;

// Recupration de la langue avant de lancer le logiciel
void langue()
{
    QDomDocument doc( "file_conf" );
    QFile file( App_Folder + "/.bdfeui.conf" );
    if (! file.open( IO_ReadOnly ) ) return;
    if ( !doc.setContent( &file ) ) 
    {
        file.close();
        return;
    }
       file.close(); 
       
       QDomElement docElem = doc.documentElement();
   
       QDomNode n = docElem.firstChild();
    
       QDomElement element = doc.documentElement();
	
        for ( QDomNode n = element.firstChild(); !n.isNull(); n = n.nextSibling() )
       {
           QDomElement e = n.toElement(); 
            if( !e.isNull() ) 
           {
            // Recherche du noeud completelanguage
                if ( e.isElement() && e.nodeName() == "completelanguage" ) 
               {   
                     langues=e.text();
                }
                if ( e.isElement() && e.nodeName() == "themes" ) 
               {   
                     themes=e.text();
                }  
            }
         }
    }

int main( int argc, char **argv )
{
    QApplication a( argc, argv );
   // app = a.applicationDirPath();
   // App_Folder = argv[0];
    app = "/usr/share/bdfe/lng";
    App_Folder = QDir::homeDirPath();
    langue();
    QTranslator translator;
    translator.load("/usr/share/bdfe/lng/" + langues + ".qm");
   // translator.load(QDir::homeDirPath() + "/.bdfe/lng/" + langues + ".qm");
    a.installTranslator(&translator);
    a.setStyle(themes);
    frmPrincipale w;
    w.show();
    a.processEvents();
    a.connect( &a, SIGNAL( lastWindowClosed() ), &a, SLOT( quit() ) );
    return a.exec();
}
