/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
/***************************************************************************
 *   Copyright (C) 2005 by Linares Georges                                 
 *   georges.linares@archipel-software.com                                 
 *   This program is free software; you can redistribute it and/or modify  
 *   it under the terms of the GNU General Public License as published by  
 *   the Free Software Foundation; either version 2 of the License, or     
 *   (at your option) any later version.                                   
 *                                                                         
 *   This program is distributed in the hope that it will be useful,       
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         
 *   GNU General Public License for more details.                          
 *                                                                         
 *   You should have received a copy of the GNU General Public License     
 *   along with this program; if not, write to the                         
 *   Free Software Foundation, Inc.,                                       
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            
 ***************************************************************************/
 
#include <qfiledialog.h>
#include <qdom.h>
#include <qstring.h>
#include <qmessagebox.h>
#include <qprocess.h>
#include <qtimer.h>
#include <qfile.h>

#include "analyse.h"

extern QString App_Folder;
extern QString app;
QString Chemin;
QString languelng;

QString vScanFileDefault;
QString vScanAllFile;
QString vScanArchive;
QString vScanMails;
QString vNoScanArchive;
QString vScanExt;
QString fscan;

QString vActionToDo;
QString vInfectedFile;
QString vSuspectedFile;
int information;

QString vDisplayWarning;
QString vAvoidRecurs;
QString vDepthMaxArchive;
QString vDepthMaxFolder;
QString vnDepthMaxArchive;
QString vnDepthMaxFolder;

QString vCreateLog;
QString vDisplayDebugInfos;

QString vLanguage;
QString vThemes;

QString vCountDays;
QString vActiveAlert;
QDateTime   vLastModified;
QString ScanningFolder;
QProcess * proc;
QTimer  * timer = new QTimer();

bool vrai=true;
int cptPB=1;
QString Appli;
int i;
QString locale ;
QString lng;
QString ths;
QString line;
QString mois;
QString jour;
QString annee;
QString update_txt;
QDate dater;
QDate date;
int val;

void frmPrincipale::init()
{      
      //Renseigne le nom de chaque label de l'application gnrale    
       tbGeneral->setItemLabel(0,tr("Configuration gnrale"));
       tbGeneral->setItemLabel(1,tr("Mises  jour antivirale"));
       tbGeneral->setItemLabel(2,tr("Aide"));
       tbGeneral->setItemLabel(3,tr("A propos..."));
       // Choix de la langue du logiciel
       Appli = app;
       QDir dir(Appli);
       QStringList filename = dir.entryList("*.qm");
       for (i = 0; i <(int) filename.size();++i)
       {
	   locale = filename[i];
	   locale.truncate(locale.find('.'));
	   mdLanguage->insertItem(locale,i);
       }
       
        //Donne diverses informations sur le logiciel antivirus, son moteur de scan etc.
        proc = new QProcess( this );
        proc->addArgument( "bdc" );	
        proc->addArgument( "--info" );	
        connect( proc, SIGNAL(readyReadStdout()), this, SLOT(readFromStdout()) );
        connect( proc, SIGNAL(processExited()), this, SLOT(rien()) );
        if ( !proc->start() )
        {
          erreur();
         }
    /*
     Rcupration des variables  rcuprer dans le fichier de configuration.
    */
    
    QDomDocument doc( "file_conf" );
    Chemin = App_Folder + "/.bdfeui.conf";
    QFile file( Chemin );
    if (! file.open( IO_ReadOnly ) ) return;
    if ( !doc.setContent( &file ) ) 
    {
        file.close();
        return;
    }
       file.close(); 
       
       QDomElement docElem = doc.documentElement();
   
       QDomNode n = docElem.firstChild();
    
       QDomElement element = doc.documentElement();
	
        for ( QDomNode n = element.firstChild(); !n.isNull(); n = n.nextSibling() )
       {
        QDomElement e = n.toElement(); 
        if( !e.isNull() ) 
        {
         // batterie de tests effectus  partir du fichier de configuration
         if ( e.isElement() && e.nodeName() == "defaut" ) 
          {   
              vScanFileDefault=e.text();
              int a = vScanFileDefault.toInt( &vrai, 10);
              rbScannerDefault->setChecked(a);      
          }
          if ( e.isElement() && e.nodeName() == "all" ) 
          {
              vScanAllFile=e.text();
              int b = vScanAllFile.toInt( &vrai, 10);
              rbScannerAll->setChecked(b);
            }
          if ( e.isElement() && e.nodeName() == "archive" ) 
          {
              vScanArchive=e.text();
              int c = vScanArchive.toInt( &vrai, 10);
              rbScannerArchive->setChecked(c);
            }      	  
          if ( e.isElement() && e.nodeName() == "mails" ) 
          {
              vScanMails=e.text();
              int d = vScanMails.toInt( &vrai, 10);
              rbScannerMails->setChecked(d);
            } 	  
          if ( e.isElement() && e.nodeName() == "noscanarch" ) 
          {
              vNoScanArchive=e.text();
              int f = vNoScanArchive.toInt( &vrai, 10);
              rbScannerNoArchive->setChecked(f);
            }	
          if ( e.isElement() && e.nodeName() == "scanext" ) 
          {
              vScanExt=e.text();
              int g = vScanExt.toInt( &vrai, 10);
              rbScannerExtension->setChecked(g);
            }	  
          if ( e.isElement() && e.nodeName() == "acttodo" ) 
          {
              vActionToDo=e.text();
              int h = vActionToDo.toInt( &vrai, 10);
              mdActions->setCurrentItem(h);
            } 
          if ( e.isElement() && e.nodeName() == "infectfile" ) 
          {
              vInfectedFile=e.text();
              int k = vInfectedFile.toInt( &vrai, 10);
              mdInfectedFiles->setCurrentItem(k);
            }  
          if ( e.isElement() && e.nodeName() == "suspectfile" ) 
          {
              vSuspectedFile=e.text();
              int l = vSuspectedFile.toInt( &vrai, 10);
              mdSuspectedFiles->setCurrentItem(l);
            } 	  
          if ( e.isElement() && e.nodeName() == "displaywarn" ) 
          {
              vDisplayWarning=e.text();
              int m = vDisplayWarning.toInt( &vrai, 10);
              cbWarning->setChecked(m);
            } 	 	  
          if ( e.isElement() && e.nodeName() == "avoidrecurs" ) 
          {
              vAvoidRecurs=e.text();
              int n = vAvoidRecurs.toInt( &vrai, 10);
              cbAvoidRecurs->setChecked(n);
            } 	  
          if ( e.isElement() && e.nodeName() == "depthmaxarch" ) 
          {
              vDepthMaxArchive=e.text();
              int o = vDepthMaxArchive.toInt( &vrai, 10);
              cbDepthMaxArchive->setChecked(o);
            }
          if ( e.isElement() && e.nodeName() == "depthmaxfold" ) 
          {
              vDepthMaxFolder=e.text();
              int p = vDepthMaxFolder.toInt( &vrai, 10);
              cbDepthMaxFolder->setChecked(p);
            }	  
          if ( e.isElement() && e.nodeName() == "valdepthmaxarch" ) 
          {
              vnDepthMaxArchive=e.text();
              int q = vnDepthMaxArchive.toInt( &vrai, 10);
              sbDepthMaxArchive->setValue(q);
            }		  
          if ( e.isElement() && e.nodeName() == "valdepthmaxfold" ) 
          {
              vnDepthMaxFolder=e.text();
              int r = vnDepthMaxFolder.toInt( &vrai, 10);
              sbDepthMaxFolder->setValue(r);
            }		  
          if ( e.isElement() && e.nodeName() == "createlogfile" ) 
          {
              vCreateLog=e.text();
              int s = vCreateLog.toInt( &vrai, 10);
              cbCreateLogFile->setChecked(s);
            }	  
          if ( e.isElement() && e.nodeName() == "language" ) 
          {
              vLanguage=e.text();
              int t = vLanguage.toInt( &vrai, 10);
              mdLanguage->setCurrentItem(t);
            }	  
          if ( e.isElement() && e.nodeName() == "countdays" ) 
          {
              vCountDays=e.text();
              int u = vCountDays.toInt( &vrai, 10);
              sbCountDays->setValue(u);
            }	
          if ( e.isElement() && e.nodeName() == "activealert" ) 
          {
              vActiveAlert=e.text();
              int v = vActiveAlert.toInt( &vrai, 10);
              cbActiveAlert->setChecked(v);
            }	
          if ( e.isElement() && e.nodeName() == "completelanguage" ) 
          {
              mdLanguage->setCurrentText(e.text());
            }	
          if ( e.isElement() && e.nodeName() == "itemthemes" ) 
          {
              vThemes=e.text();
              int t = vThemes.toInt( &vrai, 10);
              mdThemes->setCurrentItem(t);
            }	 
          if ( e.isElement() && e.nodeName() == "themes" ) 
          {
              mdThemes->setCurrentText(e.text());
            }	
         // fin des tests
         }
         }  

        lng = mdLanguage->currentText();
        ths = mdThemes->currentText();
     // code pour la mise--jour antivirale
   int val = sbCountDays->value();	
   //***************** ANCIENNE CONFIGURATION BASEE SUR LA DATE DU REPERTOIRE PLUGINS
   //rcuperation de la date du fichier plugins + ajout de la valeur d'alerte
   QFileInfo fi = QString("/opt/bdc/Plugins");
   vLastModified = fi.lastModified();
   QDate dater = vLastModified.date();
   
   //NOUVELLE CONFIGURATION BASEE SUR LA DATE DU FICHIER UPDATE.TXT
   /*QFile fichier("/opt/bdc/Plugins/update.txt");
    if ( fichier.open( IO_ReadOnly ) ) 
   {
        QTextStream flux( &fichier );   
        line = flux.readLine();
	fichier.close(); 
        mois = line.mid( 17, 3 );
        if (mois=="Jan") mois = "01";
        if (mois=="Feb") mois = "02";
        if (mois=="Mar") mois = "03";
        if (mois=="Apr") mois = "04";
        if (mois=="May") mois = "05";
        if (mois=="Jun") mois = "06";
        if (mois=="Jul") mois = "07";
        if (mois=="Aug") mois = "08";
        if (mois=="Sep") mois = "09";
        if (mois=="Oct") mois = "10";
        if (mois=="Nov") mois = "11";
        if (mois=="Dec") mois = "12";
        jour = line.mid(21,2);
        annee = line.mid(33,4);
        update_txt = annee +"-"+mois+"-"+jour;
        dater = dater.fromString(update_txt, ISODate);
    }*/
   
   //FIN TRAITEMENT FICHIER
	   
   //rcupration de la date en cours...
   QDate date = QDate::currentDate();
  
    if (cbActiveAlert->isChecked() && dater.addDays(val)<=date) 
    {
        QMessageBox::warning(this, tr("BitDefender FE"),
        tr("La base de donnes virale. n'est pas  jours ! ") + dater.toString(),QMessageBox::Ok, 0,0);
    }
    if (dater.addDays(val)<=date) 
    {
                pmlInfo->setText(tr("La base de donnes antivirale n'est pas  jour ! ") + dater.toString());
                pmlInfo->setPaletteBackgroundColor(QColor(255,0,0));
                tbGeneral->setCurrentIndex(1);
    }
    else
    {
                pmlInfo->setText(tr("La base de donnes antivirale est  jour  ( ") + dater.toString() + " )");
	pmlInfo->setPaletteBackgroundColor(QColor(0,255,0));	
    }

    lblUpdateNow->hide();
    pbUpdateNow->hide();
    leScanFolder->setText( "/" );      
}


void frmPrincipale::browseFolder()
{
    // J'initialise uniquement la recherche de rpertoire et non pas de fichier
    
   QString parcourir = QFileDialog::getExistingDirectory("/", 0, 0,tr("Bit Defender rpertoire  scanner"), TRUE, TRUE);
		       
    if ( !parcourir.isEmpty() ) {
        leScanFolder->setText(parcourir);
        ScanningFolder = parcourir;
    }
}


void frmPrincipale::extension()
{
   if  (rbScannerExtension->isChecked())
    {
        leScanExtension->setEnabled(true);
        leScanExtension->setFocus();
    }
   else
   {
     leScanExtension->setEnabled(false);  
     leScanFolder->setFocus();       
    }
}

void frmPrincipale::divers()
{
    if (cbWarning->isChecked())
    {
	vDisplayWarning = "--nowarn";
    }
    else
    {
	vDisplayWarning = "";
    }
    if (cbAvoidRecurs->isChecked())
    {
	vAvoidRecurs = "--nor";
    }
    else
    {
	vAvoidRecurs = "";
    }
    if (cbDepthMaxArchive->isChecked())
    {
	vnDepthMaxArchive.setNum(sbDepthMaxArchive->value());
	vDepthMaxArchive = "--alev["+vnDepthMaxArchive+"]";
    }
    else
    {	
	vDepthMaxArchive = "";
    }
    if (cbDepthMaxFolder->isChecked())
    {
	vnDepthMaxFolder.setNum(sbDepthMaxFolder->value());
	vDepthMaxFolder = "--flev["+vnDepthMaxFolder+"]";
    }
    else
    {
	vDepthMaxFolder = "";
    }	
}


void frmPrincipale::edit_rapport()
{
        // cette procedure traite la partie rapport du logiciel et affecte une valeur aux diffrentes variables
      if (cbCreateLogFile->isChecked())
       {
         vCreateLog="--log";
       }	  
       else
       {
          vCreateLog="--debug";	   
       }
}

void frmPrincipale::action_fichier()
{
    // cette procedure traite la partie action du logiciel et affecte une valeur aux diffrentes variables
    if (mdActions->currentItem()==0) 
    {
         vActionToDo="--disinfect";
    }
    else
    {
         vActionToDo="--delete";
    }
    if (mdInfectedFiles->currentItem()==0)
    {
         vInfectedFile = "";
    }
    else
    if (mdInfectedFiles->currentItem()==1)
    {
         vInfectedFile="--copy";
    }
    else
    {
         vInfectedFile="--move";
    }
    if (mdSuspectedFiles->currentItem()==0)
    {
         vSuspectedFile="";
    }
    else
    if (mdSuspectedFiles->currentItem()==1)
    {
          vSuspectedFile="--copys";
    }
    else
    {
          vSuspectedFile="--moves";
    }
}

void frmPrincipale::valider()
{
       // cette procedure traite la partie "lancer le scan" et va chercher les diffrentes valeures dans les autres procedures
   if  (rbScannerDefault->isChecked())
   {
       fscan = "--files";	
       edit_rapport();
       action_fichier();
       divers();
       showAnalyse();
    }
   if  (rbScannerAll->isChecked())
   {
       fscan="--all";
       edit_rapport();
       action_fichier();	
       divers();
       showAnalyse();
    }
   if  (rbScannerArchive->isChecked())
   {
       fscan="--arc";
       edit_rapport();      
       action_fichier();   
       divers();       
       showAnalyse();
    }
    if (rbScannerMails->isChecked())
   {
      fscan="--mail";
      edit_rapport();      
      action_fichier();
      divers();      
      showAnalyse();
    }	
    if (rbScannerNoArchive->isChecked())
   {
       fscan="--nopack";
       edit_rapport();
       action_fichier();
       divers();       
       showAnalyse();	
    }
   if  (rbScannerExtension->isChecked())
   {
       QString ext = leScanExtension->text();
       fscan="--ext="+ext;
       edit_rapport();
       action_fichier();       
       divers();       
       showAnalyse();
    }

}

void frmPrincipale::showAnalyse()
{
    //Lancement de la fentre de scan
       QString text = leScanFolder->text();
        proc = new QProcess( this );
        proc->addArgument( "bdc" );
        proc->addArgument( text );	
        proc->addArgument( fscan );
        proc->addArgument("--list");
        proc->addArgument( vCreateLog );
        proc->addArgument( vActionToDo );	
        proc->addArgument( vInfectedFile );
        proc->addArgument( vSuspectedFile );
        proc->addArgument( vDisplayWarning );	
        proc->addArgument( vAvoidRecurs );
        proc->addArgument( vDepthMaxArchive );
        proc->addArgument( vDepthMaxFolder );
        if ( !proc->start() )
        {
           erreur();
         }
          frmAnalyse * fnAna = new frmAnalyse(this);
          fnAna->exec();
}


void frmPrincipale::saveConfig()
{
        /*
      Rcupration de toutes les valeures de l'application et prparation du fichier
      de configuration.
    */
   if (rbScannerDefault->isChecked())
   {
       vScanFileDefault = "1";
   }
   else
   {
       vScanFileDefault = "0";
   }
   if (rbScannerAll->isChecked())
   {
       vScanAllFile = "1";
   }
   else
   {
       vScanAllFile = "0";
   }
   if (rbScannerArchive->isChecked())
   {
       vScanArchive = "1";
   }
   else
   {
       vScanArchive = "0";
   }
   if (rbScannerMails->isChecked())
   {
      vScanMails = "1";
   }
   else
   {
       vScanMails = "0";
   }
   if (rbScannerNoArchive->isChecked())
   {
       vNoScanArchive = "1";
   }
   else
   {
       vNoScanArchive = "0";
   }
   if (rbScannerExtension->isChecked())
   {
       vScanExt = "1";
   }
   else
   {
       vScanExt = "0";
    }
   QVariant ll = mdLanguage->currentItem();
   vLanguage = ll.toString();
   QVariant ww = mdThemes->currentItem();
   vThemes = ww.toString();
   QVariant gg = mdActions->currentItem();
   vActionToDo = gg.toString();
   QVariant hh = mdInfectedFiles->currentItem();
   vInfectedFile = hh.toString();
   QVariant ii = mdSuspectedFiles->currentItem();
   vSuspectedFile = ii.toString();
   if (cbWarning->isChecked())
   {
      vDisplayWarning = "1";
   }
   else
   {
       vDisplayWarning = "0";
   }
   if (cbAvoidRecurs->isChecked())
   {
       vAvoidRecurs = "1";
   }
   else
   {
       vAvoidRecurs = "0";
   }
   if (cbDepthMaxArchive->isChecked())
   {
       vDepthMaxArchive = "1";
   }
   else
   {
       vDepthMaxArchive = "0";
   }
   if (cbDepthMaxFolder->isChecked())
   {
      vDepthMaxFolder = "1";
  }
   else
   {
       vDepthMaxFolder = "0";
   }
   QVariant nn = sbDepthMaxArchive->value();
   vnDepthMaxArchive = nn.toString();
   QVariant oo = sbDepthMaxFolder->value();
   vnDepthMaxFolder = oo.toString();
   if (cbCreateLogFile->isChecked())
   {
      vCreateLog = "1";
  }
   else
   {
       vCreateLog = "0";
   }
   QVariant rr = sbCountDays->value();
   vCountDays = rr.toString();
   if (cbActiveAlert->isChecked())
   {
       vActiveAlert = "1";
   }
   else
   {
       vActiveAlert = "0";
   }	   
	   
    
    QFile fichier_conf( App_Folder + "/.bdfeui.conf");
    if ( !fichier_conf.open( IO_WriteOnly ) )
        return;

    const int Indent = 4;
    
    QDomDocument doc;
    QDomElement root = doc.createElement("config");
    QDomElement defaut = doc.createElement("defaut");
    QDomElement all = doc.createElement("all");
    QDomElement archive = doc.createElement("archive");
    QDomElement mails = doc.createElement("mails");
    QDomElement noscanarch = doc.createElement("noscanarch");
    QDomElement scanext = doc.createElement("scanext");
    QDomElement acttodo = doc.createElement("acttodo");
    QDomElement infectfile = doc.createElement("infectfile");
    QDomElement suspectfile = doc.createElement("suspectfile");
    QDomElement displaywarn = doc.createElement("displaywarn");
    QDomElement avoidrecurs = doc.createElement("avoidrecurs");
    QDomElement depthmaxarch = doc.createElement("depthmaxarch");
    QDomElement depthmaxfold = doc.createElement("depthmaxfold");
    QDomElement valdepthmaxarch = doc.createElement("valdepthmaxarch");
    QDomElement valdepthmaxfold = doc.createElement("valdepthmaxfold");
    QDomElement createlogfile = doc.createElement("createlogfile");
    QDomElement language = doc.createElement("language");
    QDomElement countdays = doc.createElement("countdays");
    QDomElement activealert = doc.createElement("activealert");
    QDomElement completelanguage = doc.createElement("completelanguage");    
    QDomElement itemthemes = doc.createElement("itemthemes");
    QDomElement themes = doc.createElement("themes");
    QDomText defautText = doc.createTextNode(vScanFileDefault);
    QDomText allText = doc.createTextNode(vScanAllFile);
    QDomText archiveText = doc.createTextNode(vScanArchive);
    QDomText mailsText = doc.createTextNode(vScanMails);
    QDomText noscanarchText = doc.createTextNode(vNoScanArchive);
    QDomText scanextText = doc.createTextNode(vScanExt);
    QDomText acttodoText = doc.createTextNode(vActionToDo);
    QDomText infectfileText = doc.createTextNode(vInfectedFile);
    QDomText suspectfileText = doc.createTextNode(vSuspectedFile);
    QDomText displaywarnText = doc.createTextNode(vDisplayWarning);
    QDomText avoidrecursText = doc.createTextNode(vAvoidRecurs);
    QDomText depthmaxarchText = doc.createTextNode(vDepthMaxArchive);
    QDomText depthmaxfoldText = doc.createTextNode(vDepthMaxFolder);
    QDomText valdepthmaxarchText = doc.createTextNode(vnDepthMaxArchive);
    QDomText valdepthmaxfoldText = doc.createTextNode(vnDepthMaxFolder);
    QDomText createlogfileText = doc.createTextNode(vCreateLog);
    QDomText languageText = doc.createTextNode(vLanguage);
    QDomText countdaysText = doc.createTextNode(vCountDays);
    QDomText activealertText = doc.createTextNode(vActiveAlert);
    QDomText completelanguageText = doc.createTextNode(lng);
    QDomText itemthemesText = doc.createTextNode(vThemes);
    QDomText themesText = doc.createTextNode(ths);
    doc.appendChild(root);
    root.appendChild(defaut);
    root.appendChild(all);
    root.appendChild(archive);
    root.appendChild(mails);
    root.appendChild(noscanarch);
    root.appendChild(scanext);
    root.appendChild(acttodo);
    root.appendChild(infectfile);
    root.appendChild(suspectfile);
    root.appendChild(displaywarn);
    root.appendChild(avoidrecurs);
    root.appendChild(depthmaxarch);
    root.appendChild(depthmaxfold);
    root.appendChild(valdepthmaxarch);
    root.appendChild(valdepthmaxfold);
    root.appendChild(createlogfile);
    root.appendChild(language);
    root.appendChild(countdays);
    root.appendChild(activealert);
    root.appendChild(completelanguage);
    root.appendChild(itemthemes);
    root.appendChild(themes);
    defaut.appendChild(defautText);
    all.appendChild(allText);
    archive.appendChild(archiveText);
    mails.appendChild(mailsText);
    noscanarch.appendChild(noscanarchText);
    scanext.appendChild(scanextText);
    acttodo.appendChild(acttodoText);
    infectfile.appendChild(infectfileText);
    suspectfile.appendChild(suspectfileText);
    displaywarn.appendChild(displaywarnText);
    avoidrecurs.appendChild(avoidrecursText);
    depthmaxarch.appendChild(depthmaxarchText);
    depthmaxfold.appendChild(depthmaxfoldText);
    valdepthmaxarch.appendChild(valdepthmaxarchText);
    valdepthmaxfold.appendChild(valdepthmaxfoldText);
    createlogfile.appendChild(createlogfileText);
    language.appendChild(languageText);
    countdays.appendChild(countdaysText);
    activealert.appendChild(activealertText);
    completelanguage.appendChild(completelanguageText);
    itemthemes.appendChild(itemthemesText);
    themes.appendChild(themesText);
    QTextStream ligne( &fichier_conf );
    doc.save(ligne, Indent);
}

void frmPrincipale::rien()
{
}

void frmPrincipale::erreur()
{
             QMessageBox::critical( 0,
                tr("Erreur Fatal"),
                tr("Impossible de lancer la commande bdc."),
                tr("Quitter") );
             exit( -1 );
}

void frmPrincipale::UpdateVirusList()
{
       // vrifie l'existence de mise  jour de la base virale sur Internet, la connection internet doit tre active
        proc = new QProcess( this );
        proc->addArgument( "bdc" );	
        proc->addArgument( "--update" );
        connect( proc, SIGNAL(readyReadStdout()), this, SLOT(rien()) );
        if ( !proc->start() )
        {
          erreur();
         }
         lblUpdateNow->show();
         pbUpdateNow->show();
         btnUpdateNow->setEnabled(false);
         btnScanNow->setEnabled(false);
         btnSaveConfig->setEnabled(false);
         btnQuit->setEnabled(false);
         timer->start( 5000, FALSE);
         connect( timer, SIGNAL(timeout()), SLOT(etat()) );   
         connect( proc, SIGNAL(processExited()), this, SLOT(changelabel()) );
}

void frmPrincipale::changelabel()
{
    if (timer->isActive())
    {
    timer->stop();	
    pbUpdateNow->setProgress(100);
    lblUpdateNow->setText(tr("Mise  jour termine !"));
    btnUpdateNow->setEnabled(true);
    btnScanNow->setEnabled(true);
    btnSaveConfig->setEnabled(true);
    btnQuit->setEnabled(true);
    pbUpdateNow->hide();
   //NOUVELLE CONFIGURATION BASEE SUR LA DATE DU FICHIER UPDATE.TXT
   /*QFile fichier("/opt/bdc/Plugins/update.txt");
    if ( fichier.open( IO_ReadOnly ) ) 
   {
        QTextStream flux( &fichier );   
        line = flux.readLine(); 
	fichier.close();
        mois = line.mid( 17, 3 );
        if (mois=="Jan") mois = "01";
        if (mois=="Feb") mois = "02";
        if (mois=="Mar") mois = "03";
        if (mois=="Apr") mois = "04";
        if (mois=="May") mois = "05";
        if (mois=="Jun") mois = "06";
        if (mois=="Jul") mois = "07";
        if (mois=="Aug") mois = "08";
        if (mois=="Sep") mois = "09";
        if (mois=="Oct") mois = "10";
        if (mois=="Nov") mois = "11";
        if (mois=="Dec") mois = "12";
        jour = line.mid(21,2);
        annee = line.mid(33,4);
        update_txt = annee +"-"+mois+"-"+jour;
        dater = dater.fromString(update_txt, ISODate);
    }*/
   /* if (dater.addDays(val)<=date) 
    {
                pmlInfo->setText(tr("La base de donnes antivirale n'est pas  jour ! ") + dater.toString());
                pmlInfo->setPaletteBackgroundColor(QColor(255,0,0));
                tbGeneral->setCurrentIndex(1);
    }
    else
    {
                pmlInfo->setText(tr("La base de donnes antivirale est  jour  ( ") + dater.toString() + " )");
	pmlInfo->setPaletteBackgroundColor(QColor(0,255,0));	
    }
    pmlInfo->setText(tr("La base de donnes antivirale est  jour  ( ") + dater.toString() + " )");
    pmlInfo->setPaletteBackgroundColor(QColor(0,255,0));*/
    }
    cptPB=1;
    timer->stop();
}

void frmPrincipale::etat()
{
   cptPB+=1;
   pbUpdateNow->setProgress(cptPB);
}

void frmPrincipale::dbvirale()
{
       QString text = leScanFolder->text();
        proc = new QProcess( this );
        proc->addArgument( "bdc" );
        proc->addArgument( text );	
        proc->addArgument( "--vlist" );	
        proc->addArgument( "--log" );	
        connect( proc, SIGNAL(readyReadStdout()), this, SLOT(rien()) );
        connect( proc, SIGNAL(processExited()), this, SLOT(rien()) );
        if ( !proc->start() )
        {
            erreur();
         }
}

void frmPrincipale::readFromStdout() 
{
    tbMiscInformations->clear();
    while (proc->canReadLineStdout()) 
    {
        QString line = proc->readLineStdout();
        tbMiscInformations->append(line);
    }
}

void frmPrincipale::enabledsbDepthMaxArc()
{
    if (cbDepthMaxArchive->isChecked())
    {
	sbDepthMaxArchive->setEnabled(true);
    }
    else
    {
	sbDepthMaxArchive->setEnabled(false);
    }
}

void frmPrincipale::enabledsbDepthMaxFold()
{
    if (cbDepthMaxFolder->isChecked())
    {
	sbDepthMaxFolder->setEnabled(true);
    }
    else
    {
	sbDepthMaxFolder->setEnabled(false);
    }	
}


void frmPrincipale::recuperation_lng()
{
   lng = mdLanguage->currentText();
}


void frmPrincipale::recuperation_ths()
{
  ths = mdThemes->currentText(); 
}
