package GNUACEWorkspaceCreator;

# ************************************************************
# Description   : A GNU Workspace (Makefile) creator for ACE
# Author        : Chad Elliott
# Create Date   : 5/13/2002
# ************************************************************

# ************************************************************
# Pragmas
# ************************************************************

use strict;
use File::Basename;

use GNUACEProjectCreator;
use WorkspaceCreator;

use vars qw(@ISA);
@ISA = qw(WorkspaceCreator);

# ************************************************************
# Data Section
# ************************************************************

my(@targets)  = ('all', 'debug', 'profile', 'optimize',
                 'install', 'deinstall', 'clean', 'realclean',
                 'clobber', 'depend', 'rcs_info', 'idl_stubs',
                );

# ************************************************************
# Subroutine Section
# ************************************************************

sub generate_implicit_project_dependencies {
  #my($self) = shift;
  return 1;
}


sub workspace_file_name {
  my($self) = shift;
  return $self->get_modified_workspace_name('Makefile', '');
}


sub workspace_per_project {
  #my($self) = shift;
  return 1;
}


sub pre_workspace {
  my($self) = shift;
  my($fh)   = shift;
  my($crlf) = $self->crlf();

  print $fh "#----------------------------------------------------------------------------$crlf" .
            "#       GNU ACE Workspace$crlf" .
            "#$crlf" .
            "# \@file Makefile$crlf" .
            "#$crlf" .
            "# \$Id\$$crlf" .
            "#$crlf" .
            "# This file was automatically generated by MPC.  Any changes made directly to$crlf" .
            "# this file will be lost the next time it is generated.$crlf" .
            "#$crlf" .
            "#----------------------------------------------------------------------------$crlf" .
            $crlf;
}


sub write_comps {
  my($self)     = shift;
  my($fh)       = shift;
  my($crlf)     = $self->crlf();
  my($projects) = $self->get_projects();
  my(%targnum)  = ();
  my($pjs)      = $self->get_project_info();
  my(@list)     = $self->number_target_deps($projects, $pjs, \%targnum);

  ## Only use the list if there is more than one project
  if ($#list > 0) {
    my($count) = 0;

    ## Print out the info for using -k
    print $fh $crlf .
              "MAKE_OPTIONS=\$(shell echo \$(MAKEFLAGS) | sed 's/--unix *//; s/ .*//')$crlf" .
              "ifeq (\$(findstring k,\$(MAKE_OPTIONS)),k)$crlf" .
              "  KEEP_GOING = 1$crlf" .
              "else$crlf" .
              "  KEEP_GOING = 0$crlf" .
              "endif$crlf";

    $count = $#list + 1;

    ## Print the targets for each of the above projects
    foreach my $target (@targets) {
      my($tlen) = length($target);
      my($cutoff) = int((80 - ($tlen + 1)) / ($tlen + 8));
      my($splitter) = 0;
      print $fh "$crlf$crlf$target:";
      for(my $i = 0; $i < $count; ++$i) {
        print $fh " $target." . $$pjs{$list[$i]}->[0];
        ++$splitter;
        if ($i != $count - 1 && $splitter == $cutoff) {
          print $fh " \\$crlf " . (' ' x $tlen);
          $splitter = 0;
        }
      }
    }
    print $fh $crlf;

    ## Print out each of the individual targets
    foreach my $project (@list) {
      my($pjname) = $$pjs{$project}->[0];
      print $fh "$crlf$pjname: all.$pjname$crlf" .
                ".PHONY: $pjname$crlf$crlf" .
                "%.$pjname:";
      if (defined $targnum{$project}) {
        foreach my $number (@{$targnum{$project}}) {
          print $fh ' %.' .
                    $$pjs{$list[$number]}->[0];
        }
      }
      my($cmd) = "\@\$(MAKE) -f " . basename($project) . ' -C ' . dirname($project) . " \$(*);$crlf";
      print $fh $crlf .
                "ifeq (\$(KEEP_GOING),1)$crlf" .
                "\t-$cmd" .
                "else$crlf" .
                "\t$cmd" .
                "endif$crlf";
    }

    ## Print out the reverseclean target
    {
      my($target) = "reverseclean";
      my($tlen) = length($target);
      my($rlen) = length("realclean");
      my($cutoff) = int((80 - ($rlen + 1)) / ($rlen + 8));
      my($splitter) = 0;
      print $fh "$crlf$crlf$target:";
      for(my $i = $count - 1; $i >= 0; --$i) {
        print $fh ' realclean.' . $$pjs{$list[$i]}->[0];
        ++$splitter;
        if ($i != 0 && $splitter == $cutoff) {
          print $fh " \\$crlf " . (' ' x $tlen);
          $splitter = 0;
        }
      }
    }
    print $fh "$crlf$crlf";
  }
  else {
    ## Otherwise, just list the call to make without a for loop
    my($dir)  = dirname($list[0]);
    my($base) = basename($list[0]);
    print $fh "TARGETS_NESTED = @targets$crlf" .
              $crlf .
              "\$(TARGETS_NESTED):$crlf" .
              "\t\@\$(MAKE) -f $base " . ($dir ne '.' ? "-C $dir " : '') .
              "\$(\@);$crlf$crlf" .
              $$pjs{$list[0]}->[0] . ": all$crlf$crlf" .
              "reverseclean:$crlf" .
              "\t\@\$(MAKE) -f $base " . ($dir ne '.' ? "-C $dir " : '') .
              "realclean$crlf$crlf";
  }

  print $fh "project_name_list:$crlf";
  foreach my $project (@list) {
    print $fh "\t\@echo $$pjs{$project}->[0]$crlf";
  }
}



1;
