#ifndef __SVGA256_H
#define __SVGA256_H

#ifndef __REGISTER_H
#include "register.h"
#endif

typedef unsigned int  word ;
typedef unsigned long dword;
struct _SVGA_Information {
        char Signature[4];
        word VESA_Version_Number;
        dword OEM_Name_Ptr;
        char Capabilities[4];
        dword VESA_Video_Modes;
        char Reserved[238];
};
struct _SVGA_Mode_Information {
        word Mode_Attributes;
        char Window_A_Attributes;
        char Window_B_Attributes;
        word Window_Granularity_K;
        word Window_Size_K;
        word Window_A_Start_Segment;
        word Window_B_Start_Segment;
        dword Positioning_Function;
        word Bytes_Per_Scan_Line;

        word Width_In_Pixels;
        word Height_In_Pixels;
        char WOCCIP;
        char HOCCIP;
        char Number_Of_Memory_Planes;
        char Bits_Per_Pixel;
        char Number_Of_Banks;
        char Memory_Model_Type;
        char Bank_Size_K;
        char Reserved [256-29];
} SVGA_Mode_Information;

int ScreenWidth   = 640;
int ScreenHeight  = 480;

#define SCREEN_SEGMENT     0xA000

int IsSVGAOk () {
        _AX = 0x4f00;
        asm int 0x10;
        ax = _AX;
        if (ax == 0x004f) return 1;
        return 0;
};

void SetSVGAMode (unsigned int Mode = 0x101) {
        bx = Mode;
        _AX = 0x4F02;
        _BX = bx;
        asm int 0x10;
};

void GetSVGAModeInformation (unsigned int Mode) {
        es = FP_SEG (&SVGA_Mode_Information);
        di = FP_OFF (&SVGA_Mode_Information);

        _AX = 0x4F01;
        _CX = Mode;
        _ES = es;
        _DI = di;
        asm int 0x10;
};

unsigned int GetSVGAMode () {
        _AX = 0x4f03;
        asm int 0x10;
        ax = _AX;
        bx = _BX;
        if (ax != 0x004f) return 0;
        return bx;
};

void SetTextMode () {
        _AX = 3;
        asm int 0x10;
};

void TurnVESA_On_Off () {
        _AX = 0x4fff;
        asm int 0x10;
};

int CurBank = 0xFFFF;

void PutPixel (int x, int y, int color) {
        unsigned long BitmapAddress = (unsigned long) y * 640L + x;
        unsigned int Bank = BitmapAddress >> 16;
				if (Bank != CurBank) {
                CurBank = Bank;
                asm {
                        mov ax, 0x4f05
                        xor bx, bx
                        mov dx, Bank
                        int 0x10
                };
        };
        *((unsigned char far *)MK_FP (SCREEN_SEGMENT, (unsigned int)BitmapAddress)) = color;
};

#endif
