/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#ifndef __VIDEO__
#define __VIDEO__

#include <string.h>
#include "types.h"

#define VID_MAX_SIZE_X  640
#define VID_MAX_SIZE_Y  480
#define VID_MAX_BRIGHT  64
#define MAX_RGB         256

const VID_AVG_BRIGHT = VID_MAX_BRIGHT/2;

extern bool vidInitialized;

struct vidRGB { uchar r,g,b,foo; };
typedef unsigned char* PAGE;
typedef vidRGB vidPalette[256];

extern "C" int vidSizeX, vidSizeY, vidPageSize, vidBytesPerLine,
               vidMaxPage;
extern int vidHiResMode, vidBlackColor, vidFrameCount, vidStartTime;

extern vidPalette vidCurrentPalette;

#define vidScaleX(x) ((float)(x)*vidSizeX/VID_MAX_SIZE_X)
#define vidScaleY(y) ((float)(y)*vidSizeY/VID_MAX_SIZE_Y)

// portable

void vidInitVideo();
void vidCloseVideo();
void vidSetPalette( vidPalette pal );
inline void vidGetPalette( vidPalette pal )
{
  memcpy( pal, vidCurrentPalette, sizeof(vidCurrentPalette) );
}
PAGE vidAllocPage();
void vidFreePage( PAGE page );
void vidMorphPalette( vidPalette pal1, vidPalette pal2, vidPalette to,
                      int step, int steps );
void vidCopyPage( PAGE topage, PAGE frompage );
void vidCopyPageT( PAGE topage, PAGE frompage );
void vidClearPage( PAGE page, int value = 0 );
void vidCombineSplitPage( PAGE c1, PAGE b1, PAGE c, PAGE b );
void vidShowPage( PAGE color, PAGE bw, uchar* dither_table );
extern "C" {
void vidDitherPage( PAGE colorpage, PAGE bwpage, PAGE topage,
                    uchar* dithertable );
#ifdef __WATCOMC__
#pragma aux vidDitherPage parm [eax] [ebx] [esi] [edi] modify [ecx edx];
#endif
}

// system dependant

void vidDoInitVideo();
int vidChooseVideoMode();
void vidSetVideoMode( int num );
void vidDoCloseVideo();
void vidDoSetPalette( vidPalette pal, int border );
void vidDoShowPage( PAGE color, PAGE bw, uchar* dither_table );
void vidMessage( char* msg );

#endif
