/*
 *
 *   qrash: the second portable demo in the world
 *
 *   Copyright (C) 1997  Queue Members Group Art Division
 *   Coded by Mad Max / Queue Members Group (Mike Shirobokov)
 *   <mad_max@qmg.rising.ru>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "video.h"
#include "misc.h"
#include "music.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#define XK_LATIN1
#define XK_MISCELLANY
#include <X11/keysymdef.h>

Display* display;
int nscreen;
Drawable window;
GC gc;
XImage* image;
XColor colors[256];
Visual* visual;
Colormap colormap=0;
int depth,real_depth;
char* image_data=0;
int bytesPerLine;
int pixel_size = 1;
#define rgb_bits 5
#define max_rgb (1<<rgb_bits)
unsigned long rgb_table[max_rgb][max_rgb][max_rgb];
PAGE current_page;
int rShift, gShift, bShift, rRange, gRange, bRange;

void vidDoInitVideo() {
  display = XOpenDisplay(0);
  if(display) {
    nscreen = DefaultScreen(display);
    window = XCreateSimpleWindow(display,RootWindow(display,nscreen),0,0,
                                 1,1,0,0,0 );
    XSetStandardProperties(display,window,PROJECT_NAME,PROJECT_NAME,0,0,0,0);
    XMapWindow(display,window);
    gc = XCreateGC(display,window,0,NULL);
    depth=DefaultDepth(display,nscreen);
    int nxpfv;
    XPixmapFormatValues* xpfv = XListPixmapFormats(display,&nxpfv);
    for( int i=0; i<nxpfv; i++ ) {
      if( depth == xpfv[i].depth )
        real_depth=xpfv[i].bits_per_pixel/8;
    }
//    printf("display depth=%d, bytes per pixel=%d\n",depth,real_depth);
    visual=DefaultVisual(display,nscreen);
    XEvent event;
    XSetWindowAttributes xswa;
    xswa.event_mask = KeyPress|KeyRelease;
    XChangeWindowAttributes(display,window, CWEventMask, &xswa );
  }
  else {
    error( "Cannot open display" );
  }
  if( visual->c_class == TrueColor |
     visual->c_class == StaticColor |
     visual->c_class == StaticGray ) {

    /* thanx to Eric Ludlam */

    rShift = 0;
    gShift = 0;
    bShift = 0;
    rRange = 1;
    gRange = 1;
    bRange = 1;
    int v;
    for (v = visual->red_mask; (v & 1) == 0; v >>= 1)
      rShift++;
    for (; (v & 1) == 1; v >>= 1)
      rRange <<= 1;
    for (v = visual->green_mask; (v & 1) == 0; v >>= 1)
      gShift++;
    for (; (v & 1) == 1; v >>= 1)
      gRange <<= 1;
    for (v = visual->blue_mask; (v & 1) == 0; v >>= 1)
      bShift++;
    for (; (v & 1) == 1; v >>= 1)
      bRange <<= 1;
  }
  else {
    colormap = XCreateColormap(display,window,visual,AllocAll);
  }
}

void vidSetVideoMode( int mode ) {
  vidBytesPerLine = vidSizeX = min( VID_MAX_SIZE_X, mode );
  vidSizeY = vidSizeX*3/4;;
  vidPageSize = vidBytesPerLine*vidSizeY;
  XMoveResizeWindow(display,window,
                    (DisplayWidth(display,nscreen)-vidSizeX*pixel_size)/2,
                    (DisplayHeight(display,nscreen)-vidSizeY*pixel_size)/2,
                    vidSizeX*pixel_size,vidSizeY*pixel_size);
  bytesPerLine = vidBytesPerLine*real_depth*pixel_size;
  if( image ) {
    XDestroyImage(image);
  }
  image_data = (char*)malloc(bytesPerLine*vidSizeY*pixel_size);
  image = XCreateImage(display,visual,depth,ZPixmap,0,image_data,
                       vidSizeX*pixel_size,vidSizeY*pixel_size,8,0);
  //    printf("image->bits_per_pixel=%d\n",image->bits_per_pixel);
  XSync(display,False);
  current_page = vidAllocPage();
}

void vidDoCloseVideo() {
  XDestroyWindow(display,window);
  if(image) XDestroyImage(image);
  XFreeGC(display,gc);
  XCloseDisplay(display);
}

int vidChooseVideoMode() {
  return VID_MAX_SIZE_X;
  char str[256];
  sprintf(str,"Enter horizontal resolution (up to %d) : ", VID_MAX_SIZE_X);
  int mode = sysGetNumber( str,1,VID_MAX_SIZE_X );
  pixel_size = sysGetNumber("Enter resolution unit size in pixels (1 or 2): ",
                            1,2 );
  return mode;
}

void vidDoSetPalette( vidPalette pal, int border ) {
  if( visual->c_class == TrueColor |
     visual->c_class == StaticColor |
     visual->c_class == StaticGray ) {
    for(int i=0; i<256; i++ ) {
      colors[i].pixel = (((pal[i].r * rRange) >> 8) << rShift) |
                        (((pal[i].g * gRange) >> 8) << gShift) |
                        (((pal[i].b * bRange) >> 8) << bShift);
    }
  }
  else {
    for(int i=0; i<256; i++ ) {
      colors[i].pixel=i;
      colors[i].red=pal[i].r<<8;
      colors[i].green=pal[i].g<<8;
      colors[i].blue=pal[i].b<<8;
      colors[i].flags=DoRed|DoGreen|DoBlue;
    }
    XStoreColors(display,colormap,colors,256);
    XSetWindowColormap(display,window,colormap);
  }
}

void vidShowPage( PAGE Page )
{
  if( real_depth == sizeof(char) ) {
    if( visual->c_class == TrueColor |
       visual->c_class == StaticColor |
       visual->c_class == StaticGray ) {
      switch( pixel_size ) {
      case 1: {
        int n = vidPageSize;
        for( int i=0; i<n; i+=4 ) {
          image_data[i]=colors[Page[i]].pixel;
          image_data[i+1]=colors[Page[i+1]].pixel;
          image_data[i+2]=colors[Page[i+2]].pixel;
          image_data[i+3]=colors[Page[i+3]].pixel;
        }
        break;
      }
      case 2:
        char *foo1=image_data;
        PAGE foo2=Page;
        for( int y=0; y<vidSizeY; y++ ) {
          int n = vidSizeX;
          for( int x=0; x<n; x++ ) {
            foo1[x*2]=foo1[x*2+1]=colors[foo2[x]].pixel;
          };
          memcpy( foo1+bytesPerLine,foo1,bytesPerLine);
          foo1+=bytesPerLine*2;
          foo2+=vidBytesPerLine;
        }
        break;
      }
    }
    else {
      switch( pixel_size ) {
      case 1: {
        memcpy( image_data, Page, vidPageSize );
        break;
      }
      case 2:
        char *foo1=image_data;
        PAGE foo2=Page;
        for( int y=0; y<vidSizeY; y++ ) {
          for( int x=0; x<vidSizeX; x++ ) {
            foo1[x*2]=foo1[x*2+1]=foo2[x];
          };
          memcpy( foo1+bytesPerLine,foo1,bytesPerLine);
          foo1+=bytesPerLine*2;
          foo2+=vidBytesPerLine;
        }
        break;
      }
    }
  }
  else if( real_depth == sizeof(short) ) {
    switch( pixel_size ) {
    case 1: {
      int n = vidPageSize;
      for( int i=0; i<n; i+=4 ) {
        ((short*)image_data)[i]=colors[Page[i]].pixel;
        ((short*)image_data)[i+1]=colors[Page[i+1]].pixel;
        ((short*)image_data)[i+2]=colors[Page[i+2]].pixel;
        ((short*)image_data)[i+3]=colors[Page[i+3]].pixel;
      }
      break;
    }
    case 2:
      short* foo1=(short*)image_data;
      PAGE foo2=Page;
      for( int y=0; y<vidSizeY; y++ ) {
        for( int x=0; x<vidSizeX; x++ ) {
          foo1[x*2]=foo1[x*2+1]=colors[foo2[x]].pixel;
        };
        memcpy( foo1+bytesPerLine,foo1,bytesPerLine);
        foo1+=bytesPerLine*2;
        foo2+=vidBytesPerLine;
      }
      break;
    }
  }
  else if( real_depth == sizeof(int) ) {
    switch( pixel_size ) {
    case 1: {
      int n = vidPageSize;
      for( int i=0; i<n; i+=4 ) {
        ((int*)image_data)[i]=colors[Page[i]].pixel;
        ((int*)image_data)[i+1]=colors[Page[i+1]].pixel;
        ((int*)image_data)[i+2]=colors[Page[i+2]].pixel;
        ((int*)image_data)[i+3]=colors[Page[i+3]].pixel;
      }
      break;
    }
    case 2:
      int* foo1=(int*)image_data;
      PAGE foo2=Page;
      for( int y=0; y<vidSizeY; y++ ) {
        for( int x=0; x<vidSizeX; x++ ) {
          foo1[x*2]=foo1[x*2+1]=colors[foo2[x]].pixel;
        };
        memcpy( foo1+bytesPerLine,foo1,bytesPerLine);
        foo1+=bytesPerLine*2;
        foo2+=vidBytesPerLine;
      }
      break;
    }
  }
  else if( real_depth == sizeof(long) ) {
    switch( pixel_size ) {
    case 1: {
      int n = vidPageSize;
      for( int i=0; i<n; i+=4 ) {
        ((long*)image_data)[i]=colors[Page[i]].pixel;
        ((long*)image_data)[i+1]=colors[Page[i+1]].pixel;
        ((long*)image_data)[i+2]=colors[Page[i+2]].pixel;
        ((long*)image_data)[i+3]=colors[Page[i+3]].pixel;
      }
      break;
    }
    case 2:
      long* foo1=(long*)image_data;
      PAGE foo2=Page;
      for( int y=0; y<vidSizeY; y++ ) {
        for( int x=0; x<vidSizeX; x++ ) {
          foo1[x*2]=foo1[x*2+1]=colors[foo2[x]].pixel;
        };
        memcpy( foo1+bytesPerLine,foo1,bytesPerLine);
        foo1+=bytesPerLine*2;
        foo2+=vidBytesPerLine;
      }
      break;
    }
  }
  else {
    char str[256];
    sprintf( str, "%d screen depth is not supported", depth );
    error(str);
  }
  XPutImage(display,window,gc,image,0,0,0,0,
            vidSizeX*pixel_size,vidSizeY*pixel_size);
}

void vidDoShowPage( PAGE color, PAGE bw, uchar* dither_table )
{
  vidDitherPage( color, bw, current_page, dither_table );
  vidShowPage(current_page);
}

void vidMessage( char* str )
{
  puts(str);
}

KB sysGetKey()
{
  XEvent event;
  if( XCheckWindowEvent(display,window,KeyPressMask,&event) ) {
    KeySym keysym = XLookupKeysym( &event.xkey, 0 );
    switch(keysym) {
      case XK_minus:
      case XK_KP_Subtract:
      {
        return KB_MINUS;
      }
      case XK_plus:
      case XK_KP_Add:
      {
        return KB_PLUS;
      }
      case XK_F11: {
        return KB_F11;
      }
      case XK_Escape: {
        return KB_ESC;
      }
      case XK_bracketright: {
        return KB_NEXT;
      }
    }
  }
  return KB_NONE;
}

